/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.context.ContextService;
import org.apache.derby.iapi.services.io.FormatableBitSet;
import org.apache.derby.iapi.services.locks.LockFactory;
import org.apache.derby.iapi.services.property.PropertyUtil;
import org.apache.derby.iapi.store.access.Qualifier;
import org.apache.derby.iapi.store.access.conglomerate.LogicalUndo;
import org.apache.derby.iapi.store.raw.ContainerHandle;
import org.apache.derby.iapi.store.raw.ContainerKey;
import org.apache.derby.iapi.store.raw.FetchDescriptor;
import org.apache.derby.iapi.store.raw.Page;
import org.apache.derby.iapi.store.raw.RawStoreFactory;
import org.apache.derby.iapi.store.raw.RecordHandle;
import org.apache.derby.iapi.store.raw.Transaction;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.SQLChar;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.store.T_RawStoreRow;
import org.apache.derbyTesting.unitTests.store.T_TWC;

public class T_Util {
    RawStoreFactory rsFactory;
    LockFactory lFactory;
    ContextService csFactory;
    private int openContainerMode;

    public T_Util(RawStoreFactory rsf, LockFactory lf, ContextService csf) {
        this.rsFactory = rsf;
        this.lFactory = lf;
        this.csFactory = csf;
        this.openContainerMode = 0;
    }

    public void setOpenMode(int newMode) {
        this.openContainerMode = newMode;
    }

    public void t_checkNullLockCount(Transaction t) throws T_Fail {
        if (this.lFactory.areLocksHeld(t.getCompatibilitySpace())) {
            throw T_Fail.testFailMsg("Previous action did not clean up all locks.");
        }
    }

    public static void t_checkPageNumber(Page page, long pageNumber) throws T_Fail {
        if (page.getPageNumber() != pageNumber) {
            throw T_Fail.testFailMsg("page number expected to be " + pageNumber + ", is " + page.getPageNumber());
        }
    }

    public static void t_checkRecordCount(Page page, int count, int nonDeleted) throws T_Fail, StandardException {
        if (page.recordCount() != count) {
            throw T_Fail.testFailMsg("recordCount() expected to be " + count + ", is " + page.recordCount());
        }
        if (page.nonDeletedRecordCount() != nonDeleted) {
            throw T_Fail.testFailMsg("nonDeletedRecordCount() expected to be " + nonDeleted + ", is " + page.nonDeletedRecordCount());
        }
    }

    public static void t_checkFieldCount(Page page, int slot, int count) throws T_Fail, StandardException {
        if (page.fetchNumFieldsAtSlot(slot) != count) {
            throw T_Fail.testFailMsg("number of fields at slot " + slot + " expected to be " + count + ", is " + page.fetchNumFieldsAtSlot(slot));
        }
    }

    public static void t_checkFetch(Page page, RecordHandle rh, String data, int stringLen) throws T_Fail, StandardException {
        T_Util.t_checkFetch(page, rh, T_Util.getStringFromData(data, stringLen));
    }

    public static void t_checkFetch(Page page, RecordHandle rh, String data) throws T_Fail, StandardException {
        if (!page.recordExists(rh, false)) {
            throw T_Fail.testFailMsg("Record does not exist");
        }
        T_RawStoreRow readRow = new T_RawStoreRow(null);
        int slot = page.getSlotNumber(rh);
        RecordHandle rhf = page.fetchFromSlot(rh, slot, (Object[])readRow.getRow(), (FetchDescriptor)null, false);
        if (rhf == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (data == null || readRow.getStorableColumn(0).isNull()) {
            if (data == null && readRow.getStorableColumn(0).isNull()) {
                return;
            }
            throw T_Fail.testFailMsg("Record's value incorrect");
        }
        if (!readRow.toString().equals(data)) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + data + ": - got :" + readRow.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t_checkFetch(ContainerHandle c, RecordHandle rh, String data) throws T_Fail, StandardException {
        Page page = this.t_getPage(c, rh.getPageNumber());
        try {
            T_Util.t_checkFetch(page, rh, data);
        }
        finally {
            page.unlatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t_checkFetchFail(ContainerHandle c, RecordHandle rh) throws T_Fail, StandardException {
        Page page = this.t_getPage(c, rh.getPageNumber());
        try {
            if (page.recordExists(rh, true)) {
                throw T_Fail.testFailMsg("Record Exists");
            }
        }
        finally {
            page.unlatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t_checkFetchDeleted(ContainerHandle c, RecordHandle rh, String data) throws T_Fail, StandardException {
        Page p = this.t_getPage(c, rh.getPageNumber());
        if (p == null) {
            throw T_Fail.testFailMsg("Page not found " + rh);
        }
        T_RawStoreRow readRow = new T_RawStoreRow(null);
        try {
            int slot = p.getSlotNumber(rh);
            if (p.fetchFromSlot(rh, slot, (Object[])readRow.getRow(), (FetchDescriptor)null, false) != null) {
                throw T_Fail.testFailMsg("Record at slot " + slot + " not deleted");
            }
        }
        finally {
            p.unlatch();
        }
    }

    public static void t_checkFetch(Page page, RecordHandle rh, T_RawStoreRow row) throws T_Fail, StandardException {
        if (!page.recordExists(rh, false)) {
            throw T_Fail.testFailMsg("Record does not exist");
        }
        int ncol = row.nColumns();
        T_RawStoreRow readRow = new T_RawStoreRow(ncol);
        for (int i = 0; i < ncol; ++i) {
            readRow.setColumn(i, (String)null);
        }
        RecordHandle rhf = page.fetchFromSlot(rh, page.getSlotNumber(rh), (Object[])readRow.getRow(), null, false);
        if (rhf == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (!readRow.toString().equals(row.toString())) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + row.toString() + ": - got :" + readRow.toString());
        }
    }

    public static void t_checkFetchCol(Page page, RecordHandle rh, int colNum, int numCols, String data) throws T_Fail, StandardException {
        if (!page.recordExists(rh, false)) {
            throw T_Fail.testFailMsg("Record does not exist");
        }
        T_RawStoreRow readRow = new T_RawStoreRow(numCols);
        for (int i = 0; i < numCols; ++i) {
            readRow.setColumn(i, (String)null);
        }
        FormatableBitSet colList = new FormatableBitSet(numCols);
        colList.set(colNum);
        FetchDescriptor desc = new FetchDescriptor(numCols, colList, (Qualifier[][])null);
        RecordHandle rhf = page.fetchFromSlot(rh, page.getSlotNumber(rh), (Object[])readRow.getRow(), desc, false);
        if (rhf == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        String col = readRow.getStorableColumn(colNum).toString();
        if (!col.equals(data)) {
            throw T_Fail.testFailMsg("Record's value for column " + colNum + " incorrect, expected :" + data + ": - got :" + readRow.toString());
        }
    }

    public static RecordHandle t_checkFetchFirst(Page page, String data) throws T_Fail, StandardException {
        T_RawStoreRow readRow = new T_RawStoreRow(null);
        int slot = 0;
        while (page.isDeletedAtSlot(slot)) {
            ++slot;
        }
        RecordHandle rhf = page.fetchFromSlot((RecordHandle)null, slot, (Object[])readRow.getRow(), (FetchDescriptor)null, false);
        if (rhf == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (!readRow.toString().equals(data)) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + data + ": - got :" + readRow.toString());
        }
        return rhf;
    }

    public static RecordHandle t_checkFetchNext(Page page, RecordHandle rh, String data) throws T_Fail, StandardException {
        if (!page.recordExists(rh, false)) {
            throw T_Fail.testFailMsg("Record does not exist");
        }
        T_RawStoreRow readRow = new T_RawStoreRow(null);
        int slot = page.getSlotNumber(rh) + 1;
        while (page.isDeletedAtSlot(slot)) {
            ++slot;
        }
        RecordHandle rhf = page.fetchFromSlot((RecordHandle)null, slot, (Object[])readRow.getRow(), (FetchDescriptor)null, false);
        if (rhf == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (!readRow.toString().equals(data)) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + data + ": - got :" + readRow.toString());
        }
        return rhf;
    }

    public static RecordHandle t_checkFetchPrevious(Page page, RecordHandle rh, String data) throws T_Fail, StandardException {
        int slot;
        if (!page.recordExists(rh, false)) {
            throw T_Fail.testFailMsg("Record does not exist");
        }
        T_RawStoreRow readRow = new T_RawStoreRow(null);
        for (slot = page.getSlotNumber(rh) - 1; page.isDeletedAtSlot(slot) && slot >= 0; --slot) {
        }
        if (slot == -1) {
            return null;
        }
        RecordHandle rhf = page.fetchFromSlot((RecordHandle)null, slot, (Object[])readRow.getRow(), (FetchDescriptor)null, false);
        if (rhf == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (!readRow.toString().equals(data)) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + data + ": - got :" + readRow.toString());
        }
        return rhf;
    }

    public static RecordHandle t_checkFetchLast(Page page, String data) throws T_Fail, StandardException {
        int slot;
        T_RawStoreRow readRow = new T_RawStoreRow(null);
        for (slot = page.recordCount() - 1; page.isDeletedAtSlot(slot) && slot >= 0; --slot) {
        }
        if (slot == -1) {
            return null;
        }
        RecordHandle rhf = page.fetchFromSlot((RecordHandle)null, slot, (Object[])readRow.getRow(), (FetchDescriptor)null, false);
        if (rhf == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (!readRow.toString().equals(data)) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + data + ": - got :" + readRow.toString());
        }
        return rhf;
    }

    public static void t_checkFetchBySlot(Page page, int slot, String data, boolean deleted, boolean forUpdate) throws T_Fail, StandardException {
        T_RawStoreRow readRow = new T_RawStoreRow(null);
        RecordHandle rh = page.fetchFromSlot((RecordHandle)null, slot, (Object[])readRow.getRow(), (FetchDescriptor)null, true);
        if (rh == null) {
            throw T_Fail.testFailMsg("Failed to read record");
        }
        if (!readRow.toString().equals(data)) {
            throw T_Fail.testFailMsg("Record's value incorrect, expected :" + data + ": - got :" + readRow.toString());
        }
        if (page.isDeletedAtSlot(slot) != deleted) {
            throw T_Fail.testFailMsg("Record at slot " + slot + " deleted=" + page.isDeletedAtSlot(slot) + ", expect " + deleted);
        }
    }

    public static void t_checkFetchColFromSlot(Page page, int slot, int fieldId, DataValueDescriptor column, boolean forUpdate, String data, int stringLen) throws StandardException, T_Fail {
        T_Util.t_checkFetchColFromSlot(page, slot, fieldId, column, forUpdate, T_Util.getStringFromData(data, stringLen));
    }

    public static void t_checkFetchColFromSlot(Page page, int slot, int fieldId, DataValueDescriptor column, boolean forUpdate, String data) throws StandardException, T_Fail {
        Object[] fetch_row = new DataValueDescriptor[fieldId + 1];
        fetch_row[fieldId] = column;
        FormatableBitSet validCols = new FormatableBitSet(fieldId + 1);
        validCols.set(fieldId);
        RecordHandle rh = page.fetchFromSlot(null, slot, fetch_row, new FetchDescriptor(fetch_row.length, validCols, (Qualifier[][])null), true);
        if (rh == null) {
            throw T_Fail.testFailMsg("Failed to fetch record: slot " + slot + " field " + fieldId);
        }
        if (data == null) {
            if (!column.isNull()) {
                throw T_Fail.testFailMsg("Failed to fetch null column: slot " + slot + " field " + fieldId + " column is " + column);
            }
        } else {
            if (column.isNull()) {
                throw T_Fail.testFailMsg("expect non null column, got null: slot " + slot + " field " + fieldId);
            }
            if (!column.toString().equals(data)) {
                throw T_Fail.testFailMsg("expect " + data + " got " + column.toString() + ": slot " + slot + " field " + fieldId);
            }
        }
    }

    public static void t_checkEmptyPage(Page page) throws T_Fail, StandardException {
        T_Util.t_checkRecordCount(page, 0, 0);
        try {
            page.fetchFromSlot((RecordHandle)null, 0, null, (FetchDescriptor)null, false);
            throw T_Fail.testFailMsg("fetchFromSlot() must throw exception on fetch from slot 0 on an empty page");
        }
        catch (StandardException standardException) {
            if (page.getRecordHandle(0) != null) {
                throw T_Fail.testFailMsg("obtained a RecordHandle for an empty page");
            }
            if (page.getRecordHandle(6) != null) {
                throw T_Fail.testFailMsg("obtained a RecordHandle for an empty page");
            }
            if (page.getAuxObject() != null) {
                throw T_Fail.testFailMsg("empty page has an aux object");
            }
            T_Util.t_readOnlySlotOutOfRange(page, 0);
            if (!page.spaceForInsert()) {
                throw T_Fail.testFailMsg("spaceForInsert() returned false on an empty page");
            }
            return;
        }
    }

    public static void t_readOnlySlotOutOfRange(Page page, int slot) throws T_Fail, StandardException {
        try {
            page.fetchFromSlot((RecordHandle)null, slot, (Object[])new DataValueDescriptor[0], (FetchDescriptor)null, true);
            throw T_Fail.testFailMsg("fetchFromSlot succeeded on out of range slot " + slot);
        }
        catch (StandardException se0) {
            if (se0.getSeverity() > 20000) {
                throw se0;
            }
            try {
                page.isDeletedAtSlot(slot);
                throw T_Fail.testFailMsg("isDeletedAtSlot succeeded on out of range slot " + slot);
            }
            catch (StandardException se2) {
                if (se2.getSeverity() > 20000) {
                    throw se2;
                }
                return;
            }
        }
    }

    public static void t_updateSlotOutOfRange(Page page, int slot) throws T_Fail, StandardException {
        try {
            page.deleteAtSlot(slot, false, (LogicalUndo)null);
            throw T_Fail.testFailMsg("deleteAtSlot succeeded on out of range slot " + slot);
        }
        catch (StandardException se0) {
            if (se0.getSeverity() > 20000) {
                throw se0;
            }
            try {
                page.deleteAtSlot(slot, true, (LogicalUndo)null);
                throw T_Fail.testFailMsg("deleteAtSlot succeeded on out of range slot " + slot);
            }
            catch (StandardException se02) {
                T_RawStoreRow row;
                block12: {
                    if (se02.getSeverity() > 20000) {
                        throw se02;
                    }
                    row = new T_RawStoreRow(null);
                    if (page.recordCount() != slot) {
                        try {
                            page.insertAtSlot(slot, (Object[])row.getRow(), (FormatableBitSet)null, (LogicalUndo)null, (byte)1, 100);
                            throw T_Fail.testFailMsg("insertAtSlot succeeded, on out of range slot " + slot);
                        }
                        catch (StandardException se03) {
                            if (se03.getSeverity() <= 20000) break block12;
                            throw se03;
                        }
                    }
                }
                try {
                    page.updateAtSlot(slot, (Object[])row.getRow(), (FormatableBitSet)null);
                    throw T_Fail.testFailMsg("updateAtSlot succeeded on out of range slot " + slot);
                }
                catch (StandardException se04) {
                    if (se04.getSeverity() > 20000) {
                        throw se04;
                    }
                    return;
                }
            }
        }
    }

    public static void t_checkInvalidSavePoint(Transaction t, String name) throws T_Fail, StandardException {
        try {
            t.rollbackToSavePoint(name, null);
            throw T_Fail.testFailMsg("non existent save point did not cause exception on rollbackToSavePoint");
        }
        catch (StandardException se) {
            try {
                t.releaseSavePoint(name, null);
                throw T_Fail.testFailMsg("non existent save point did not cause exception on releaseSavePoint");
            }
            catch (StandardException standardException) {
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t_checkInvalidSavePoint(T_TWC ctx, String name) throws T_Fail, StandardException {
        this.csFactory.setCurrentContextManager(ctx.cm);
        try {
            T_Util.t_checkInvalidSavePoint(ctx.tran, name);
        }
        finally {
            this.csFactory.resetCurrentContextManager(ctx.cm);
        }
    }

    public Transaction t_startTransaction() throws StandardException, T_Fail {
        Transaction t12 = this.rsFactory.startTransaction(this.csFactory.getCurrentContextManager(), "UserTransaction");
        if (t12 == null) {
            throw T_Fail.testFailMsg("Start a transaction");
        }
        this.t_checkNullLockCount(t12);
        return t12;
    }

    public Transaction t_startGlobalTransaction(int format_id, byte[] global_id, byte[] branch_id) throws StandardException, T_Fail {
        Transaction t12 = this.rsFactory.startGlobalTransaction(this.csFactory.getCurrentContextManager(), format_id, global_id, branch_id);
        if (t12 == null) {
            throw T_Fail.testFailMsg("Start a transaction");
        }
        this.t_checkNullLockCount(t12);
        return t12;
    }

    public T_TWC t_startTransactionWithContext() throws StandardException, T_Fail {
        T_TWC ctx = new T_TWC(this.csFactory, this.lFactory, this.rsFactory);
        ctx.startUserTransaction();
        return ctx;
    }

    public Transaction t_startInternalTransaction() throws StandardException, T_Fail {
        Transaction t12 = this.rsFactory.startInternalTransaction(this.csFactory.getCurrentContextManager());
        if (t12 == null) {
            throw T_Fail.testFailMsg("Failed to start an internal transaction");
        }
        this.t_checkNullLockCount(t12);
        return t12;
    }

    public void t_commit(Transaction t) throws StandardException, T_Fail {
        t.commit();
        this.t_checkNullLockCount(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t_commit(T_TWC ctx) throws StandardException, T_Fail {
        this.csFactory.setCurrentContextManager(ctx.cm);
        try {
            this.t_commit(ctx.tran);
        }
        finally {
            this.csFactory.resetCurrentContextManager(ctx.cm);
        }
    }

    public void t_close(T_TWC ctx) throws StandardException, T_Fail {
        ctx.tran.close();
        ctx.tran = null;
        ctx.cm = null;
    }

    public void t_abort(Transaction t) throws StandardException, T_Fail {
        t.abort();
        this.t_checkNullLockCount(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t_abort(T_TWC ctx) throws StandardException, T_Fail {
        this.csFactory.setCurrentContextManager(ctx.cm);
        try {
            this.t_abort(ctx.tran);
        }
        finally {
            this.csFactory.resetCurrentContextManager(ctx.cm);
        }
    }

    public long t_addContainer(Transaction t, long segmentId) throws StandardException, T_Fail {
        long cid = t.addContainer(segmentId, 0L, 0, (Properties)null, 0);
        if (cid < 0L) {
            throw T_Fail.testFailMsg("add container");
        }
        return cid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long t_addContainer(T_TWC ctx, long segmentId) throws StandardException, T_Fail {
        this.csFactory.setCurrentContextManager(ctx.cm);
        try {
            long l = this.t_addContainer(ctx.tran, segmentId);
            return l;
        }
        finally {
            this.csFactory.resetCurrentContextManager(ctx.cm);
        }
    }

    public long t_addContainer(Transaction t, long segmentId, int pageSize) throws StandardException, T_Fail {
        Properties tableProperties = new Properties();
        tableProperties.put("derby.storage.pageSize", Integer.toString(pageSize));
        long cid = t.addContainer(segmentId, 0L, 0, tableProperties, 0);
        if (cid < 0L) {
            throw T_Fail.testFailMsg("add container");
        }
        return cid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long t_addContainer(T_TWC ctx, long segmentId, int pageSize) throws StandardException, T_Fail {
        this.csFactory.setCurrentContextManager(ctx.cm);
        try {
            long l = this.t_addContainer(ctx.tran, segmentId, pageSize);
            return l;
        }
        finally {
            this.csFactory.resetCurrentContextManager(ctx.cm);
        }
    }

    public long t_addContainer(Transaction t, long segmentId, Properties tableProperties) throws StandardException, T_Fail {
        long cid = t.addContainer(segmentId, 0L, 0, tableProperties, 0);
        if (cid < 0L) {
            throw T_Fail.testFailMsg("add container");
        }
        return cid;
    }

    public long t_addContainer(Transaction t, long segmentId, int pageSize, int spareSpace, int minimumRecordSize, boolean reusableRecordId) throws StandardException, T_Fail {
        long cid;
        Properties tableProperties = new Properties();
        tableProperties.put("derby.storage.pageSize", Integer.toString(pageSize));
        tableProperties.put("derby.storage.pageReservedSpace", Integer.toString(spareSpace));
        tableProperties.put("derby.storage.minimumRecordSize", Integer.toString(minimumRecordSize));
        if (reusableRecordId) {
            tableProperties.put("derby.storage.reusableRecordId", "true");
        }
        if ((cid = t.addContainer(segmentId, 0L, 0, tableProperties, 0)) < 0L) {
            throw T_Fail.testFailMsg("add container");
        }
        return cid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long t_addContainer(T_TWC ctx, long segmentId, int pageSize, int spareSpace, int minimumRecordSize) throws StandardException, T_Fail {
        this.csFactory.setCurrentContextManager(ctx.cm);
        try {
            long l = this.t_addContainer(ctx.tran, segmentId, pageSize, spareSpace, minimumRecordSize, false);
            return l;
        }
        finally {
            this.csFactory.resetCurrentContextManager(ctx.cm);
        }
    }

    public ContainerHandle t_openContainer(Transaction t, long segmentId, long containerId, boolean forUpdate) throws StandardException, T_Fail {
        ContainerKey id = new ContainerKey(segmentId, containerId);
        ContainerHandle c = t.openContainer(id, forUpdate ? 4 | this.openContainerMode : 8);
        if (c == null) {
            throw T_Fail.testFailMsg("ContainerHandle failed to open: (" + segmentId + "," + containerId + ")");
        }
        return c;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ContainerHandle t_openContainer(T_TWC ctx, long segmentId, long containerId, boolean forUpdate) throws StandardException, T_Fail {
        this.csFactory.setCurrentContextManager(ctx.cm);
        try {
            ContainerHandle containerHandle = this.t_openContainer(ctx.tran, segmentId, containerId, forUpdate);
            return containerHandle;
        }
        finally {
            this.csFactory.resetCurrentContextManager(ctx.cm);
        }
    }

    public void t_dropContainer(Transaction t, long segmentId, long containerId) throws StandardException, T_Fail {
        t.dropContainer(new ContainerKey(segmentId, containerId));
    }

    public Page t_getLastPage(ContainerHandle c) throws T_Fail, StandardException {
        Page page = c.getFirstPage();
        if (page != null) {
            Page nextPage;
            while ((nextPage = c.getNextPage(page.getPageNumber())) != null) {
                page.unlatch();
                page = nextPage;
            }
        }
        return page;
    }

    public Page t_getPage(ContainerHandle c, long pageNumber) throws T_Fail, StandardException {
        Page page = c.getPage(pageNumber);
        if (page == null) {
            throw T_Fail.testFailMsg("fail to get page " + pageNumber + " from container " + c);
        }
        if (page.getPageNumber() != pageNumber) {
            throw T_Fail.testFailMsg("page expected to have page number " + pageNumber + ", has " + page.getPageNumber() + " Container " + c);
        }
        return page;
    }

    public Page t_addPage(ContainerHandle c) throws T_Fail, StandardException {
        Page page = c.addPage();
        if (page == null) {
            throw T_Fail.testFailMsg("addPage() returned null");
        }
        return page;
    }

    public void t_removePage(ContainerHandle c, Page p) throws T_Fail, StandardException {
        long pnum = p.getPageNumber();
        c.removePage(p);
        Page badp = c.getPage(pnum);
        if (badp != null) {
            throw T_Fail.testFailMsg("got a deallcated page back");
        }
    }

    public void t_checkGetLatchedPage(ContainerHandle c, long pageNumber) throws StandardException, T_Fail {
        final Thread me = Thread.currentThread();
        Runnable r = new Runnable(){

            public void run() {
                try {
                    Thread.sleep(2000L);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                me.interrupt();
            }
        };
        Thread interrupter = new Thread(r);
        interrupter.start();
        try {
            Page p = c.getPage(pageNumber);
            throw T_Fail.testFailMsg("got latched page");
        }
        catch (StandardException se) {
            if (!se.getMessageId().equals("08000")) {
                throw se;
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        try {
            if (interrupter.isAlive()) {
                interrupter.join();
            }
        }
        catch (InterruptedException ie) {
            // empty catch block
        }
    }

    public static RecordHandle t_insert(Page page, T_RawStoreRow row) throws T_Fail, StandardException {
        RecordHandle rh = page.insert((Object[])row.getRow(), (FormatableBitSet)null, (byte)1, 100);
        return rh;
    }

    public static RecordHandle t_insertAtSlot(Page page, int slot, T_RawStoreRow row) throws T_Fail, StandardException {
        RecordHandle rh = page.insertAtSlot(slot, (Object[])row.getRow(), (FormatableBitSet)null, (LogicalUndo)null, (byte)1, 100);
        return rh;
    }

    public static RecordHandle t_insertAtSlot(Page page, int slot, T_RawStoreRow row, byte insertFlag) throws T_Fail, StandardException {
        RecordHandle rh = page.insertAtSlot(slot, (Object[])row.getRow(), (FormatableBitSet)null, (LogicalUndo)null, insertFlag, 100);
        return rh;
    }

    public static RecordHandle t_insertAtSlot(Page page, int slot, T_RawStoreRow row, byte insertFlag, int overflowThreshold) throws T_Fail, StandardException {
        RecordHandle rh = page.insertAtSlot(slot, (Object[])row.getRow(), (FormatableBitSet)null, (LogicalUndo)null, insertFlag, overflowThreshold);
        return rh;
    }

    public RecordHandle t_insert(ContainerHandle c, T_RawStoreRow row) throws T_Fail, StandardException {
        Page page = c.getPageForInsert(0);
        boolean addedPage = false;
        if (page == null) {
            page = this.t_addPage(c);
            addedPage = true;
        } else if (!page.spaceForInsert((Object[])row.getRow(), (FormatableBitSet)null, 100)) {
            page.unlatch();
            page = this.t_addPage(c);
            addedPage = true;
        }
        RecordHandle rh = T_Util.t_insert(page, row);
        page.unlatch();
        if (rh == null) {
            if (addedPage) {
                throw T_Fail.testFailMsg("insert returned null on an empty page");
            }
            page = this.t_addPage(c);
            rh = T_Util.t_insert(page, row);
            page.unlatch();
        }
        return rh;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void t_update(ContainerHandle c, RecordHandle rh, T_RawStoreRow row) throws T_Fail, StandardException {
        Page page = this.t_getPage(c, rh.getPageNumber());
        try {
            int slot = page.getSlotNumber(rh);
            if (page.updateAtSlot(slot, (Object[])row.getRow(), null) == null) {
                throw T_Fail.testFailMsg("update failed");
            }
            T_Util.t_checkFetch(page, rh, row);
        }
        finally {
            page.unlatch();
        }
    }

    public void t_checkUpdateCol(Page page, RecordHandle rh, int colNum, int numCols, String data) throws T_Fail, StandardException {
        if (!page.recordExists(rh, false)) {
            throw T_Fail.testFailMsg("Record does not exist");
        }
        T_RawStoreRow writeRow = new T_RawStoreRow(numCols);
        for (int i = 0; i < numCols; ++i) {
            writeRow.setColumn(i, (String)null);
        }
        writeRow.setColumn(colNum, data);
        FormatableBitSet colList = new FormatableBitSet(numCols);
        colList.set(colNum);
        int slot = page.getSlotNumber(rh);
        if (page.updateAtSlot(slot, (Object[])writeRow.getRow(), colList) == null) {
            throw T_Fail.testFailMsg("update failed");
        }
        T_Util.t_checkFetchCol(page, rh, colNum, numCols, data);
    }

    public void t_checkStringLengthFetch(Page page, int slot, int expectedLength) throws T_Fail, StandardException {
        T_RawStoreRow rr = new T_RawStoreRow(null);
        page.fetchFromSlot((RecordHandle)null, slot, (Object[])rr.getRow(), (FetchDescriptor)null, true);
        String s = ((SQLChar)rr.getStorableColumn(0)).getString();
        if (s == null && expectedLength < 0) {
            return;
        }
        if (s != null && expectedLength < 0) {
            throw T_Fail.testFailMsg("Expected null string, fetched one of length " + s.length());
        }
        if (s == null) {
            throw T_Fail.testFailMsg("Expected string length " + expectedLength + " got null string");
        }
        if (s.length() != expectedLength) {
            throw T_Fail.testFailMsg("fetch string length incorrect expected " + expectedLength + " got " + s.length());
        }
    }

    public void t_genRandomFile(String fileName, String mode, int size) throws T_Fail {
        RandomAccessFile iFile = null;
        try {
            iFile = new RandomAccessFile(fileName, mode);
            for (int i = 0; i < size; ++i) {
                byte b = (byte)(i & 0xFF);
                b = (byte)(b >= 32 && b <= 126 ? (int)b : 32);
                iFile.write(b);
            }
            iFile.close();
        }
        catch (FileNotFoundException fnfe) {
            throw T_Fail.testFailMsg("cannot create new file");
        }
        catch (IOException ioe) {
            throw T_Fail.testFailMsg("io error, test failed");
        }
    }

    public static String getStringFromData(String data, int stringLen) {
        char[] ca = new char[stringLen];
        char[] sd = data.toCharArray();
        System.arraycopy(sd, 0, ca, 0, sd.length);
        return new String(ca);
    }

    public static void t_wait(int milliSecond) {
        Thread.currentThread();
        Thread.yield();
        try {
            Thread.currentThread();
            Thread.sleep(milliSecond);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public static Properties setEncryptionParam(Properties startParams) {
        String encryptionPassword = PropertyUtil.getSystemProperty((String)"testDataEncryption");
        String encryptionProvider = PropertyUtil.getSystemProperty((String)"testEncryptionProvider");
        if (encryptionPassword != null) {
            if (startParams == null) {
                startParams = new Properties();
            }
            startParams.put("dataEncryption", "true");
            startParams.put("bootPassword", encryptionPassword);
            if (encryptionProvider != null) {
                startParams.put("encryptionProvider", encryptionProvider);
            }
        }
        return startParams;
    }
}

