/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.services;

import java.util.Random;
import java.util.Vector;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.daemon.DaemonFactory;
import org.apache.derby.iapi.services.daemon.DaemonService;
import org.apache.derby.iapi.services.daemon.Serviceable;
import org.apache.derby.iapi.services.monitor.Monitor;
import org.apache.derbyTesting.unitTests.harness.T_Fail;
import org.apache.derbyTesting.unitTests.harness.T_MultiThreadedIterations;
import org.apache.derbyTesting.unitTests.services.T_Serviceable;

public class T_DaemonService
extends T_MultiThreadedIterations {
    private static DaemonService testDaemon;
    private static Random random;
    private Vector serviceRecord = new Vector(9, 1);

    public T_DaemonService() {
        random = new Random();
    }

    protected String getModuleToTestProtocolName() {
        return "org.apache.derby.iapi.services.daemon.DaemonFactory";
    }

    protected void setupTest() throws T_Fail {
        DaemonFactory daemonFactory;
        try {
            daemonFactory = (DaemonFactory)Monitor.startSystemModule((String)"org.apache.derby.iapi.services.daemon.DaemonFactory");
        }
        catch (StandardException mse) {
            throw T_Fail.exceptionFail(mse);
        }
        if (daemonFactory == null) {
            throw T_Fail.testFailMsg("cannot find daemon factory org.apache.derby.iapi.services.daemon.DaemonFactory");
        }
        try {
            testDaemon = daemonFactory.createNewDaemon("testDaemon");
        }
        catch (StandardException se) {
            throw T_Fail.exceptionFail(se);
        }
        if (testDaemon == null) {
            throw T_Fail.testFailMsg("cannot create new Daemon Service");
        }
    }

    protected void joinSetupTest() throws T_Fail {
        if (testDaemon == null) {
            throw T_Fail.testFailMsg("test deamon not set");
        }
    }

    protected T_MultiThreadedIterations newTestObject() {
        return new T_DaemonService();
    }

    protected void runTestSet() throws T_Fail {
        this.serviceRecord.clear();
        try {
            this.T01(testDaemon);
            this.T02(testDaemon);
            this.T03(testDaemon);
            this.t_checkStatus(testDaemon);
        }
        catch (StandardException se) {
            throw T_Fail.exceptionFail(se);
        }
    }

    private void T01(DaemonService daemon) throws T_Fail, StandardException {
        T_Serviceable s1 = new T_Serviceable(false);
        this.serviceRecord.addElement(s1);
        int clientNumber1 = daemon.subscribe((Serviceable)s1, false);
        s1.setClientNumber(clientNumber1);
        T_Serviceable s2 = new T_Serviceable(true);
        this.serviceRecord.addElement(s2);
        int clientNumber2 = daemon.subscribe((Serviceable)s2, true);
        s2.setClientNumber(clientNumber2);
        daemon.serviceNow(clientNumber2);
        s2.t_wait(1);
        this.randomSleep();
        s1.t_wait(1);
        s2.t_check(1);
        this.PASS("T01");
        this.randomSleep();
    }

    private void T02(DaemonService daemon) throws T_Fail, StandardException {
        int requeue = 10;
        T_Serviceable e1 = new T_Serviceable(1);
        this.serviceRecord.addElement(e1);
        daemon.enqueue((Serviceable)e1, true);
        T_Serviceable e2 = new T_Serviceable(requeue);
        this.serviceRecord.addElement(e2);
        daemon.enqueue((Serviceable)e2, true);
        T_Serviceable e3 = new T_Serviceable(1);
        this.serviceRecord.addElement(e3);
        daemon.enqueue((Serviceable)e3, false);
        T_Serviceable e4 = new T_Serviceable(requeue);
        this.serviceRecord.addElement(e4);
        daemon.enqueue((Serviceable)e4, false);
        this.randomSleep();
        e1.t_wait(1);
        e2.t_wait(1);
        e3.t_wait(1);
        e4.t_wait(1);
        e2.t_wait(requeue);
        e4.t_wait(requeue);
        e1.t_check(1);
        e3.t_check(1);
        this.PASS("T02");
        this.randomSleep();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void T03(DaemonService daemon) throws T_Fail, StandardException {
        int save;
        T_Serviceable s1 = new T_Serviceable(false);
        this.serviceRecord.addElement(s1);
        int sub1 = daemon.subscribe((Serviceable)s1, false);
        T_Serviceable e1 = new T_Serviceable(1);
        this.serviceRecord.addElement(e1);
        daemon.enqueue((Serviceable)e1, false);
        daemon.enqueue((Serviceable)e1, false);
        daemon.enqueue((Serviceable)e1, false);
        daemon.enqueue((Serviceable)e1, false);
        daemon.enqueue((Serviceable)e1, false);
        T_Serviceable s2 = new T_Serviceable(false);
        this.serviceRecord.addElement(s2);
        int sub2 = daemon.subscribe((Serviceable)s2, false);
        int realsub2 = daemon.subscribe((Serviceable)s2, false);
        s2.setClientNumber(realsub2);
        daemon.unsubscribe(sub1);
        daemon.unsubscribe(sub2);
        T_Serviceable t_Serviceable = s1;
        synchronized (t_Serviceable) {
            save = s1.timesServiced;
        }
        daemon.serviceNow(sub1);
        this.randomSleep();
        e1.t_wait(5);
        daemon.serviceNow(sub1);
        s2.t_wait(3);
        daemon.serviceNow(sub1);
        t_Serviceable = s1;
        synchronized (t_Serviceable) {
            int diff = s1.timesServiced - save;
            T_Fail.T_ASSERT(diff == 0 || diff == 1, "unsubscribed continue to get serviced");
            s1.timesServiced = 0;
        }
        sub1 = daemon.subscribe((Serviceable)s1, false);
        s1.setClientNumber(sub1);
        daemon.serviceNow(sub1);
        s1.t_wait(1);
        e1.t_check(5);
        this.PASS("T03");
        this.randomSleep();
    }

    private void t_checkStatus(DaemonService daemon) throws T_Fail {
        for (int i = 0; i < this.serviceRecord.size(); ++i) {
            T_Serviceable check = (T_Serviceable)this.serviceRecord.elementAt(i);
            if (check == null) continue;
            if (check.subscribed) {
                if (check.onDemandOnly) {
                    check.t_check(1);
                } else {
                    check.t_wait(10);
                }
                daemon.unsubscribe(check.getClientNumber());
                continue;
            }
            check.t_wait(check.timesRequeue);
        }
        this.PASS("T_CheckStatus");
    }

    private void randomSleep() throws StandardException {
        if (this.getNumThreads() > 1) {
            int nap = random.nextInt() % 100;
            if (nap < 0) {
                nap = -nap;
            }
            try {
                Thread.sleep(nap);
            }
            catch (InterruptedException ie) {
                throw StandardException.interrupt((InterruptedException)ie);
            }
        }
    }
}

