/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.unitTests.junit;

import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.iapi.services.info.JVMInfo;
import org.apache.derby.shared.common.sanity.AssertFailure;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.SecurityManagerSetup;

public class AssertFailureTest
extends BaseTestCase {
    private static String POLICY_FILENAME = "org/apache/derbyTesting/unitTests/junit/AssertFailureTest.policy";
    private static String NO_DUMP_POLICY_FILENAME = "org/apache/derbyTesting/unitTests/junit/AssertFailureTest1.policy";

    public AssertFailureTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("AssertFailureTest");
        try {
            Class.forName("org.apache.derby.shared.common.sanity.AssertFailure");
            suite.addTest((Test)new SecurityManagerSetup((Test)new AssertFailureTest("testAssertFailureThreadDump"), POLICY_FILENAME));
            suite.addTest((Test)new SecurityManagerSetup((Test)new AssertFailureTest("testAssertFailureNoThreadDump"), NO_DUMP_POLICY_FILENAME));
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return suite;
    }

    public void testAssertFailureThreadDump() {
        String s = new AssertFailure("AssertFailureTest").getThreadDump();
        if (JVMInfo.JDK_ID >= 6) {
            String expected = "---------------\nStack traces for all live threads:\nThread name=";
            AssertFailureTest.assertTrue((String)("String not correct. Expected to start with:\n<" + expected + ">...\nWas:\n<" + s + ">.\n"), (boolean)s.startsWith(expected));
        } else {
            String expected = "(Skipping thread dump because it is not supported on JVM 1.4)";
            AssertFailureTest.assertEquals((String)"String not correct.", (String)expected, (String)s.trim());
        }
    }

    public void testAssertFailureNoThreadDump() {
        String s = new AssertFailure("AssertFailureTest").getThreadDump();
        if (JVMInfo.JDK_ID >= 6) {
            String expected = "(Skipping thread dump because of insufficient permissions:\njava.security.AccessControlException:";
            AssertFailureTest.assertTrue((String)("String not correct. Expected: <" + expected + ">\nWas:\n<" + s + ">"), (boolean)s.startsWith(expected));
        } else {
            String expected = "(Skipping thread dump because it is not supported on JVM 1.4)";
            AssertFailureTest.assertEquals((String)"String not correct.", (String)expected, (String)s.trim());
        }
    }
}

