/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.oe.run;

import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;
import org.apache.derbyTesting.system.oe.load.ThreadInsert;
import org.apache.derbyTesting.system.oe.run.Checks;
import org.apache.derbyTesting.system.oe.run.Schema;

public class Populate
extends JDBCPerfTestCase {
    static short scale = 1;
    static int loaderThreads;
    private static boolean createConstraintsBeforeLoad;
    private static boolean doChecks;

    public Populate(String name) {
        super(name);
    }

    public static void main(String[] args) throws Exception {
        Populate.parseArgs(args);
        String[] tmp = new String[]{"org.apache.derbyTesting.system.oe.run.Populate"};
        TestRunner.main((String[])tmp);
    }

    static void parseArgs(String[] args) {
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i];
            if (arg.equals("-scale")) {
                scale = Short.parseShort(args[++i]);
                continue;
            }
            if (arg.equals("-createConstraintsBeforeLoad")) {
                createConstraintsBeforeLoad = !args[++i].equals("false");
                continue;
            }
            if (arg.equals("-doChecks")) {
                doChecks = !args[++i].equals("false");
                continue;
            }
            if (arg.equals("-loaderThreads")) {
                loaderThreads = Integer.parseInt(args[++i]);
                continue;
            }
            if (arg.equals("-help")) {
                Populate.printUsage();
                System.exit(0);
                continue;
            }
            System.err.println("Invalid option: " + args[i]);
            System.exit(1);
        }
    }

    private static void printUsage() {
        System.out.println("Usage: java org.apache.derbyTesting.system.oe.run.Populate options");
        System.out.println();
        System.out.println("Options:");
        System.out.println("  -scale warehouse scaling factor. Takes a short value. If not specified defaults to 1");
        System.out.println("  -createConstraintsBeforeLoad create constraints before initial load of data, takes a boolean value. If not specified, defaults to true)");
        System.out.println("  -doChecks check consistency of data, takes a boolean value. If not specified, defaults to true)");
        System.out.println("  -loaderThreads number of threads used to populate database, defaults to number of cpu cores)");
        System.out.println("  -help prints usage");
        System.out.println();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("Order Entry");
        suite.addTest((Test)new Populate("testCreateDB"));
        Schema.addBaseSchema(suite);
        if (createConstraintsBeforeLoad) {
            Schema.addConstraints(suite);
        }
        suite.addTest((Test)new Populate("testLoad"));
        if (!createConstraintsBeforeLoad) {
            Schema.addConstraints(suite);
        }
        if (doChecks) {
            suite.addTest(Checks.checkAllRowCounts(scale));
            suite.addTest(Checks.consistencyChecks());
        }
        return suite;
    }

    public void testCreateDB() throws SQLException {
        DataSource ds = JDBCDataSource.getDataSource();
        JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
        ds.getConnection().close();
    }

    public void testLoad() throws Exception {
        DataSource ds = JDBCDataSource.getDataSource();
        ThreadInsert loader = new ThreadInsert(ds);
        loader.setupLoad(this.getConnection(), scale);
        if (loaderThreads > 0) {
            loader.setThreadCount(loaderThreads);
        }
        loader.populateAllTables();
    }

    static {
        createConstraintsBeforeLoad = true;
        doChecks = true;
    }
}

