/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.system.nstest.tester;

import org.apache.derbyTesting.system.nstest.NsTest;
import org.apache.derbyTesting.system.nstest.tester.TesterObject;

public class Tester2
extends TesterObject {
    public Tester2(String name) {
        super(name);
    }

    public void startTesting() {
        for (int i = 0; i < NsTest.MAX_ITERATIONS; ++i) {
            this.connex = this.getConnection();
            if (this.connex == null) {
                System.out.println("FAIL: " + this.getThread_id() + " could not get database connection");
                return;
            }
            try {
                this.connex.setAutoCommit(false);
            }
            catch (Exception e) {
                System.out.println("FAIL: " + this.getThread_id() + "'s setAutoCommit() failed:");
                this.printException("setting AutoCommit in Tester2", e);
            }
            this.setIsolationLevel(1);
            for (int numOp = 1; numOp < NsTest.MAX_OPERATIONS_PER_CONN; ++numOp) {
                int rnum = (int)(Math.random() * 100.0) % 4;
                switch (rnum) {
                    case 0: {
                        try {
                            int numSelected = this.doSelectOperation(NsTest.MAX_LOW_STRESS_ROWS);
                            System.out.println(this.getThread_id() + " selected " + numSelected + " rows");
                        }
                        catch (Exception e) {
                            System.out.println("doSelect in thread " + this.getThread_id() + " threw ");
                            this.printException("doSelectOperation() in Tester2", e);
                        }
                        break;
                    }
                    case 1: 
                    case 2: 
                    case 3: {
                        for (int j = 0; j < NsTest.MAX_LOW_STRESS_ROWS; ++j) {
                            this.doIUDOperation();
                        }
                        break;
                    }
                }
                try {
                    this.connex.commit();
                    continue;
                }
                catch (Exception e) {
                    System.out.println("FAIL: " + this.getThread_id() + "'s commit() failed:");
                    this.printException("committing Xn in Tester2", e);
                }
            }
            this.closeConnection();
        }
        System.out.println("Thread " + this.getThread_id() + " is now terminating");
    }
}

