/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.clients;

import java.io.PrintStream;
import java.sql.SQLException;
import org.apache.derbyTesting.perf.clients.Client;
import org.apache.derbyTesting.perf.clients.LoadGenerator;

public class BackToBackLoadGenerator
implements LoadGenerator {
    private ClientThread[] threads;
    private volatile boolean stop;
    private volatile boolean collect;
    private long startTime;
    private long stopTime;

    public void init(Client[] clients) {
        this.threads = new ClientThread[clients.length];
        for (int i = 0; i < clients.length; ++i) {
            this.threads[i] = new ClientThread(clients[i]);
        }
    }

    public void startWarmup() {
        for (int i = 0; i < this.threads.length; ++i) {
            this.threads[i].start();
        }
    }

    public void startSteadyState() {
        this.startTime = System.currentTimeMillis();
        this.collect = true;
    }

    public void stop() {
        this.stopTime = System.currentTimeMillis();
        this.collect = false;
        this.stop = true;
        for (int i = 0; i < this.threads.length; ++i) {
            try {
                this.threads[i].join();
                continue;
            }
            catch (InterruptedException ie) {
                ie.printStackTrace();
            }
        }
    }

    public void printReport(PrintStream out) {
        long time = this.stopTime - this.startTime;
        long count = 0L;
        for (int i = 0; i < this.threads.length; ++i) {
            count += this.threads[i].count;
        }
        double tps = (double)count * 1000.0 / (double)time;
        out.println("Number of threads:\t" + this.threads.length);
        out.println("Test duration (s):\t" + (double)time / 1000.0);
        out.println("Number of transactions:\t" + count);
        out.println("Average throughput (tx/s):\t" + tps);
    }

    private class ClientThread
    extends Thread {
        private final Client client;
        private long count;

        ClientThread(Client c) {
            this.client = c;
        }

        public void run() {
            try {
                while (!BackToBackLoadGenerator.this.stop) {
                    this.client.doWork();
                    if (!BackToBackLoadGenerator.this.collect) continue;
                    ++this.count;
                }
            }
            catch (SQLException sqle) {
                sqle.printStackTrace();
            }
        }
    }
}

