/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.perf.basic.jdbc;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBCPerfTestCase;

public class IndexScanTest
extends JDBCPerfTestCase {
    private PreparedStatement preparedStmt;

    private IndexScanTest(String name, int iterations, int repeats) {
        super(name, iterations, repeats);
    }

    private PreparedStatement getOrPrepareStatement(String sql) throws SQLException {
        if (this.preparedStmt == null) {
            this.preparedStmt = this.prepareStatement(sql);
        }
        return this.preparedStmt;
    }

    protected void tearDown() throws Exception {
        super.tearDown();
        this.preparedStmt = null;
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("IndexScanTest");
        suite.addTest((Test)new IndexScanTest("varchar10", 5000, 4));
        suite.addTest((Test)new IndexScanTest("varchar100", 5000, 4));
        suite.addTest((Test)new IndexScanTest("varchar1000", 5000, 4));
        suite.addTest((Test)new IndexScanTest("varcharAll", 5000, 4));
        suite.addTest((Test)new IndexScanTest("decimal1column", 5000, 4));
        suite.addTest((Test)new IndexScanTest("decimal10columns", 5000, 4));
        return new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement s) throws SQLException {
                s.execute("CREATE TABLE T (VC10 VARCHAR(10), VC100 VARCHAR(100), VC1000 VARCHAR(1000), DEC1 DECIMAL(10,10), DEC2 DECIMAL(10,10), DEC3 DECIMAL(10,10), DEC4 DECIMAL(10,10), DEC5 DECIMAL(10,10), DEC6 DECIMAL(10,10), DEC7 DECIMAL(10,10), DEC8 DECIMAL(10,10), DEC9 DECIMAL(10,10), DEC10 DECIMAL(10,10))");
                PreparedStatement ps = s.getConnection().prepareStatement("INSERT INTO T(VC10,VC100,VC1000,DEC1,DEC2,DEC3,DEC4,DEC5,DEC6,DEC7,DEC8,DEC9,DEC10) VALUES (?,?,?,RANDOM(),RANDOM(),RANDOM(),RANDOM(),RANDOM(),RANDOM(),RANDOM(),RANDOM(),RANDOM(),RANDOM())");
                char[] chars = new char[1000];
                Random r = new Random();
                for (int i = 0; i < 1000; ++i) {
                    IndexScanTest.fillWithRandomChars(r, chars);
                    ps.setString(1, new String(chars, 0, 10));
                    ps.setString(2, new String(chars, 0, 100));
                    ps.setString(3, new String(chars, 0, 1000));
                    ps.executeUpdate();
                }
                ps.close();
                s.execute("CREATE INDEX T_VC10 ON T(VC10)");
                s.execute("CREATE INDEX T_VC100 ON T(VC100)");
                s.execute("CREATE INDEX T_VC1000 ON T(VC1000)");
                s.execute("CREATE INDEX T_VC_ALL ON T(VC10,VC100,VC1000)");
                s.execute("CREATE INDEX T_DEC1 ON T(DEC1)");
                s.execute("CREATE INDEX T_DEC_ALL ON T(DEC1,DEC2,DEC3,DEC4,DEC5,DEC6,DEC7,DEC8,DEC9,DEC10)");
            }
        };
    }

    private static void fillWithRandomChars(Random r, char[] chars) {
        String alphabet = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789";
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = alphabet.charAt(r.nextInt(alphabet.length()));
        }
    }

    public void varchar10() throws SQLException {
        PreparedStatement ps = this.getOrPrepareStatement("SELECT VC10 FROM T --DERBY-PROPERTIES index=T_VC10");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            IndexScanTest.assertNotNull((Object)rs.getString(1));
        }
        rs.close();
    }

    public void varchar100() throws SQLException {
        PreparedStatement ps = this.getOrPrepareStatement("SELECT VC100 FROM T --DERBY-PROPERTIES index=T_VC100");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            IndexScanTest.assertNotNull((Object)rs.getString(1));
        }
        rs.close();
    }

    public void varchar1000() throws SQLException {
        PreparedStatement ps = this.getOrPrepareStatement("SELECT VC1000 FROM T --DERBY-PROPERTIES index=T_VC1000");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            IndexScanTest.assertNotNull((Object)rs.getString(1));
        }
        rs.close();
    }

    public void varcharAll() throws SQLException {
        PreparedStatement ps = this.getOrPrepareStatement("SELECT VC10,VC100,VC1000 FROM T --DERBY-PROPERTIES index=T_VC_ALL");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            for (int col = 1; col <= 3; ++col) {
                IndexScanTest.assertNotNull((Object)rs.getString(col));
            }
        }
        rs.close();
    }

    public void decimal1column() throws SQLException {
        PreparedStatement ps = this.getOrPrepareStatement("SELECT DEC1 FROM T --DERBY-PROPERTIES index=T_DEC1");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            IndexScanTest.assertNotNull((Object)rs.getBigDecimal(1));
        }
        rs.close();
    }

    public void decimal10columns() throws SQLException {
        PreparedStatement ps = this.getOrPrepareStatement("SELECT DEC1,DEC2,DEC3,DEC4,DEC5,DEC6,DEC7,DEC8,DEC9,DEC10 FROM T --DERBY-PROPERTIES index=T_DEC_ALL");
        ResultSet rs = ps.executeQuery();
        while (rs.next()) {
            for (int col = 1; col <= 10; ++col) {
                IndexScanTest.assertNotNull((Object)rs.getBigDecimal(col));
            }
        }
        rs.close();
    }
}

