/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.SQLException;
import java.util.Random;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Decorator {
    private Decorator() {
    }

    public static Test encryptedDatabase(Test test) {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("no encryption support");
        }
        test = new BaseTestSetup((Test)test){

            protected void setUp() throws SQLException {
                String bootPhrase = Decorator.getBootPhrase(16);
                DataSource ds = JDBCDataSource.getDataSource();
                JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", "dataEncryption=true;bootPassword=" + bootPhrase);
                ds.getConnection().close();
            }
        };
        return TestConfiguration.singleUseDatabaseDecorator(test);
    }

    public static Test encryptedDatabase(Test test, String algorithm) {
        String bootPhrase = Decorator.getBootPhrase(64);
        String attributes = "dataEncryption=true;bootPassword=" + bootPhrase + ";encryptionAlgorithm=" + algorithm;
        return Decorator.attributesDatabase(attributes, test);
    }

    private static String getBootPhrase(int length) {
        Random rand = new Random();
        char[] bp = new char[length];
        int i = 0;
        while (i < bp.length) {
            char c = (char)rand.nextInt();
            if (!Character.isLetterOrDigit(c)) continue;
            bp[i++] = c;
        }
        return new String(bp);
    }

    public static Test territoryCollatedDatabase(Test test, String locale) {
        String attributes = "collation=TERRITORY_BASED";
        if (locale != null) {
            attributes = attributes.concat(";territory=" + locale);
        }
        return Decorator.attributesDatabase(attributes, test);
    }

    private static Test attributesDatabase(final String attributes, Test test) {
        test = new BaseTestSetup((Test)test){

            protected void setUp() throws SQLException {
                DataSource ds = JDBCDataSource.getDataSource();
                JDBCDataSource.setBeanProperty(ds, "createDatabase", "create");
                JDBCDataSource.setBeanProperty(ds, "connectionAttributes", attributes);
                ds.getConnection().close();
            }
        };
        return TestConfiguration.singleUseDatabaseDecorator(test);
    }
}

