/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.junit;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import javax.sql.ConnectionPoolDataSource;
import junit.framework.AssertionFailedError;
import org.apache.derbyTesting.junit.Connector;
import org.apache.derbyTesting.junit.J2EEDataSource;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectionPoolDataSourceConnector
implements Connector {
    private TestConfiguration config;
    private ConnectionPoolDataSource ds;

    public void setConfiguration(TestConfiguration config) {
        this.config = config;
        this.ds = J2EEDataSource.getConnectionPoolDataSource(config, null);
        try {
            J2EEDataSource.setBeanProperty(this.ds, "maxStatements", new Integer(2));
        }
        catch (AssertionFailedError assertionFailedError) {
            // empty catch block
        }
    }

    public Connection openConnection() throws SQLException {
        try {
            return this.ds.getPooledConnection().getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS("createDatabase", "create").getPooledConnection().getConnection();
        }
    }

    public Connection openConnection(String databaseName) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getPooledConnection().getConnection();
        }
        catch (SQLException e) {
            String expectedState;
            String string = expectedState = this.config.getJDBCClient().isEmbedded() ? "XJ004" : "08004";
            if (!expectedState.equals(e.getSQLState())) {
                throw e;
            }
            ConnectionPoolDataSource tmpDs = this.singleUseDS("createDatabase", "create");
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getPooledConnection().getConnection();
        }
    }

    public Connection openConnection(String user, String password) throws SQLException {
        try {
            return this.ds.getPooledConnection(user, password).getConnection();
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            return this.singleUseDS("createDatabase", "create").getPooledConnection(user, password).getConnection();
        }
    }

    public Connection openConnection(String databaseName, String user, String password) throws SQLException {
        JDBCDataSource.setBeanProperty(this.ds, "databaseName", databaseName);
        try {
            return this.ds.getPooledConnection(user, password).getConnection();
        }
        catch (SQLException e) {
            if (!"XJ004".equals(e.getSQLState())) {
                throw e;
            }
            ConnectionPoolDataSource tmpDs = this.singleUseDS("createDatabase", "create");
            JDBCDataSource.setBeanProperty(tmpDs, "databaseName", databaseName);
            return tmpDs.getPooledConnection(user, password).getConnection();
        }
    }

    public void shutDatabase() throws SQLException {
        this.singleUseDS("shutdownDatabase", "shutdown").getPooledConnection().getConnection();
    }

    public void shutEngine() throws SQLException {
        ConnectionPoolDataSource tmpDs = this.singleUseDS("shutdownDatabase", "shutdown");
        JDBCDataSource.setBeanProperty(tmpDs, "databaseName", "");
        tmpDs.getPooledConnection();
    }

    private ConnectionPoolDataSource singleUseDS(String property, String value) throws SQLException {
        HashMap hm = JDBCDataSource.getDataSourceProperties(this.config);
        hm.put(property, value);
        ConnectionPoolDataSource sds = J2EEDataSource.getConnectionPoolDataSource(this.config, hm);
        return sds;
    }
}

