/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.derbyTesting.functionTests.util.ScriptTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public final class ToolScripts
extends ScriptTestCase {
    private static final String[] CLIENT_AND_EMBEDDED_TESTS = new String[]{"ij7"};
    private static final String[] EMBEDDED_TESTS = new String[]{"showindex_embed"};
    private static final String[] CLIENT_TESTS = new String[]{"showindex_client"};
    private static final String[] JDBC3_TESTS = new String[0];
    private static final String[][][] SQLAUTHORIZATION_TESTS = new String[][][]{{{"ij_show_roles_dbo"}, {"test_dbo", "donald"}, {"test_dbo"}}, {{"ij_show_roles_usr"}, {"test_dbo", "donald"}, {"donald"}}};

    public static void main(String[] args) {
        TestRunner.run((Test)ToolScripts.getSuite(args));
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("ToolScripts");
        suite.addTest(ToolScripts.getSuite(CLIENT_AND_EMBEDDED_TESTS));
        suite.addTest(ToolScripts.getSuite(EMBEDDED_TESTS));
        if (JDBC.vmSupportsJDBC3()) {
            suite.addTest(ToolScripts.getSuite(JDBC3_TESTS));
        }
        suite.addTest(ToolScripts.getAuthorizationSuite(SQLAUTHORIZATION_TESTS));
        TestSuite clientTests = new TestSuite("ToolScripts:client");
        clientTests.addTest(ToolScripts.getSuite(CLIENT_AND_EMBEDDED_TESTS));
        clientTests.addTest(ToolScripts.getAuthorizationSuite(SQLAUTHORIZATION_TESTS));
        clientTests.addTest(ToolScripts.getSuite(CLIENT_TESTS));
        Test client = TestConfiguration.clientServerDecorator((Test)clientTests);
        suite.addTest(client);
        return suite;
    }

    private ToolScripts(String toolTest) {
        super(toolTest);
    }

    private ToolScripts(String toolTest, String user) {
        super(toolTest, null, null, user);
    }

    private static Test getSuite(String[] list) {
        TestSuite suite = new TestSuite("Tool scripts");
        for (int i = 0; i < list.length; ++i) {
            suite.addTest((Test)new CleanDatabaseTestSetup((Test)new ToolScripts(list[i])));
        }
        return ToolScripts.getIJConfig((Test)suite);
    }

    private static Test getAuthorizationSuite(String[][][] list) {
        TestSuite suite = new TestSuite("Tool scripts w/authorization");
        String PWSUFFIX = "pwSuffix";
        for (int i = 0; i < list.length; ++i) {
            CleanDatabaseTestSetup clean = list[i][0][0].startsWith("ij_show_roles") ? new CleanDatabaseTestSetup((Test)new ToolScripts(list[i][0][0], list[i][2][0])){

                protected void decorateSQL(Statement s) throws SQLException {
                    s.execute("create role a");
                    s.execute("create role b");
                    s.execute("create role \"\"\"eve\"\"\"");
                    s.execute("create role publicrole");
                    s.execute("grant a to b");
                    s.execute("grant publicrole to public");
                    s.execute("grant b to donald");
                }
            } : new CleanDatabaseTestSetup((Test)new ToolScripts(list[i][0][0], list[i][2][0]));
            suite.addTest(TestConfiguration.sqlAuthorizationDecorator(DatabasePropertyTestSetup.builtinAuthentication((Test)clean, list[i][1], "pwSuffix")));
        }
        return ToolScripts.getIJConfig((Test)suite);
    }
}

