/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.tools;

import [Ljava.lang.String;;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseTestCase;
import org.apache.derbyTesting.junit.Derby;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SystemPropertyTestSetup;

public class SysinfoLocaleTest
extends BaseTestCase {
    private static final String ENCODING = "UTF-8";
    private final Locale defaultLocale;
    private final boolean localizedToGerman;
    private final String name;
    private Locale savedLocale;
    private static final String[] GERMAN_STRINGS = new String[]{"Name des Betriebssystems", "Java-Benutzerausgangsverzeichnis", "Derby-Informationen", "Informationen zur L\u00e4ndereinstellung"};
    private static final String[] ITALIAN_STRINGS = new String[]{"Nome SO", "Home utente Java", "Informazioni su Derby", "Informazioni sulla locale"};

    private SysinfoLocaleTest(Locale defaultLocale, boolean german, String info) {
        super("testSysinfoLocale");
        this.defaultLocale = defaultLocale;
        this.localizedToGerman = german;
        this.name = super.getName() + ":" + info;
    }

    public String getName() {
        return this.name;
    }

    protected void setUp() {
        this.savedLocale = Locale.getDefault();
        Locale.setDefault(this.defaultLocale);
    }

    protected void tearDown() throws Exception {
        Locale.setDefault(this.savedLocale);
        this.savedLocale = null;
        super.tearDown();
    }

    public static Test suite() {
        if (!Derby.hasTools()) {
            return new TestSuite("empty: no tools support");
        }
        TestSuite suite = new TestSuite("SysinfoLocaleTest");
        suite.addTest(SysinfoLocaleTest.createTest(Locale.ITALY, null, false));
        suite.addTest(SysinfoLocaleTest.createTest(Locale.ITALY, "it_IT", false));
        suite.addTest(SysinfoLocaleTest.createTest(Locale.ITALY, "de_DE", true));
        suite.addTest(SysinfoLocaleTest.createTest(Locale.GERMANY, null, true));
        suite.addTest(SysinfoLocaleTest.createTest(Locale.GERMANY, "it_IT", false));
        suite.addTest(SysinfoLocaleTest.createTest(Locale.GERMANY, "de_DE", true));
        return SecurityManagerSetup.noSecurityManager((Test)suite);
    }

    private static Test createTest(Locale loc, String ui, boolean german) {
        Properties prop = new Properties();
        if (ui != null) {
            prop.setProperty("derby.ui.locale", ui);
        }
        prop.setProperty("derby.ui.codeset", ENCODING);
        String info = "defaultLocale=" + loc + ",uiLocale=" + ui;
        SysinfoLocaleTest test = new SysinfoLocaleTest(loc, german, info);
        return new SystemPropertyTestSetup((Test)test, prop);
    }

    private static void runSysinfo() throws Exception {
        String className = "org.apache.derby.tools.sysinfo";
        URL sysinfoURL = SecurityManagerSetup.getURL("org.apache.derby.tools.sysinfo");
        URL emmaURL = SecurityManagerSetup.getURL("com.vladium.emma.EMMAException");
        URL[] urls = null;
        urls = emmaURL != null ? new URL[]{sysinfoURL, emmaURL} : new URL[]{sysinfoURL};
        URLClassLoader loader = new URLClassLoader(urls, null);
        Class<?> copy = Class.forName("org.apache.derby.tools.sysinfo", true, loader);
        Method main = copy.getMethod("main", String;.class);
        main.invoke(null, new Object[]{new String[0]});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getSysinfoOutput() throws Exception {
        PrintStream savedSystemOut = System.out;
        ByteArrayOutputStream bytes = new ByteArrayOutputStream();
        try {
            System.setOut(new PrintStream((OutputStream)bytes, true, ENCODING));
            SysinfoLocaleTest.runSysinfo();
        }
        finally {
            System.setOut(savedSystemOut);
        }
        return bytes.toString(ENCODING);
    }

    private void assertContains(String[] expectedSubstrings, String output) {
        for (int i = 0; i < expectedSubstrings.length; ++i) {
            String s = expectedSubstrings[i];
            if (output.indexOf(s) != -1) continue;
            SysinfoLocaleTest.fail((String)("Substring '" + s + "' not found in output: " + output));
        }
    }

    public void testSysinfoLocale() throws Exception {
        String output = SysinfoLocaleTest.getSysinfoOutput();
        String[] expectedSubstrings = this.localizedToGerman ? GERMAN_STRINGS : ITALIAN_STRINGS;
        this.assertContains(expectedSubstrings, output);
    }
}

