/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.storetests;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;

public class st_derby1939 {
    private final int VC_SIZE = 1024;
    private char[] cArr = new char[1024];

    public static void main(String[] args) {
        try {
            System.setProperty("derby.language.maxMemoryPerTable", "140");
            System.setProperty("derby.optimizer.noTimeout", "true");
            ij.getPropertyArg((String[])args);
            Connection conn = ij.startJBMS();
            st_derby1939 test = new st_derby1939();
            test.doLoad(conn);
            test.doQuery(conn);
            conn.close();
        }
        catch (Throwable t) {
            System.out.println("OOPS, unexpected error:");
            t.printStackTrace();
        }
    }

    private void doLoad(Connection conn) throws Exception {
        conn.setAutoCommit(false);
        Statement st = conn.createStatement();
        try {
            st.execute("drop table d1939_t1");
        }
        catch (SQLException se) {
            // empty catch block
        }
        try {
            st.execute("drop table d1939_t2");
        }
        catch (SQLException se) {
            // empty catch block
        }
        System.out.println("Creating tables and index...");
        st.execute("create table d1939_t1 (i smallint, vc varchar(1024))");
        st.execute("create table d1939_t2 (j smallint, val double, vc varchar(1024))");
        st.execute("create index ix_d1939_t1 on d1939_t1 (i)");
        PreparedStatement pSt = conn.prepareStatement("insert into d1939_t1(i, vc) values (?, ?)");
        PreparedStatement pSt2 = conn.prepareStatement("insert into d1939_t2 values (?, ?, ?)");
        String str = null;
        System.out.println("Doing inserts...");
        for (int i = 0; i < 69; ++i) {
            for (int j = 0; j < 10; ++j) {
                str = this.buildString(i + ":" + j);
                pSt.setInt(1, i % 10);
                pSt.setString(2, str);
                pSt.execute();
                pSt2.setInt(1, i % 10);
                pSt2.setDouble(2, (double)j * 2.0);
                if (j % 2 == 1) {
                    pSt2.setString(3, "shorty-string");
                } else {
                    pSt2.setString(3, str);
                }
                pSt2.execute();
            }
            pSt2.setInt(1, i);
            pSt2.setDouble(2, (double)i * 2.0);
            pSt2.setNull(3, 12);
            pSt2.execute();
        }
        pSt2.setNull(1, 4);
        pSt2.setDouble(2, 48.0);
        pSt.close();
        conn.commit();
    }

    private void doQuery(Connection conn) throws Exception {
        conn.setAutoCommit(false);
        PreparedStatement pSt = conn.prepareStatement("select * from d1939_t2   left outer join     (select distinct d1939_t1.i, d1939_t2.j, d1939_t1.vc from d1939_t2       left outer join d1939_t1         on d1939_t2.j = d1939_t1.i         and d1939_t1.i = ?     ) x1   on d1939_t2.j = x1.i");
        System.out.println("Done preparing, about to execute...");
        pSt.setShort(1, (short)8);
        int count = 0;
        try {
            ResultSet rs = pSt.executeQuery();
            for (count = 0; rs.next() && count < 10; ++count) {
            }
            rs.close();
            System.out.println("-=-> Ran without error, retrieved first " + count + " rows.");
        }
        catch (SQLException se) {
            if (se.getSQLState().equals("XSDA7")) {
                System.out.println("-=-> Reproduced DERBY-1939:\n -- " + se.getMessage());
            }
            throw se;
        }
        pSt.close();
        conn.rollback();
    }

    private String buildString(String s) {
        char[] sArr = new char[]{s.charAt(0), s.charAt(1), s.charAt(2)};
        for (int i = 0; i < this.cArr.length; ++i) {
            this.cArr[i] = sArr[i % 3];
        }
        return new String(this.cArr);
    }
}

