/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.memorydb;

import java.io.File;
import java.io.IOException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.functionTests.util.PrivilegedFileOpsForTests;
import org.apache.derbyTesting.functionTests.util.streams.CharAlphabet;
import org.apache.derbyTesting.functionTests.util.streams.LoopingAlphabetReader;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.SupportFilesSetup;

public class BasicInMemoryDbTest
extends BaseJDBCTestCase {
    public BasicInMemoryDbTest(String name) {
        super(name);
    }

    public void testFunctionalityPresent() {
        try {
            this.getConnection();
            DriverManager.getConnection("jdbc:derby:memory:nonExistingDb");
        }
        catch (SQLException e) {
            BasicInMemoryDbTest.assertSQLState("XJ004", e);
        }
    }

    public void testCreateBackupBootRestore() throws IOException, SQLException {
        Connection memCon = DriverManager.getConnection("jdbc:derby:memory:newMemDb;create=true");
        BasicInMemoryDbTest.assertNull((Object)memCon.getWarnings());
        Statement stmt = memCon.createStatement();
        stmt.executeUpdate("create table toverify(id int, val1 varchar(10), val2 clob, primary key(id))");
        PreparedStatement ps = memCon.prepareStatement("insert into toverify values (?,?,?)");
        String[][] firstContent = new String[][]{{"1", "one", BasicInMemoryDbTest.getString(1000, CharAlphabet.modernLatinLowercase())}, {"2", "two", BasicInMemoryDbTest.getString(10000, CharAlphabet.tamil())}, {"3", "three", BasicInMemoryDbTest.getString(50000, CharAlphabet.cjkSubset())}};
        for (int i = 0; i < firstContent.length; ++i) {
            ps.setString(1, firstContent[i][0]);
            ps.setString(2, firstContent[i][1]);
            ps.setString(3, firstContent[i][2]);
            ps.executeUpdate();
        }
        ResultSet rs = stmt.executeQuery("select * from toverify");
        JDBC.assertFullResultSet(rs, firstContent);
        ps.close();
        stmt.close();
        String dbPath = SupportFilesSetup.getReadWrite("backedUpDb").getPath();
        CallableStatement cs = memCon.prepareCall("CALL SYSCS_UTIL.SYSCS_BACKUP_DATABASE(?)");
        cs.setString(1, dbPath);
        cs.execute();
        memCon.close();
        String dbPathBackedUp = PrivilegedFileOpsForTests.getAbsolutePath(new File(dbPath, "newMemDb"));
        Connection dirCon = DriverManager.getConnection("jdbc:derby:" + dbPathBackedUp);
        stmt = dirCon.createStatement();
        rs = stmt.executeQuery("select * from toverify");
        JDBC.assertFullResultSet(rs, firstContent);
        ps = dirCon.prepareStatement("insert into toverify values (?,?,?)");
        String[] rowToAdd = new String[]{"4", "four", BasicInMemoryDbTest.getString(32768, CharAlphabet.tamil())};
        ps.setString(1, rowToAdd[0]);
        ps.setString(2, rowToAdd[1]);
        ps.setString(3, rowToAdd[2]);
        ps.executeUpdate();
        ps.close();
        dirCon.close();
        try {
            DriverManager.getConnection("jdbc:derby:" + dbPathBackedUp + ";shutdown=true");
        }
        catch (SQLException sqle) {
            BasicInMemoryDbTest.assertSQLState("08006", sqle);
        }
        memCon = DriverManager.getConnection("jdbc:derby:memory:newMemDb2;createFrom=" + dbPathBackedUp);
        stmt = memCon.createStatement();
        rs = stmt.executeQuery("select * from toverify");
        String[][] secondContent = new String[4][3];
        System.arraycopy(firstContent, 0, secondContent, 0, 3);
        System.arraycopy(rowToAdd, 0, secondContent[3], 0, 3);
        JDBC.assertFullResultSet(rs, secondContent);
        stmt.close();
        memCon.close();
    }

    public void testShutdown() throws SQLException {
        DriverManager.getConnection("jdbc:derby:memory:/tmp/myDB;create=true");
        try {
            DriverManager.getConnection("jdbc:derby:memory:/tmp/myDB;shutdown=true");
            BasicInMemoryDbTest.fail((String)"Engine shutdown should have caused exception");
        }
        catch (SQLException sqle) {
            BasicInMemoryDbTest.assertSQLState("08006", sqle);
        }
    }

    public void testEnginehutdown() throws SQLException {
        DriverManager.getConnection("jdbc:derby:memory:/tmp/myDB;create=true");
        try {
            DriverManager.getConnection("jdbc:derby:;shutdown=true");
            BasicInMemoryDbTest.fail((String)"Engine shutdown should have caused exception");
        }
        catch (SQLException sqle) {
            BasicInMemoryDbTest.assertSQLState("XJ015", sqle);
        }
        this.getConnection();
    }

    public void testBootSameDbDifferentSubSubProtocol() throws SQLException {
        String dbName = "BSDDSSP";
        Connection con1 = DriverManager.getConnection("jdbc:derby:memory:BSDDSSP;create=true");
        Statement stmt1 = con1.createStatement();
        stmt1.execute("create table t (text varchar(255))");
        stmt1.execute("insert into t values ('Inserted into in-memory db')");
        Connection con2 = DriverManager.getConnection("jdbc:derby:BSDDSSP;create=true");
        Statement stmt2 = con2.createStatement();
        try {
            stmt2.executeQuery("select * from t");
            BasicInMemoryDbTest.fail((String)"Table 't' should not exist");
        }
        catch (SQLException sqle) {
            BasicInMemoryDbTest.assertSQLState("42X05", sqle);
        }
        con2.close();
        con1.close();
    }

    public static Test suite() {
        return new SupportFilesSetup((Test)new TestSuite(BasicInMemoryDbTest.class));
    }

    public static String getString(int length, CharAlphabet alphabet) throws IOException {
        int readNow;
        LoopingAlphabetReader reader = new LoopingAlphabetReader((long)length, alphabet);
        char[] strChar = new char[length];
        for (int read = 0; read < length; read += readNow) {
            readNow = reader.read(strChar, read, length - read);
            if (readNow >= 1) continue;
            BasicInMemoryDbTest.fail((String)("Creating string failed, stream returned " + readNow));
        }
        return String.copyValueOf(strChar);
    }
}

