/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.largedata;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Random;
import org.apache.derby.tools.ij;
import org.apache.derbyTesting.functionTests.tests.largedata.BlobImpl;
import org.apache.derbyTesting.functionTests.tests.largedata.ClobImpl;
import org.apache.derbyTesting.functionTests.tests.largedata.RandomByteStream;
import org.apache.derbyTesting.functionTests.tests.largedata.RandomCharReader;

public class LobLimits {
    static boolean trace = false;
    static final int _2GB = Integer.MAX_VALUE;
    static final int _100MB = 0x6400000;
    static final int MORE_DATA_THAN_COL_WIDTH = 104857601;
    static final int NUM_TRAILING_SPACES = 33792;
    static PreparedStatement insertBlob = null;
    static PreparedStatement selectBlob = null;
    static PreparedStatement insertClob = null;
    static PreparedStatement selectClob = null;
    static PreparedStatement deleteBlob = null;
    static PreparedStatement deleteClob = null;
    static PreparedStatement insertBlob2 = null;
    static PreparedStatement selectBlob2 = null;
    static PreparedStatement insertClob2 = null;
    static PreparedStatement selectClob2 = null;
    static PreparedStatement deleteBlob2 = null;
    static PreparedStatement deleteClob2 = null;
    static final String DATAFILE = "byteLobLimits.dat";
    static final String CHARDATAFILE = "charLobLimits.txt";

    private void setup(Connection conn) throws SQLException {
        System.out.println("-----------------------------------");
        System.out.println(" START setup");
        conn.setAutoCommit(true);
        Statement s = conn.createStatement();
        try {
            s.execute("DROP TABLE BLOBTBL");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            s.execute("DROP TABLE CLOBTBL");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            s.execute("DROP TABLE BLOBTBL2");
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            s.execute("DROP TABLE CLOBTBL2");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s.execute("CREATE TABLE BLOBTBL (ID INT NOT NULL PRIMARY KEY, POS BIGINT, DLEN BIGINT, CONTENT BLOB(2G))");
        insertBlob = conn.prepareStatement("INSERT INTO BLOBTBL values (?,?,?,?)");
        s.execute("CREATE TABLE CLOBTBL (ID INT NOT NULL PRIMARY KEY,POS BIGINT, DLEN BIGINT, CONTENT CLOB(2G))");
        insertBlob = conn.prepareStatement("INSERT INTO BLOBTBL values (?,?,?,?)");
        selectBlob = conn.prepareStatement("SELECT CONTENT,DLEN FROM BLOBTBL WHERE ID = ?");
        insertClob = conn.prepareStatement("INSERT INTO CLOBTBL values (?,?,?,?)");
        selectClob = conn.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL WHERE ID = ?");
        deleteBlob = conn.prepareStatement("DELETE FROM BLOBTBL");
        deleteClob = conn.prepareStatement("DELETE  from CLOBTBL");
        s.execute("CREATE TABLE BLOBTBL2 (ID INT NOT NULL PRIMARY KEY, POS BIGINT, CONTENT BLOB(104857600),DLEN BIGINT)");
        insertBlob2 = conn.prepareStatement("INSERT INTO BLOBTBL2 values (?,?,?,?)");
        s.execute("CREATE TABLE CLOBTBL2 (ID INT NOT NULL PRIMARY KEY,POS BIGINT, CONTENT CLOB(104857600), DLEN BIGINT)");
        insertBlob2 = conn.prepareStatement("INSERT INTO BLOBTBL2 values (?,?,?,?)");
        selectBlob2 = conn.prepareStatement("SELECT CONTENT,DLEN FROM BLOBTBL2 WHERE ID = ?");
        insertClob2 = conn.prepareStatement("INSERT INTO CLOBTBL2 values (?,?,?,?)");
        selectClob2 = conn.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL2 WHERE ID = ?");
        System.out.println("-----------------------------------");
        System.out.println(" END setup");
        deleteBlob2 = conn.prepareStatement("DELETE FROM BLOBTBL2");
        deleteClob2 = conn.prepareStatement("DELETE  from CLOBTBL2");
        System.out.println("-----------------------------------");
        System.out.println(" END setup");
    }

    public static void main(String[] args) {
        new LobLimits().runTests(args);
    }

    public void runTests(String[] args) {
        Connection conn = null;
        try {
            ij.getPropertyArg((String[])args);
            conn = ij.startJBMS();
            this.setup(conn);
            conn.setAutoCommit(false);
            LobLimits.clobTests(conn);
            LobLimits.blobTests(conn);
            this.cleanup(conn);
        }
        catch (Exception e) {
            System.out.println("FAIL -- Unexpected exception:");
            e.printStackTrace(System.out);
        }
    }

    private void cleanup(Connection conn) throws Exception {
        insertBlob.close();
        selectBlob.close();
        selectClob.close();
        insertClob.close();
        deleteClob.close();
        deleteBlob.close();
        insertBlob2.close();
        selectBlob2.close();
        selectClob2.close();
        insertClob2.close();
        deleteBlob2.close();
        deleteClob2.close();
        conn.close();
        new File(DATAFILE).delete();
        new File(CHARDATAFILE).delete();
    }

    private static void blobTests(Connection conn) throws Exception {
        try {
            LobLimits.insertBlob_SetBinaryStream("BlobTest #1", conn, insertBlob, Integer.MAX_VALUE, 0, 2, Integer.MAX_VALUE);
            LobLimits.selectBlob("BlobTest #2", conn, selectBlob, Integer.MAX_VALUE, 0, 1);
            LobLimits.selectBlob("BlobTest #3", conn, selectBlob, Integer.MAX_VALUE, 1, 1);
            LobLimits.selectUpdateBlob("BlobTest #4", conn, selectBlob, Integer.MAX_VALUE, 0, 1, 1);
            LobLimits.selectInsertBlob("BlobTest #4.1", conn, selectBlob, insertBlob, Integer.MAX_VALUE, 0, 3, 1);
            FileOutputStream fos = new FileOutputStream(DATAFILE);
            RandomByteStream r = new RandomByteStream(new Random(), 0x6400000L);
            byte[] buffer = new byte[32768];
            int count = 0;
            while ((count = r.read(buffer)) >= 0) {
                fos.write(buffer, 0, count);
            }
            fos.flush();
            fos.close();
            LobLimits.insertBlob2("BlobTest #5.1 ", conn, insertBlob2, 0x6400000, 0, 1, 0x6400000, DATAFILE);
            LobLimits.selectBlob2("BlobTest #5.2 ", conn, selectBlob2, 0x6400000, 0, 1, DATAFILE);
            LobLimits.selectUpdateBlob2("BlobTest #6", conn, selectBlob2, selectBlob, 0x6400000, 0, 1, 1, DATAFILE);
            LobLimits.deleteTable(conn, deleteBlob2, 1);
        }
        catch (Exception e) {
            System.out.println("FAIL -- Unexpected exception:");
            e.printStackTrace(System.out);
        }
        conn.commit();
        LobLimits.deleteTable(conn, deleteBlob, 3);
        long _4GB = 0x100000000L;
        BlobImpl _4GbBlob = new BlobImpl(new RandomByteStream(new Random(), _4GB), _4GB);
        try {
            LobLimits.insertBlob_SetBlob("BlobTest #7 (setBlob with 4Gb blob", conn, insertBlob, _4GbBlob, _4GB, 0, 1, 0);
        }
        catch (SQLException sqle) {
            System.out.println("DERBY DOES NOT SUPPORT INSERT OF 4GB BLOB ");
            LobLimits.expectedException(sqle);
        }
    }

    private static void clobTests(Connection conn) throws Exception {
        try {
            LobLimits.insertClob_SetCharacterStream("ClobTest #1", conn, insertClob, Integer.MAX_VALUE, 0, 2, Integer.MAX_VALUE);
            LobLimits.selectClob("ClobTest #2", conn, selectClob, Integer.MAX_VALUE, 0, 1);
            LobLimits.selectClob("ClobTest #3", conn, selectClob, Integer.MAX_VALUE, 0, 1);
            LobLimits.selectUpdateClob("ClobTest #4", conn, selectClob, Integer.MAX_VALUE, 0, 1, 1);
            LobLimits.writeToFile(CHARDATAFILE, new RandomCharReader(new Random(), 0x6400000L));
            LobLimits.insertClob2("ClobTest #5.1 ", conn, insertClob2, 0x6400000, 0, 1, 0x6400000, CHARDATAFILE);
            LobLimits.selectClob2("ClobTest #5.2 ", conn, selectClob2, 0x6400000, 0, 1, CHARDATAFILE);
            LobLimits.selectUpdateClob2("ClobTest #8.2", conn, selectClob2, selectClob, 0x6400000, 0, 1, 1, CHARDATAFILE);
            LobLimits.writeToFile(CHARDATAFILE, new RandomCharReader(new Random(), 104891392L, 33792L));
            LobLimits.insertClob2("ClobTest #6.1 ", conn, insertClob2, 0x6400000, 3, 1, 104891392, CHARDATAFILE);
            LobLimits.selectClob2("ClobTest #6.2 ", conn, selectClob2, 0x6400000, 3, 1, CHARDATAFILE);
            LobLimits.negativeSpaceTruncationTest("ClobTest #7", conn);
            LobLimits.writeToFile(CHARDATAFILE, new RandomCharReader(new Random(), 104857601L));
            try {
                LobLimits.insertClob2("ClobTest #9.1 ", conn, insertClob2, 104857601, 4, 1, 104857601, CHARDATAFILE);
            }
            catch (SQLException sqle) {
                System.out.println("NEGATIVE TEST - Expected Exception: truncation of non-blanks not allowed");
                LobLimits.expectedException(sqle);
            }
            LobLimits.selectClob2("ClobTest #9.2 ", conn, selectClob2, 0x6400000, 4, 0, CHARDATAFILE);
            try {
                LobLimits.insertClob2("ClobTest #10 ", conn, insertClob2, 104857601, 4, 1, 104857602, CHARDATAFILE);
            }
            catch (SQLException sqle) {
                System.out.println("NEGATIVE TEST - Expected Exception: truncation of non-blanks not allowed and stream length is one greater than actual length of the stream ");
                LobLimits.expectedException(sqle);
            }
            try {
                LobLimits.insertClob2("ClobTest #11 ", conn, insertClob2, 104857601, 4, 1, 0x6400000, CHARDATAFILE);
            }
            catch (SQLException sqle) {
                System.out.println("NEGATIVE TEST - Expected Exception: truncation of non-blanks not allowed and stream length is one less than actual length of the stream ");
                LobLimits.expectedException(sqle);
            }
            LobLimits.deleteTable(conn, deleteClob2, 2);
        }
        catch (Exception e) {
            System.out.println("FAIL -- Unexpected exception:");
            e.printStackTrace(System.out);
        }
        try {
            LobLimits.insertClob_SetCharacterStream("ClobTest #12.1", conn, insertClob, 0x6400000, 4, 1, -1);
        }
        catch (SQLException sqle) {
            System.out.println("NEGATIVE TEST - Expected Exception:");
            LobLimits.expectedException(sqle);
        }
        LobLimits.selectClob("ClobTest #12.2", conn, selectClob, 0x6400000, 4, 0);
        LobLimits.deleteTable(conn, deleteClob, 2);
        long _4GB = 0x100000000L;
        ClobImpl _4GBClob = new ClobImpl(new RandomCharReader(new Random(), _4GB), _4GB);
        try {
            LobLimits.insertClob_SetClob("ClobTest #13 (setClob with 4Gb clob", conn, insertClob, _4GBClob, _4GB, 0, 1, 0);
        }
        catch (SQLException sqle) {
            System.out.println("DERBY DOES NOT SUPPORT INSERT OF 4GB CLOB ");
            LobLimits.expectedException(sqle);
        }
    }

    private static void negativeSpaceTruncationTest(String msg, Connection conn) throws Exception {
        try {
            LobLimits.insertClob2(msg, conn, insertClob2, 0x6400000, 4, 1, 104891391, CHARDATAFILE);
        }
        catch (SQLException sqle) {
            System.out.println("EXPECTED EXCEPTION - stream has trailing spaces,but stream  length is 1 less than actual length of stream");
            LobLimits.expectedException(sqle);
        }
        try {
            LobLimits.insertClob2(msg, conn, insertClob2, 0x6400000, 5, 1, 104891393, CHARDATAFILE);
        }
        catch (SQLException sqle) {
            System.out.println("EXPECTED EXCEPTION - stream has trailing spaces,but stream  length is 1 greater than actual length of stream");
            LobLimits.expectedException(sqle);
        }
    }

    private static void insertBlob_SetBinaryStream(String testId, Connection conn, PreparedStatement ps, int bloblen, int start, int rows, int streamLength) throws SQLException {
        System.out.println("========================================");
        System.out.println("START " + testId + "insertBlob of size = " + bloblen);
        long ST = 0L;
        if (trace) {
            ST = System.currentTimeMillis();
        }
        int count = 0;
        Random random = new Random();
        for (int i = start; i < start + rows; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, 0);
            ps.setLong(3, bloblen);
            ps.setBinaryStream(4, (InputStream)new RandomByteStream(random, bloblen), streamLength);
            count += ps.executeUpdate();
        }
        conn.commit();
        if (trace) {
            System.out.println("Insert Blob (" + bloblen + ")" + " rows= " + count + " = " + (System.currentTimeMillis() - ST));
        }
        LobLimits.verifyTest(count, rows, " Rows inserted with blob of size (" + bloblen + ") =");
        System.out.println("========================================");
    }

    private static void insertBlob_SetBlob(String testId, Connection conn, PreparedStatement ps, Blob blob, long bloblen, int start, int rows, int expectedRows) throws SQLException {
        System.out.println("========================================");
        System.out.println("START " + testId + "insertBlob of size = " + bloblen);
        long ST = 0L;
        if (trace) {
            ST = System.currentTimeMillis();
        }
        int count = 0;
        try {
            for (int i = start; i < start + rows; ++i) {
                ps.setInt(1, i);
                ps.setInt(2, 0);
                ps.setLong(3, bloblen);
                ps.setBlob(4, blob);
                count += ps.executeUpdate();
            }
            conn.commit();
            if (trace) {
                System.out.println("Insert Blob (" + bloblen + ")" + " rows= " + count + " = " + (System.currentTimeMillis() - ST));
            }
        }
        catch (SQLException e) {
            LobLimits.verifyTest(count, expectedRows, " Rows inserted with blob of size (" + bloblen + ") =");
            System.out.println("========================================");
            throw e;
        }
        LobLimits.verifyTest(count, expectedRows, " Rows inserted with blob of size (" + bloblen + ") =");
        System.out.println("========================================");
    }

    private static void selectBlob(String testId, Connection conn, PreparedStatement ps, int bloblen, int id, int expectedRows) throws SQLException {
        System.out.println("========================================");
        System.out.println("START " + testId + " - SELECT BLOB of size = " + bloblen);
        long ST = 0L;
        ResultSet rs = null;
        if (trace) {
            ST = System.currentTimeMillis();
        }
        int count = 0;
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            ++count;
            Blob value = rs.getBlob(1);
            long l = value.length();
            long dlen = rs.getLong(2);
            if (dlen == l) continue;
            System.out.println("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in BLOBTBL with ID=" + id);
        }
        conn.commit();
        LobLimits.verifyTest(count, expectedRows, "Matched rows selected with blob of size(" + bloblen + ") =");
        if (trace) {
            System.out.println("Select Blob (" + bloblen + ")" + " rows= " + expectedRows + " = " + (System.currentTimeMillis() - ST));
        }
        System.out.println("========================================");
    }

    private static void insertBlob2(String testId, Connection conn, PreparedStatement ps, int bloblen, int start, int rows, int streamLength, String file) throws Exception {
        System.out.println("========================================");
        System.out.println("START " + testId + "insert Blob of size = " + bloblen);
        int count = 0;
        Random random = new Random();
        FileInputStream fis = null;
        long ST = 0L;
        if (trace) {
            ST = System.currentTimeMillis();
        }
        for (int i = start; i < start + rows; ++i) {
            fis = new FileInputStream(file);
            ps.setInt(1, i);
            ps.setInt(2, 0);
            ps.setLong(4, bloblen);
            ps.setBinaryStream(3, (InputStream)fis, streamLength);
            count += ps.executeUpdate();
            fis.close();
        }
        conn.commit();
        if (trace) {
            System.out.println("Insert Blob (" + bloblen + ")" + " rows= " + count + " = " + (System.currentTimeMillis() - ST));
        }
        LobLimits.verifyTest(count, rows, " Rows inserted with blob of size (" + bloblen + ") =");
        System.out.println("========================================");
    }

    private static void selectBlob2(String testId, Connection conn, PreparedStatement ps, int bloblen, int id, int expectedRows, String file) throws Exception {
        System.out.println("========================================");
        System.out.println("START " + testId + " - SELECT BLOB of size = " + bloblen);
        long ST = 0L;
        ResultSet rs = null;
        if (trace) {
            ST = System.currentTimeMillis();
        }
        int count = 0;
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            ++count;
            Blob value = rs.getBlob(1);
            long l = value.length();
            long dlen = rs.getLong(2);
            if (dlen != l) {
                System.out.println("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in BLOBTBL with ID=" + id);
                continue;
            }
            LobLimits.compareBlobToFile(value.getBinaryStream(), file);
        }
        conn.commit();
        LobLimits.verifyTest(count, expectedRows, "Matched rows selected with blob of size(" + bloblen + ") =");
        if (trace) {
            System.out.println("Select Blob (" + bloblen + ")" + " rows= " + expectedRows + " = " + (System.currentTimeMillis() - ST));
        }
        System.out.println("========================================");
    }

    private static void selectUpdateBlob(String testId, Connection conn, PreparedStatement ps, int bloblen, int id, int updateId, int expectedRows) throws Exception {
        System.out.println("========================================");
        System.out.println("START " + testId + " - select and then update blob of size= " + bloblen + " - Uses getBlob api");
        ResultSet rs = null;
        ps.setInt(1, id);
        rs = ps.executeQuery();
        rs.next();
        Blob value = rs.getBlob(1);
        long l = value.length();
        long dlen = rs.getLong(2);
        if (dlen != l) {
            System.out.println("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in BLOBTBL with ID=" + id);
        }
        PreparedStatement psUpd = conn.prepareStatement("update BLOBTBL set content=?,dlen =? where id = ?");
        psUpd.setBlob(1, value);
        psUpd.setLong(2, l);
        psUpd.setInt(3, updateId);
        System.out.println("Rows Updated = " + psUpd.executeUpdate());
        conn.commit();
        ps.setInt(1, updateId);
        ResultSet rs2 = ps.executeQuery();
        rs2.next();
        Blob updatedValue = rs2.getBlob(1);
        if (updatedValue.length() != l) {
            System.out.println("FAIL - Retrieving the updated blob length does not match expected length = " + l + " found = " + updatedValue.length());
        }
        conn.commit();
        rs.close();
        rs2.close();
        psUpd.close();
        System.out.println("========================================");
    }

    private static void selectInsertBlob(String testId, Connection conn, PreparedStatement ps, PreparedStatement ins, int bloblen, int id, int insertId, int expectedRows) throws Exception {
        System.out.println("========================================");
        System.out.println("START " + testId + " - select and then insert blob of size= " + bloblen + " - Uses getBlob api to do select and setBlob for insert");
        ResultSet rs = null;
        ps.setInt(1, id);
        rs = ps.executeQuery();
        rs.next();
        Blob value = rs.getBlob(1);
        long l = value.length();
        long dlen = rs.getLong(2);
        if (dlen != l) {
            System.out.println("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in BLOBTBL with ID=" + id);
        }
        ins.setInt(1, insertId);
        ins.setInt(2, 0);
        ins.setLong(3, l);
        ins.setBlob(4, value);
        System.out.println("Rows Updated = " + ins.executeUpdate());
        conn.commit();
        ps.setInt(1, insertId);
        ResultSet rs2 = ps.executeQuery();
        rs2.next();
        Blob insertedValue = rs2.getBlob(1);
        if (insertedValue.length() != l) {
            System.out.println("FAIL - Retrieving the updated blob length does not match expected length = " + l + " found = " + insertedValue.length());
        }
        conn.commit();
        rs.close();
        rs2.close();
        System.out.println("========================================");
    }

    private static void selectUpdateBlob2(String testId, Connection conn, PreparedStatement ps, PreparedStatement sel, int bloblen, int id, int updateId, int expectedRows, String file) throws Exception {
        System.out.println("========================================");
        System.out.println("START " + testId + " - select and then update blob of size= " + bloblen + " - Uses getBlob and setBlob  api");
        ResultSet rs = null;
        ps.setInt(1, id);
        rs = ps.executeQuery();
        rs.next();
        Blob value = rs.getBlob(1);
        long l = value.length();
        long dlen = rs.getLong(2);
        if (dlen != l) {
            System.out.println("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in BLOBTBL2 with ID=" + id);
        }
        PreparedStatement psUpd = conn.prepareStatement("update BLOBTBL set content=?,dlen =? where id = ?");
        psUpd.setBlob(1, value);
        psUpd.setLong(2, l);
        psUpd.setInt(3, updateId);
        System.out.println("Rows Updated = " + psUpd.executeUpdate());
        conn.commit();
        sel.setInt(1, updateId);
        ResultSet rs2 = sel.executeQuery();
        rs2.next();
        Blob updatedValue = rs2.getBlob(1);
        if (updatedValue.length() != l) {
            System.out.println("FAIL - MISMATCH length of updated blob value : expected=" + l + " found =" + updatedValue.length());
        } else {
            LobLimits.compareBlobToFile(updatedValue.getBinaryStream(), file);
        }
        conn.commit();
        rs.close();
        rs2.close();
        psUpd.close();
        System.out.println("========================================");
    }

    private static void compareBlobToFile(InputStream lobstream, String filename) throws Exception {
        FileInputStream file = new FileInputStream(filename);
        int l = 0;
        int b = 0;
        do {
            if ((l = lobstream.read()) == (b = file.read())) continue;
            System.out.println("FAIL -- MISMATCH in data stored versusdata retrieved");
            break;
        } while (l != -1 && b != -1);
    }

    private static void deleteTable(Connection conn, PreparedStatement ps, int expectedRows) throws SQLException {
        int count = ps.executeUpdate();
        conn.commit();
        LobLimits.verifyTest(count, expectedRows, "Rows deleted =");
    }

    private static void insertClob_SetCharacterStream(String testId, Connection conn, PreparedStatement ps, int cloblen, int start, int rows, int streamLength) throws SQLException {
        System.out.println("========================================");
        System.out.println("START " + testId + "  -insertClob of size = " + cloblen);
        long ST = 0L;
        Random random = new Random();
        int count = 0;
        if (trace) {
            ST = System.currentTimeMillis();
        }
        for (int i = start; i < start + rows; ++i) {
            ps.setInt(1, i);
            ps.setInt(2, 0);
            ps.setLong(3, cloblen);
            ps.setCharacterStream(4, (Reader)new RandomCharReader(random, cloblen), streamLength);
            count += ps.executeUpdate();
        }
        conn.commit();
        if (trace) {
            System.out.println("Insert Clob (" + cloblen + ")" + " rows= " + count + " = " + (System.currentTimeMillis() - ST));
        }
        LobLimits.verifyTest(count, rows, "Rows inserted with clob of size (" + cloblen + ") = ");
        System.out.println("========================================");
    }

    private static void insertClob_SetClob(String testId, Connection conn, PreparedStatement ps, Clob clob, long cloblen, int start, int rows, int expectedRows) throws SQLException {
        System.out.println("========================================");
        System.out.println("START " + testId + "insertClob of size = " + cloblen);
        long ST = 0L;
        if (trace) {
            ST = System.currentTimeMillis();
        }
        int count = 0;
        try {
            for (int i = start; i < start + rows; ++i) {
                ps.setInt(1, i);
                ps.setInt(2, 0);
                ps.setLong(3, cloblen);
                ps.setClob(4, clob);
                count += ps.executeUpdate();
            }
            conn.commit();
            if (trace) {
                System.out.println("Insert Clob (" + cloblen + ")" + " rows= " + count + " = " + (System.currentTimeMillis() - ST));
            }
        }
        catch (SQLException e) {
            LobLimits.verifyTest(count, expectedRows, " Rows inserted with clob of size (" + cloblen + ") =");
            System.out.println("========================================");
            throw e;
        }
        LobLimits.verifyTest(count, expectedRows, " Rows inserted with clob of size (" + cloblen + ") =");
        System.out.println("========================================");
    }

    private static void selectClob(String testId, Connection conn, PreparedStatement ps, int cloblen, int id, int expectedRows) throws SQLException {
        System.out.println("========================================");
        System.out.println("START " + testId + " - SELECT CLOB of size = " + cloblen);
        long ST = 0L;
        int count = 0;
        ResultSet rs = null;
        if (trace) {
            ST = System.currentTimeMillis();
        }
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            ++count;
            Clob value = rs.getClob(1);
            long l = value.length();
            long dlen = rs.getLong(2);
            if (dlen == l) continue;
            System.out.println("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in CLOBTBL with ID=" + id);
        }
        conn.commit();
        if (trace) {
            System.out.println("Select Clob (" + cloblen + ")" + " rows= " + expectedRows + " = " + (System.currentTimeMillis() - ST));
        }
        LobLimits.verifyTest(count, expectedRows, "Matched rows selected with clob of size(" + cloblen + ") =");
        System.out.println("========================================");
    }

    private static void insertClob2(String testId, Connection conn, PreparedStatement ps, int cloblen, int start, int rows, int streamLength, String file) throws Exception {
        System.out.println("========================================");
        System.out.println("START " + testId + "insert Clob of size = " + cloblen);
        int count = 0;
        FileReader reader = null;
        long ST = 0L;
        if (trace) {
            ST = System.currentTimeMillis();
        }
        for (int i = start; i < start + rows; ++i) {
            reader = new FileReader(file);
            ps.setInt(1, i);
            ps.setInt(2, 0);
            ps.setLong(4, cloblen);
            ps.setCharacterStream(3, (Reader)reader, streamLength);
            count += ps.executeUpdate();
            reader.close();
        }
        conn.commit();
        if (trace) {
            System.out.println("Insert Clob (" + cloblen + ")" + " rows= " + count + " = " + (System.currentTimeMillis() - ST));
        }
        LobLimits.verifyTest(count, rows, " Rows inserted with clob of size (" + cloblen + ") =");
        System.out.println("========================================");
    }

    private static void selectClob2(String testId, Connection conn, PreparedStatement ps, int cloblen, int id, int expectedRows, String file) throws SQLException, Exception {
        System.out.println("========================================");
        System.out.println("START " + testId + " - SELECT CLOB of size = " + cloblen);
        long ST = 0L;
        ResultSet rs = null;
        if (trace) {
            ST = System.currentTimeMillis();
        }
        int count = 0;
        ps.setInt(1, id);
        rs = ps.executeQuery();
        while (rs.next()) {
            ++count;
            Clob value = rs.getClob(1);
            long l = value.length();
            long dlen = rs.getLong(2);
            if ((long)cloblen != l) {
                System.out.println("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in CLOBTBL2 with ID=" + id);
                continue;
            }
            LobLimits.compareClobToFile(value.getCharacterStream(), file, cloblen);
        }
        conn.commit();
        LobLimits.verifyTest(count, expectedRows, "Matched rows selected with clob of size(" + cloblen + ") =");
        if (trace) {
            System.out.println("Select Clob (" + cloblen + ")" + " rows= " + expectedRows + " = " + (System.currentTimeMillis() - ST));
        }
        System.out.println("========================================");
    }

    private static void selectUpdateClob(String testId, Connection conn, PreparedStatement ps, int cloblen, int id, int updateId, int expectedRows) throws Exception {
        System.out.println("========================================");
        System.out.println("START " + testId + " - select and then update clob of size= " + cloblen + " - Uses setClob api");
        ResultSet rs = null;
        ps.setInt(1, id);
        rs = ps.executeQuery();
        rs.next();
        Clob value = rs.getClob(1);
        long l = value.length();
        long dlen = rs.getLong(2);
        if (dlen != l) {
            System.out.println("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in CLOBTBL with ID=" + id);
        }
        PreparedStatement psUpd = conn.prepareStatement("update CLOBTBL set content=?,dlen =? where id = ?");
        psUpd.setCharacterStream(1, value.getCharacterStream(), (int)l);
        psUpd.setLong(2, l);
        psUpd.setInt(3, updateId);
        System.out.println("Rows Updated = " + psUpd.executeUpdate());
        conn.commit();
        ps.setInt(1, updateId);
        ResultSet rs2 = ps.executeQuery();
        rs2.next();
        Clob updatedValue = rs2.getClob(1);
        if (updatedValue.length() != l) {
            System.out.println("FAIL - Retrieving the updated clob length does not match expected length = " + l + " found = " + updatedValue.length());
        }
        conn.commit();
        rs.close();
        rs2.close();
        psUpd.close();
        System.out.println("========================================");
    }

    private static void selectUpdateClob2(String testId, Connection conn, PreparedStatement ps, PreparedStatement sel, int cloblen, int id, int updateId, int expectedRows, String file) throws Exception {
        System.out.println("========================================");
        System.out.println("START " + testId + " - select and then update clob of size= " + cloblen + " - Uses setClob api");
        ResultSet rs = null;
        ps.setInt(1, id);
        rs = ps.executeQuery();
        rs.next();
        Clob value = rs.getClob(1);
        long l = value.length();
        long dlen = rs.getLong(2);
        if (dlen != l) {
            System.out.println("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in CLOBTBL2 with ID=" + id);
        }
        PreparedStatement psUpd = conn.prepareStatement("update CLOBTBL set content=?,dlen =? where id = ?");
        psUpd.setClob(1, value);
        psUpd.setLong(2, l);
        psUpd.setInt(3, updateId);
        System.out.println("Rows Updated = " + psUpd.executeUpdate());
        conn.commit();
        sel.setInt(1, updateId);
        ResultSet rs2 = sel.executeQuery();
        rs2.next();
        Clob updatedValue = rs2.getClob(1);
        if (updatedValue.length() != l) {
            System.out.println("FAIL - MISMATCH length of updated clob value , found=" + updatedValue.length() + ",expected = " + l);
        } else {
            LobLimits.compareClobToFile(updatedValue.getCharacterStream(), file, (int)l);
        }
        conn.commit();
        rs.close();
        rs2.close();
        psUpd.close();
        System.out.println("========================================");
    }

    private static void updateClob2(String testId, Connection conn, PreparedStatement sel, int cloblen, int id, int updateRowId, int updateIdVal, int expectedRows, String file) throws Exception {
        System.out.println("========================================");
        System.out.println("START " + testId + " - select and then update clob of size= " + cloblen + " - Uses updateClob api");
        PreparedStatement ps1 = conn.prepareStatement("SELECT * FROM CLOBTBL FOR UPDATE", 1003, 1008);
        PreparedStatement ps = conn.prepareStatement("SELECT CONTENT,DLEN FROM CLOBTBL2 where ID =?");
        ResultSet rs = null;
        ps.setInt(1, id);
        rs = ps.executeQuery();
        rs.next();
        Clob value = rs.getClob(1);
        long l = value.length();
        long dlen = rs.getLong(2);
        if (dlen != l) {
            System.out.println("FAIL - MISMATCH LENGTHS GOT " + l + " expected " + dlen + " for row in CLOBTBL2 with ID=" + id);
        }
        ResultSet rs1 = ps1.executeQuery();
        while (rs1.next()) {
            if (rs1.getInt(1) != updateRowId) continue;
            rs1.updateClob(4, value);
            rs1.updateInt(1, updateIdVal);
            rs1.updateInt(2, 0);
            rs1.updateLong(3, dlen);
            rs1.updateRow();
            break;
        }
        conn.commit();
        rs.close();
        rs1.close();
        ps1.close();
        ps.close();
        sel.setInt(1, updateIdVal);
        ResultSet rs2 = sel.executeQuery();
        rs2.next();
        Clob updatedValue = rs2.getClob(1);
        if (updatedValue.length() != l) {
            System.out.println("FAIL - MISMATCH length of updated clob value , found=" + updatedValue.length() + ",expected = " + l);
        } else {
            LobLimits.compareClobToFile(updatedValue.getCharacterStream(), file, (int)l);
        }
        System.out.println("========================================");
    }

    private static void compareClobToFile(Reader lobstream, String filename, int length) throws Exception {
        FileReader file = new FileReader(filename);
        int c1 = 0;
        int c2 = 0;
        long count = 0L;
        do {
            if ((c1 = lobstream.read()) != (c2 = file.read())) {
                System.out.println("FAIL -- MISMATCH in data stored versus data retrieved at " + count);
                break;
            }
            ++count;
        } while (c1 != -1 && c2 != -1 && --length > 0);
    }

    private static void expectedException(SQLException sqle) {
        while (sqle != null) {
            String sqlState = sqle.getSQLState();
            if (sqlState == null) {
                sqlState = "<NULL>";
            }
            System.out.println("EXPECTED SQL Exception: (" + sqlState + ") " + sqle.getMessage());
            sqle = sqle.getNextException();
        }
    }

    private static void verifyTest(int affectedRows, int expectedRows, String test) {
        if (affectedRows != expectedRows) {
            System.out.println("FAIL --" + test + affectedRows + " , but expected rows =" + expectedRows);
        } else {
            System.out.println(test + affectedRows);
        }
    }

    private static void writeToFile(String file, Reader r) throws IOException {
        File f = new File(file);
        if (f.exists()) {
            f.delete();
        }
        FileWriter writer = new FileWriter(file);
        char[] buffer = new char[32768];
        int count = 0;
        while ((count = r.read(buffer)) >= 0) {
            writer.write(buffer, 0, count);
        }
        writer.flush();
        writer.close();
    }
}

