/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Connection;
import java.sql.Date;
import java.sql.DriverManager;
import java.sql.Ref;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Map;
import org.apache.derbyTesting.junit.JDBC;

public abstract class TableVTI
implements ResultSet {
    private String tableName;
    private ResultSetMetaData rsmd;
    private int[] map;

    public TableVTI(String tableName) throws SQLException {
        this.tableName = tableName;
        this.init();
    }

    protected void init() throws SQLException {
        Connection conn = DriverManager.getConnection("jdbc:default:connection");
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("select * from " + JDBC.escape(this.tableName) + " where 1 = 0 ");
        this.rsmd = rs.getMetaData();
        rs.close();
        s.close();
        this.map = this.getColumnMap(this.getVTIColumnNames());
    }

    public final ResultSetMetaData getMetaData() {
        return this.rsmd;
    }

    public final void close() {
    }

    protected int[] getColumnMap(String[] vtiNames) throws SQLException {
        if (vtiNames == null) {
            return null;
        }
        int[] map = new int[vtiNames.length];
        int count = this.rsmd.getColumnCount();
        block0: for (int i = 0; i < vtiNames.length; ++i) {
            String vtiCol = vtiNames[i];
            if (vtiCol == null) continue;
            for (int j = 1; j <= count; ++j) {
                if (!vtiCol.equalsIgnoreCase(this.rsmd.getColumnName(j))) continue;
                map[i] = j;
                continue block0;
            }
        }
        return map;
    }

    protected String[] getVTIColumnNames() {
        return null;
    }

    public boolean wasNull() throws SQLException {
        throw new SQLException("wasNull");
    }

    public String getString(int columnIndex) throws SQLException {
        throw new SQLException("getString");
    }

    public boolean getBoolean(int columnIndex) throws SQLException {
        throw new SQLException("getBoolean");
    }

    public byte getByte(int columnIndex) throws SQLException {
        throw new SQLException("getByte");
    }

    public short getShort(int columnIndex) throws SQLException {
        throw new SQLException("getShort");
    }

    public int getInt(int columnIndex) throws SQLException {
        throw new SQLException("getInt");
    }

    public long getLong(int columnIndex) throws SQLException {
        throw new SQLException("getLong");
    }

    public float getFloat(int columnIndex) throws SQLException {
        throw new SQLException("getFloat");
    }

    public double getDouble(int columnIndex) throws SQLException {
        throw new SQLException("getDouble");
    }

    public BigDecimal getBigDecimal(int columnIndex, int scale) throws SQLException {
        throw new SQLException("getBigDecimal");
    }

    public byte[] getBytes(int columnIndex) throws SQLException {
        throw new SQLException("getBytes");
    }

    public Date getDate(int columnIndex) throws SQLException {
        throw new SQLException("getDate");
    }

    public Time getTime(int columnIndex) throws SQLException {
        throw new SQLException("getTime");
    }

    public Timestamp getTimestamp(int columnIndex) throws SQLException {
        throw new SQLException("getTimestamp");
    }

    public InputStream getAsciiStream(int columnIndex) throws SQLException {
        throw new SQLException("getAsciiStream");
    }

    public InputStream getUnicodeStream(int columnIndex) throws SQLException {
        throw new SQLException("getUnicodeStream");
    }

    public InputStream getBinaryStream(int columnIndex) throws SQLException {
        throw new SQLException("getBinaryStream");
    }

    public String getString(String columnName) throws SQLException {
        return this.getString(this.findColumn(columnName));
    }

    public boolean getBoolean(String columnName) throws SQLException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public byte getByte(String columnName) throws SQLException {
        return this.getByte(this.findColumn(columnName));
    }

    public short getShort(String columnName) throws SQLException {
        return this.getShort(this.findColumn(columnName));
    }

    public int getInt(String columnName) throws SQLException {
        return this.getInt(this.findColumn(columnName));
    }

    public long getLong(String columnName) throws SQLException {
        return this.getLong(this.findColumn(columnName));
    }

    public float getFloat(String columnName) throws SQLException {
        return this.getFloat(this.findColumn(columnName));
    }

    public double getDouble(String columnName) throws SQLException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(String columnName, int scale) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName), scale);
    }

    public byte[] getBytes(String columnName) throws SQLException {
        return this.getBytes(this.findColumn(columnName));
    }

    public Date getDate(String columnName) throws SQLException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(String columnName) throws SQLException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(String columnName) throws SQLException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public InputStream getAsciiStream(String columnName) throws SQLException {
        throw new SQLException("getAsciiStream");
    }

    public InputStream getUnicodeStream(String columnName) throws SQLException {
        throw new SQLException("getUnicodeStream");
    }

    public InputStream getBinaryStream(String columnName) throws SQLException {
        throw new SQLException("getBinaryStream");
    }

    public SQLWarning getWarnings() throws SQLException {
        return null;
    }

    public void clearWarnings() throws SQLException {
    }

    public String getCursorName() throws SQLException {
        throw new SQLException("getCursorName");
    }

    public Object getObject(int columnIndex) throws SQLException {
        throw new SQLException("getObject");
    }

    public Object getObject(String columnName) throws SQLException {
        return this.getObject(this.findColumn(columnName));
    }

    public int findColumn(String columnName) throws SQLException {
        throw new SQLException("findColumn");
    }

    public Reader getCharacterStream(int columnIndex) throws SQLException {
        throw new SQLException("getCharacterStream");
    }

    public Reader getCharacterStream(String columnName) throws SQLException {
        throw new SQLException("getCharacterStream");
    }

    public BigDecimal getBigDecimal(int columnIndex) throws SQLException {
        throw new SQLException("getBigDecimal");
    }

    public BigDecimal getBigDecimal(String columnName) throws SQLException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public boolean isBeforeFirst() throws SQLException {
        throw new SQLException("isBeforeFirst");
    }

    public boolean isAfterLast() throws SQLException {
        throw new SQLException("isAfterLast");
    }

    public boolean isFirst() throws SQLException {
        throw new SQLException("isFirst");
    }

    public boolean isLast() throws SQLException {
        throw new SQLException("isLast");
    }

    public void beforeFirst() throws SQLException {
        throw new SQLException("beforeFirst");
    }

    public void afterLast() throws SQLException {
        throw new SQLException("afterLast");
    }

    public boolean first() throws SQLException {
        throw new SQLException("first");
    }

    public boolean last() throws SQLException {
        throw new SQLException("last");
    }

    public int getRow() throws SQLException {
        throw new SQLException("getRow");
    }

    public boolean absolute(int row) throws SQLException {
        throw new SQLException("absolute");
    }

    public boolean relative(int rows) throws SQLException {
        throw new SQLException("relative");
    }

    public boolean previous() throws SQLException {
        throw new SQLException("previous");
    }

    public void setFetchDirection(int direction) throws SQLException {
        throw new SQLException("setFetchDirection");
    }

    public int getFetchDirection() throws SQLException {
        throw new SQLException("getFetchDirection");
    }

    public void setFetchSize(int rows) throws SQLException {
        throw new SQLException("setFetchSize");
    }

    public int getFetchSize() throws SQLException {
        throw new SQLException("getFetchSize");
    }

    public int getType() throws SQLException {
        throw new SQLException("getType");
    }

    public int getConcurrency() throws SQLException {
        throw new SQLException("getConcurrency");
    }

    public boolean rowUpdated() throws SQLException {
        throw new SQLException("rowUpdated");
    }

    public boolean rowInserted() throws SQLException {
        throw new SQLException("rowInserted");
    }

    public boolean rowDeleted() throws SQLException {
        throw new SQLException("rowDeleted");
    }

    public void updateNull(int columnIndex) throws SQLException {
        throw new SQLException("updateNull");
    }

    public void updateBoolean(int columnIndex, boolean x) throws SQLException {
        throw new SQLException("updateBoolean");
    }

    public void updateByte(int columnIndex, byte x) throws SQLException {
        throw new SQLException("updateByte");
    }

    public void updateShort(int columnIndex, short x) throws SQLException {
        throw new SQLException("updateShort");
    }

    public void updateInt(int columnIndex, int x) throws SQLException {
        throw new SQLException("updateInt");
    }

    public void updateLong(int columnIndex, long x) throws SQLException {
        throw new SQLException("updateLong");
    }

    public void updateFloat(int columnIndex, float x) throws SQLException {
        throw new SQLException("updateFloat");
    }

    public void updateDouble(int columnIndex, double x) throws SQLException {
        throw new SQLException("updateDouble");
    }

    public void updateBigDecimal(int columnIndex, BigDecimal x) throws SQLException {
        throw new SQLException("updateBigDecimal");
    }

    public void updateString(int columnIndex, String x) throws SQLException {
        throw new SQLException("updateString");
    }

    public void updateBytes(int columnIndex, byte[] x) throws SQLException {
        throw new SQLException("updateBytes");
    }

    public void updateDate(int columnIndex, Date x) throws SQLException {
        throw new SQLException("updateDate");
    }

    public void updateTime(int columnIndex, Time x) throws SQLException {
        throw new SQLException("updateTime");
    }

    public void updateTimestamp(int columnIndex, Timestamp x) throws SQLException {
        throw new SQLException("updateTimestamp");
    }

    public void updateAsciiStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("updateAsciiStream");
    }

    public void updateBinaryStream(int columnIndex, InputStream x, int length) throws SQLException {
        throw new SQLException("updateBinaryStream");
    }

    public void updateCharacterStream(int columnIndex, Reader x, int length) throws SQLException {
        throw new SQLException("updateCharacterStream");
    }

    public void updateObject(int columnIndex, Object x, int scale) throws SQLException {
        throw new SQLException("updateObject");
    }

    public void updateObject(int columnIndex, Object x) throws SQLException {
        throw new SQLException("updateObject");
    }

    public void updateNull(String columnName) throws SQLException {
        throw new SQLException("updateNull");
    }

    public void updateBoolean(String columnName, boolean x) throws SQLException {
        throw new SQLException("updateBoolean");
    }

    public void updateByte(String columnName, byte x) throws SQLException {
        throw new SQLException("updateByte");
    }

    public void updateShort(String columnName, short x) throws SQLException {
        throw new SQLException("updateShort");
    }

    public void updateInt(String columnName, int x) throws SQLException {
        throw new SQLException("updateInt");
    }

    public void updateLong(String columnName, long x) throws SQLException {
        throw new SQLException("updateLong");
    }

    public void updateFloat(String columnName, float x) throws SQLException {
        throw new SQLException("updateFloat");
    }

    public void updateDouble(String columnName, double x) throws SQLException {
        throw new SQLException("updateDouble");
    }

    public void updateBigDecimal(String columnName, BigDecimal x) throws SQLException {
        throw new SQLException("updateBigDecimal");
    }

    public void updateString(String columnName, String x) throws SQLException {
        throw new SQLException("updateString");
    }

    public void updateBytes(String columnName, byte[] x) throws SQLException {
        throw new SQLException("updateBytes");
    }

    public void updateDate(String columnName, Date x) throws SQLException {
        throw new SQLException("updateDate");
    }

    public void updateTime(String columnName, Time x) throws SQLException {
        throw new SQLException("updateTime");
    }

    public void updateTimestamp(String columnName, Timestamp x) throws SQLException {
        throw new SQLException("updateTimestamp");
    }

    public void updateAsciiStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("updateAsciiStream");
    }

    public void updateBinaryStream(String columnName, InputStream x, int length) throws SQLException {
        throw new SQLException("updateBinaryStream");
    }

    public void updateCharacterStream(String columnName, Reader x, int length) throws SQLException {
        throw new SQLException("updateCharacterStream");
    }

    public void updateObject(String columnName, Object x, int scale) throws SQLException {
        throw new SQLException("updateObject");
    }

    public void updateObject(String columnName, Object x) throws SQLException {
        throw new SQLException("updateObject");
    }

    public void insertRow() throws SQLException {
        throw new SQLException("insertRow");
    }

    public void updateRow() throws SQLException {
        throw new SQLException("updateRow");
    }

    public void deleteRow() throws SQLException {
        throw new SQLException("deleteRow");
    }

    public void refreshRow() throws SQLException {
        throw new SQLException("refreshRow");
    }

    public void cancelRowUpdates() throws SQLException {
        throw new SQLException("cancelRowUpdates");
    }

    public void moveToInsertRow() throws SQLException {
        throw new SQLException("moveToInsertRow");
    }

    public void moveToCurrentRow() throws SQLException {
        throw new SQLException("moveToCurrentRow");
    }

    public Statement getStatement() throws SQLException {
        throw new SQLException("getStatement");
    }

    public Date getDate(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("getDate");
    }

    public Date getDate(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("getDate");
    }

    public Time getTime(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("getTime");
    }

    public Time getTime(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("getTime");
    }

    public Timestamp getTimestamp(int columnIndex, Calendar cal) throws SQLException {
        throw new SQLException("getTimestamp");
    }

    public Timestamp getTimestamp(String columnName, Calendar cal) throws SQLException {
        throw new SQLException("getTimestamp");
    }

    public URL getURL(int columnIndex) throws SQLException {
        throw new SQLException("getURL");
    }

    public URL getURL(String columnName) throws SQLException {
        throw new SQLException("getURL");
    }

    public Object getObject(int i, Map map) throws SQLException {
        throw new SQLException("getObject");
    }

    public Ref getRef(int i) throws SQLException {
        throw new SQLException("getRef");
    }

    public Blob getBlob(int i) throws SQLException {
        throw new SQLException("getBlob");
    }

    public Clob getClob(int i) throws SQLException {
        throw new SQLException("getClob");
    }

    public Array getArray(int i) throws SQLException {
        throw new SQLException("getArray");
    }

    public Object getObject(String colName, Map map) throws SQLException {
        throw new SQLException("getObject");
    }

    public Ref getRef(String colName) throws SQLException {
        throw new SQLException("getRef");
    }

    public Blob getBlob(String colName) throws SQLException {
        throw new SQLException("getBlob");
    }

    public Clob getClob(String colName) throws SQLException {
        throw new SQLException("getClob");
    }

    public Array getArray(String colName) throws SQLException {
        throw new SQLException("getArray");
    }

    public void updateRef(int columnIndex, Ref x) throws SQLException {
        throw new SQLException("updateRef");
    }

    public void updateRef(String columnName, Ref x) throws SQLException {
        throw new SQLException("updateRef");
    }

    public void updateBlob(int columnIndex, Blob x) throws SQLException {
        throw new SQLException("updateBlob");
    }

    public void updateBlob(String columnName, Blob x) throws SQLException {
        throw new SQLException("updateBlob");
    }

    public void updateClob(int columnIndex, Clob x) throws SQLException {
        throw new SQLException("updateClob");
    }

    public void updateClob(String columnName, Clob x) throws SQLException {
        throw new SQLException("updateClob");
    }

    public void updateArray(int columnIndex, Array x) throws SQLException {
        throw new SQLException("updateArray");
    }

    public void updateArray(String columnName, Array x) throws SQLException {
        throw new SQLException("updateArray");
    }
}

