/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class SQLAuthorizationPropTest
extends BaseJDBCTestCase {
    public SQLAuthorizationPropTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite(SQLAuthorizationPropTest.class, "SQLAuthorizationPropTest");
        Properties props = new Properties();
        props.setProperty("derby.database.sqlAuthorization", "true");
        SQLAuthorizationPropTest test = new SQLAuthorizationPropTest("grantRevokeAfterSettingSQLAuthProperty");
        suite.addTest((Test)new DatabasePropertyTestSetup((Test)test, props, true));
        suite.addTest((Test)new SQLAuthorizationPropTest("resetSQLAuthProperty"));
        return TestConfiguration.singleUseDatabaseDecorator((Test)suite);
    }

    protected void setUp() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("create table GR_TAB (id int)");
        stmt.close();
    }

    protected void tearDown() throws Exception {
        Statement stmt = this.createStatement();
        stmt.execute("drop table GR_TAB");
        stmt.close();
        super.tearDown();
    }

    public void testGrantRevokeWithoutSQLAuthProperty() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.execute("grant select on GR_TAB to some_user");
            SQLAuthorizationPropTest.fail((String)"FAIL: Grant statement should have failed when SQL authorization is not set");
        }
        catch (SQLException sqle) {
            SQLAuthorizationPropTest.assertSQLState("42Z60", sqle);
        }
        try {
            stmt.execute("revoke select on GR_TAB from some_user");
            SQLAuthorizationPropTest.fail((String)"FAIL: Revoke statement should have failed when SQL authorization is not set");
        }
        catch (SQLException sqle) {
            SQLAuthorizationPropTest.assertSQLState("42Z60", sqle);
        }
        stmt.close();
    }

    public void grantRevokeAfterSettingSQLAuthProperty() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.execute("grant select on GR_TAB to some_user");
        stmt.execute("revoke select on GR_TAB from some_user");
        stmt.close();
    }

    public void resetSQLAuthProperty() throws SQLException {
        Connection conn = this.getConnection();
        conn.setAutoCommit(false);
        CallableStatement setDBP = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        setDBP.setString(1, "derby.database.sqlAuthorization");
        this.testPropertyReset(setDBP, "false");
        this.testPropertyReset(setDBP, null);
        this.testPropertyReset(setDBP, "some_value");
        this.testPropertyReset(setDBP, "true");
        setDBP.close();
    }

    private void testPropertyReset(CallableStatement cs, String value) throws SQLException {
        cs.setString(2, value);
        try {
            cs.executeUpdate();
            if (value.compareToIgnoreCase("true") != 0) {
                SQLAuthorizationPropTest.fail((String)"FAIL: Should not be possible to reset sql authorization once it has been turned on");
            }
        }
        catch (SQLException sqle) {
            SQLAuthorizationPropTest.assertSQLState("XCY02", sqle);
        }
    }
}

