/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class OffsetFetchNextTest
extends BaseJDBCTestCase {
    public OffsetFetchNextTest(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("OffsetFetchNextTest");
        suite.addTest(OffsetFetchNextTest.baseSuite("OffsetFetchNextTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(OffsetFetchNextTest.baseSuite("OffsetFetchNextTest:client")));
        return suite;
    }

    public static Test baseSuite(String suiteName) {
        return new CleanDatabaseTestSetup((Test)new TestSuite(OffsetFetchNextTest.class, suiteName)){

            protected void decorateSQL(Statement s) throws SQLException {
                OffsetFetchNextTest.createSchemaObjects(s);
            }
        };
    }

    private static void createSchemaObjects(Statement st) throws SQLException {
        st.executeUpdate("create table t1 (a int, b bigint)");
        st.executeUpdate("insert into t1 (a, b) values (1,1), (1,2), (1,3), (1,4), (1,5)");
        st.executeUpdate("create table t2 (a int primary key, b bigint)");
        st.executeUpdate("insert into t2 (a, b) values (1,1), (2,1), (3,1), (4,1), (5,1)");
        st.executeUpdate("create table t3 (a int primary key,                  b bigint unique)");
        st.executeUpdate("insert into t3 (a, b) values (1,1), (2,2), (3,3), (4,4), (5,5)");
    }

    public void testErrors() throws Exception {
        Statement st = this.createStatement();
        OffsetFetchNextTest.assertStatementError("2201X", st, "select * from t1 offset -1 rows");
        OffsetFetchNextTest.assertStatementError("2201W", st, "select * from t1 fetch first 0 rows only");
        OffsetFetchNextTest.assertStatementError("2201W", st, "select * from t1 fetch first -1 rows only");
        OffsetFetchNextTest.assertStatementError("42X20", st, "select * from t1 fetch first 3.14 rows only");
        OffsetFetchNextTest.assertStatementError("42X01", st, "select * from t1 fetch first 0 rows only offset 0 rows");
    }

    public void testNewKeywordNonReserved() throws Exception {
        this.getConnection().prepareStatement("select a,b as OFFSET from t1 OFFSET 0 rows");
        this.getConnection().prepareStatement("select a,b from t1 AS OFFSET");
        this.getConnection().prepareStatement("select a,b OFFSET from t1 OFFSET");
    }

    public void testOffsetFetchFirstReadOnlyForwardOnlyRS() throws Exception {
        Statement stm = this.createStatement();
        this.queryAndCheck(stm, "select a,b from t1 offset 0 rows", new String[][]{{"1", "1"}, {"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.queryAndCheck(stm, "select a,b from t2 offset 0 rows", new String[][]{{"1", "1"}, {"2", "1"}, {"3", "1"}, {"4", "1"}, {"5", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 offset 0 rows", new String[][]{{"1", "1"}, {"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}});
        this.queryAndCheck(stm, "select a,b from t1 offset 1 rows", new String[][]{{"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.queryAndCheck(stm, "select a,b from t2 offset 1 rows", new String[][]{{"2", "1"}, {"3", "1"}, {"4", "1"}, {"5", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 offset 1 rows", new String[][]{{"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}});
        this.queryAndCheck(stm, "select a,b from t1 offset 4 rows", new String[][]{{"1", "5"}});
        this.queryAndCheck(stm, "select a,b from t2 offset 4 rows", new String[][]{{"5", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 offset 4 rows", new String[][]{{"5", "5"}});
        this.queryAndCheck(stm, "select a,b from t1 offset 1 row fetch next 1 rows only", new String[][]{{"1", "2"}});
        this.queryAndCheck(stm, "select a,b from t2 offset 1 row fetch next 1 rows only", new String[][]{{"2", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 offset 1 row  fetch next 1 rows only", new String[][]{{"2", "2"}});
        this.queryAndCheck(stm, "select a,b from t1 offset 1 rows fetch first 10 row only", new String[][]{{"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.queryAndCheck(stm, "select a,b from t2 offset 1 rows fetch first 10 row only", new String[][]{{"2", "1"}, {"3", "1"}, {"4", "1"}, {"5", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 offset 1 rows  fetch first 10 row only", new String[][]{{"2", "2"}, {"3", "3"}, {"4", "4"}, {"5", "5"}});
        this.queryAndCheck(stm, "select a,b from t1 offset 10 rows", new String[0][]);
        this.queryAndCheck(stm, "select a,b from t2 offset 10 rows", new String[0][]);
        this.queryAndCheck(stm, "select a,b from t3 offset 10 rows", new String[0][]);
        this.queryAndCheck(stm, "select a,b from t1 fetch first row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t2 fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t1 order by b asc fetch first row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t2 order by a asc fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 order by a asc fetch next row only", new String[][]{{"1", "1"}});
        this.queryAndCheck(stm, "select a,b from t1 order by b desc fetch first row only", new String[][]{{"1", "5"}});
        this.queryAndCheck(stm, "select a,b from t2 order by a desc fetch next row only", new String[][]{{"5", "1"}});
        this.queryAndCheck(stm, "select a,b from t3 order by a desc fetch next row only", new String[][]{{"5", "5"}});
        this.queryAndCheck(stm, "select max(a) from t1 group by b fetch first row only", new String[][]{{"1"}});
        this.queryAndCheck(stm, "select max(a) from t2 group by b offset 0 rows", new String[][]{{"5"}});
        this.queryAndCheck(stm, "select max(a) from t3 group by b     order by max(a) fetch next 2 rows only", new String[][]{{"1"}, {"2"}});
        this.queryAndCheck(stm, "select * from t1 union all select * from t1     fetch first 2 row only", new String[][]{{"1", "1"}, {"1", "2"}});
        this.queryAndCheck(stm, "select t2.b, t3.b from t2,t3 where t2.a=t3.a     fetch first 2 row only", new String[][]{{"1", "1"}, {"1", "2"}});
        stm.close();
    }

    public void testOffsetFetchFirstUpdatableForwardOnlyRS() throws Exception {
        Statement stm = this.createStatement(1003, 1008);
        this.getConnection().setAutoCommit(false);
        ResultSet rs = stm.executeQuery("select * from t1  offset 0 rows");
        rs.next();
        rs.next();
        rs.updateInt(1, -rs.getInt(1));
        rs.updateRow();
        rs.close();
        this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.rollback();
        rs = stm.executeQuery("select * from t1 offset 1 rows");
        rs.next();
        rs.updateInt(1, -rs.getInt(1));
        rs.updateRow();
        rs.close();
        this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.rollback();
        stm.close();
    }

    public void testOffsetFetchFirstReadOnlyScrollableRS() throws Exception {
        Statement stm = this.createStatement(1004, 1007);
        ResultSet rs = stm.executeQuery("select * from t1  offset 0 rows");
        rs.next();
        rs.next();
        OffsetFetchNextTest.assertTrue((rs.getInt(2) == 2 ? 1 : 0) != 0);
        rs.close();
        rs = stm.executeQuery("select * from t1 offset 1 rows fetch next 3 rows only");
        rs.next();
        rs.next();
        OffsetFetchNextTest.assertTrue((rs.getInt(2) == 3 ? 1 : 0) != 0);
        rs.previous();
        OffsetFetchNextTest.assertTrue((rs.getInt(2) == 2 ? 1 : 0) != 0);
        rs.previous();
        OffsetFetchNextTest.assertTrue((boolean)rs.isBeforeFirst());
        rs.next();
        rs.next();
        rs.next();
        rs.next();
        OffsetFetchNextTest.assertTrue((boolean)rs.isAfterLast());
        stm.close();
    }

    public void testOffsetFetchFirstUpdatableScrollableRS() throws Exception {
        Statement stm = this.createStatement(1004, 1008);
        this.getConnection().setAutoCommit(false);
        ResultSet rs = stm.executeQuery("select * from t1  offset 0 rows for update");
        rs.next();
        rs.next();
        rs.updateInt(1, -rs.getInt(1));
        rs.updateRow();
        rs.close();
        this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "5"}});
        this.rollback();
        rs = stm.executeQuery("select * from t1 offset 1 rows fetch next 3 rows only");
        rs.next();
        rs.next();
        rs.updateInt(1, -rs.getInt(1));
        rs.updateRow();
        rs.previous();
        rs.updateInt(1, -rs.getInt(1));
        rs.updateRow();
        rs.previous();
        OffsetFetchNextTest.assertTrue((boolean)rs.isBeforeFirst());
        rs.next();
        rs.next();
        rs.next();
        rs.next();
        OffsetFetchNextTest.assertTrue((boolean)rs.isAfterLast());
        rs.moveToInsertRow();
        rs.updateInt(1, 42);
        rs.updateInt(2, 42);
        rs.insertRow();
        rs.previous();
        rs.deleteRow();
        rs.previous();
        rs.next();
        OffsetFetchNextTest.assertTrue((boolean)rs.rowDeleted());
        rs.close();
        this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"-1", "2"}, {"-1", "3"}, {"1", "5"}, {"42", "42"}});
        this.rollback();
        rs = stm.executeQuery("select * from t1 where a + 1 < b offset 1 rows");
        rs.absolute(2);
        OffsetFetchNextTest.assertTrue((rs.getInt(2) == 5 ? 1 : 0) != 0);
        rs.updateInt(2, -5);
        rs.updateRow();
        rs.close();
        this.queryAndCheck(stm, "select a,b from t1", new String[][]{{"1", "1"}, {"1", "2"}, {"1", "3"}, {"1", "4"}, {"1", "-5"}});
        this.rollback();
        stm.close();
    }

    public void testMetadata() throws SQLException {
        Statement stm = this.createStatement();
        ResultSet rs = stm.executeQuery("select * from t1 offset 1 rows");
        ResultSetMetaData rsmd = rs.getMetaData();
        int cnt = rsmd.getColumnCount();
        String[] cols = new String[]{"A", "B"};
        int[] types = new int[]{4, -5};
        for (int i = 1; i <= cnt; ++i) {
            String name = rsmd.getColumnName(i);
            int type = rsmd.getColumnType(i);
            OffsetFetchNextTest.assertTrue((boolean)name.equals(cols[i - 1]));
            OffsetFetchNextTest.assertTrue((type == types[i - 1] ? 1 : 0) != 0);
        }
        rs.close();
        stm.close();
    }

    public void testRunTimeStatistics() throws SQLException {
        Statement stm = this.createStatement();
        stm.executeUpdate("call syscs_util.syscs_set_runtimestatistics(1)");
        this.queryAndCheck(stm, "select a,b from t1 offset 2 rows", new String[][]{{"1", "3"}, {"1", "4"}, {"1", "5"}});
        stm.executeUpdate("call syscs_util.syscs_set_runtimestatistics(0)");
        ResultSet rs = stm.executeQuery("values syscs_util.syscs_get_runtimestatistics()");
        rs.next();
        String plan = rs.getString(1);
        OffsetFetchNextTest.assertTrue((plan.indexOf("Row Count (1):\nNumber of opens = 1\nRows seen = 3\nRows filtered = 2") != -1 ? 1 : 0) != 0);
        rs.close();
        stm.close();
    }

    public void testBigTable() throws SQLException {
        Statement stm = this.createStatement();
        this.getConnection().setAutoCommit(false);
        stm.executeUpdate("declare global temporary table session.t (i int) on commit preserve rows not logged");
        PreparedStatement ps = this.getConnection().prepareStatement("insert into session.t values ?");
        for (int i = 1; i <= 100000; ++i) {
            ps.setInt(1, i);
            ps.executeUpdate();
            if (i % 10000 != 0) continue;
            this.commit();
        }
        this.queryAndCheck(stm, "select count(*) from session.t", new String[][]{{"100000"}});
        this.queryAndCheck(stm, "select i from session.t offset 99999 rows", new String[][]{{"100000"}});
        stm.executeUpdate("drop table session.t");
        stm.close();
    }

    public void testRepeatedExecution() throws SQLException {
        PreparedStatement ps = this.prepareStatement("select * from t1 order by b offset 2 rows fetch next 2 rows only");
        String[][] expected = new String[][]{{"1", "3"}, {"1", "4"}};
        for (int i = 0; i < 10; ++i) {
            JDBC.assertFullResultSet(ps.executeQuery(), expected);
        }
    }

    private void queryAndCheck(Statement stm, String queryText, String[][] expectedRows) throws SQLException {
        ResultSet rs = stm.executeQuery(queryText);
        JDBC.assertFullResultSet(rs, expectedRows);
    }
}

