/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class ConnectTest
extends BaseJDBCTestCase {
    public ConnectTest(String name) {
        super(name);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("empty ConnectTest:DriverManager not supported");
        }
        return TestConfiguration.defaultSuite(ConnectTest.class);
    }

    public void testConnectRepeatedly() throws SQLException {
        String url = "jdbc:derby:wombat;create=true";
        Connection con = DriverManager.getConnection(url);
        Statement st = con.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery("values 1"), "1");
        st.close();
        con.close();
        con = DriverManager.getConnection(url);
        st = con.createStatement();
        JDBC.assertSingleValueResultSet(st.executeQuery("values 1"), "1");
        st.close();
        con.close();
    }

    public void testDBName() throws SQLException {
        String url = "jdbc:derby:wombat/seg0;create=true";
        try {
            DriverManager.getConnection(url);
            ConnectTest.fail((String)"Error XBM0J is expected");
        }
        catch (SQLException e) {
            ConnectTest.assertEquals((String)"XJ041", (String)e.getSQLState());
        }
        url = "jdbc:derby: ;databaseName=wombat";
        try {
            DriverManager.getConnection(url);
            ConnectTest.fail((String)"Error XJ004 is expected");
        }
        catch (SQLException e) {
            ConnectTest.assertEquals((String)"XJ004", (String)e.getSQLState());
        }
        url = "jdbc:derby:;databaseName=wombat";
        Connection con = DriverManager.getConnection(url);
        con.close();
    }

    public void testGrantAndRevoke() throws SQLException {
        String url = "jdbc:derby:wombat";
        Connection con = DriverManager.getConnection(url);
        String sql = "create table mytab(i int)";
        Statement st = con.createStatement();
        st.execute(sql);
        sql = "grant select on mytab to satheesh";
        try {
            st.executeUpdate(sql);
            ConnectTest.fail((String)"Error 42Z60 is expected");
        }
        catch (SQLException e) {
            ConnectTest.assertEquals((String)"42Z60", (String)e.getSQLState());
        }
        sql = "revoke select on mytab to satheesh";
        try {
            st.executeUpdate(sql);
            ConnectTest.fail((String)"Error 42Z60 is expected");
        }
        catch (SQLException e) {
            ConnectTest.assertEquals((String)"42Z60", (String)e.getSQLState());
        }
        sql = "drop table mytab";
        st.execute(sql);
        st.close();
        con.close();
    }
}

