/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.lang;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class Bug4356Test
extends BaseJDBCTestCase {
    public Bug4356Test(String name) {
        super(name);
    }

    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public static Test suite() {
        return new CleanDatabaseTestSetup(TestConfiguration.embeddedSuite(Bug4356Test.class)){

            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.executeUpdate("CREATE TABLE T1 (a integer, b integer)");
                stmt.executeUpdate("CREATE TABLE T2 (a integer)");
                stmt.executeUpdate("INSERT INTO T2 VALUES(1)");
            }
        };
    }

    protected void setUp() throws Exception {
        super.setUp();
    }

    public void testBug4356() throws SQLException {
        Statement stmt = this.createStatement();
        PreparedStatement ps = this.prepareStatement("INSERT INTO T1 VALUES (?,(select count(*) from t2 where a = ?)) ");
        ps.setInt(1, 1);
        ps.setInt(2, 1);
        ps.executeUpdate();
        ps.setInt(1, 2);
        ps.setInt(2, 2);
        ps.executeUpdate();
        this.commit();
        ResultSet rs = stmt.executeQuery("SELECT * FROM T1");
        JDBC.assertFullResultSet(rs, new String[][]{{"1", "1"}, {"2", "0"}});
        rs.close();
        stmt.close();
    }
}

