/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;

public class metadataMultiConnTest
extends BaseJDBCTestCase {
    public metadataMultiConnTest(String name) {
        super(name);
    }

    public static Test suite() {
        return new TestSuite(metadataMultiConnTest.class);
    }

    public void testMetadataMultiConn() throws SQLException {
        Connection conn1 = this.openDefaultConnection();
        this.metadataCalls(conn1);
        Connection conn2 = this.openDefaultConnection();
        this.metadataCalls(conn2);
        Connection conn3 = this.openDefaultConnection();
        this.metadataCalls(conn3);
        conn1.commit();
        conn2.commit();
        this.checkConsistencyOfAllTables(conn3);
    }

    public void metadataCalls(Connection conn) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        this.getTypeInfo(dmd);
        this.getTables(dmd);
        this.getColumnInfo(dmd);
        this.getPrimaryKeys(dmd);
        this.getExportedKeys(dmd);
    }

    public void getTypeInfo(DatabaseMetaData dmd) throws SQLException {
        ResultSet rs = dmd.getTypeInfo();
        JDBC.assertDrainResults(rs);
    }

    public void getTables(DatabaseMetaData dmd) throws SQLException {
        String[] types = new String[]{"TABLE"};
        ResultSet rs = dmd.getTables(null, null, null, types);
        JDBC.assertDrainResults(rs);
    }

    public void getColumnInfo(DatabaseMetaData dmd) throws SQLException {
        ResultSet rs = dmd.getColumns(null, null, "%", "%");
        JDBC.assertDrainResults(rs);
    }

    public void getPrimaryKeys(DatabaseMetaData dmd) throws SQLException {
        ResultSet rs = dmd.getPrimaryKeys(null, null, "%");
        JDBC.assertDrainResults(rs);
    }

    public void getExportedKeys(DatabaseMetaData dmd) throws SQLException {
        ResultSet rs = dmd.getExportedKeys(null, null, "%");
        JDBC.assertDrainResults(rs);
    }

    public void checkConsistencyOfAllTables(Connection conn) throws SQLException {
        Statement s = conn.createStatement();
        ResultSet rs = s.executeQuery("SELECT schemaname, tablename, SYSCS_UTIL.SYSCS_CHECK_TABLE(schemaname, tablename) FROM sys.sysschemas s, sys.systables t WHERE s.schemaid = t.schemaid");
        while (rs.next()) {
            metadataMultiConnTest.assertTrue((boolean)rs.getBoolean(3));
        }
        rs.close();
        s.close();
    }
}

