/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.InputStream;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import org.apache.derby.tools.ij;

public class connectionJdbc20 {
    public static void main(String[] args) {
        System.out.println("Test connection20 starting");
        try {
            ij.getPropertyArg((String[])args);
            Connection conn = ij.startJBMS();
            Statement stmt = conn.createStatement();
            stmt.execute("create table tab1(c1 char(100) for bit data,c2 varchar(100) for bit data,c3 long varchar for bit data,c4 char(100),c5 varchar(100),c6 long varchar)");
            Connection connreturn = stmt.getConnection();
            if (conn.equals(connreturn)) {
                System.out.println("Got Same Connection Object");
            } else {
                System.out.println("Got Different Connection Object");
            }
            connectionJdbc20.load_data(connreturn);
            ResultSet rs = stmt.executeQuery("select c1,c2,c3,c4,c5,c6,c1 as c1_spare,c2 as c2_spare,c3 as c3_spare from tab1");
            for (int loop = 0; loop < 2; ++loop) {
                while (rs.next()) {
                    for (int i = 1; i < 7; ++i) {
                        connectionJdbc20.get_using_object(rs, i);
                        connectionJdbc20.get_using_string(rs, i);
                        connectionJdbc20.get_using_ascii_stream(rs, i);
                        if (i >= 4) continue;
                        connectionJdbc20.get_using_binary_stream(rs, i + 6);
                        connectionJdbc20.get_using_bytes(rs, i + 6);
                    }
                }
                Statement stmtreturn = rs.getStatement();
                if (stmt.equals(stmtreturn)) {
                    System.out.println("Got Same Statement Object");
                } else {
                    System.out.println("Got Different Statement Object");
                }
                rs.close();
                rs = stmt.executeQuery("select c1,c2,c3,c4,c5,c6,c1 as c1_spare,c2 as c2_spare,c3 as c3_spare from tab1");
            }
            stmt.close();
            DatabaseMetaData dbmeta = conn.getMetaData();
            rs = dbmeta.getTypeInfo();
            while (rs.next()) {
                System.out.println(rs.getString(1));
            }
            stmt = rs.getStatement();
            rs.close();
            System.out.println("Try to Get the connection back from metadata");
            connreturn = dbmeta.getConnection();
            if (conn.equals(connreturn)) {
                System.out.println("Got Same Connection Object");
            } else {
                System.out.println("Got Different Connection Object");
            }
            CallableStatement cs = conn.prepareCall("select * from tab1");
            System.out.println(" Try to get the connection back from a callable stmt");
            connreturn = cs.getConnection();
            if (conn.equals(connreturn)) {
                System.out.println("Got Same Connection Object");
            } else {
                System.out.println("Got Different Connection Object");
            }
            cs.close();
            conn.close();
        }
        catch (SQLException e) {
            connectionJdbc20.dumpSQLExceptions(e);
            e.printStackTrace();
        }
        catch (Throwable e) {
            System.out.println("FAIL -- unexpected exception: " + e);
            e.printStackTrace();
        }
        System.out.println("Test getConnection  finished");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void load_data(Connection conn) throws Exception {
        PreparedStatement pstmt = null;
        try {
            pstmt = conn.prepareStatement("insert into tab1 values(?,?,?,?,?,?)");
            String c1_value = "C1XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
            String c2_value = "C2XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
            String c3_value = "C3XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
            String c4_value = "C4XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
            String c5_value = "C5XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
            String c6_value = "C6XXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXXX";
            pstmt.setBytes(1, c1_value.getBytes("US-ASCII"));
            pstmt.setBytes(2, c2_value.getBytes("US-ASCII"));
            pstmt.setBytes(3, c3_value.getBytes("US-ASCII"));
            pstmt.setString(4, c4_value);
            pstmt.setString(5, c5_value);
            pstmt.setString(6, c6_value);
            pstmt.execute();
            System.out.println("Try to get connection using preaparedstatement");
            Connection connreturn = pstmt.getConnection();
            if (conn.equals(connreturn)) {
                System.out.println("Got Same Connection Object");
            } else {
                System.out.println("Got Different Connection Object");
            }
        }
        catch (SQLException e) {
            connectionJdbc20.dumpSQLExceptions(e);
            e.printStackTrace();
        }
        catch (Throwable e) {
            System.out.println("Fail -- unexpected exception ");
            e.printStackTrace();
        }
        finally {
            pstmt.close();
        }
    }

    private static void dumpSQLExceptions(SQLException se) {
        System.out.println("FAIL -- unexpected exception");
        while (se != null) {
            System.out.println("SQLSTATE(" + se.getSQLState() + "): " + se);
            se = se.getNextException();
        }
    }

    private static void dumpExpectedSQLExceptions(SQLException se) {
        System.out.println("PASS -- expected exception");
        while (se != null) {
            System.out.println("SQLSTATE(" + se.getSQLState() + "): " + se);
            se = se.getNextException();
        }
    }

    private static int printbytearray(byte[] a, int len, int count) {
        int i = 0;
        while (i < len) {
            System.out.print("x" + Integer.toHexString(a[i]));
            if (i > 0 && i % 20 == 0) {
                System.out.println("");
            }
            ++i;
            ++count;
        }
        return count;
    }

    static void get_using_object(ResultSet rs, int col_no) throws Exception {
        System.out.println("getObject(" + col_no + ")");
        Object cobj = rs.getObject(col_no);
        if (cobj instanceof byte[]) {
            byte[] bytearray = (byte[])cobj;
            System.out.println("  as byte[] length " + bytearray.length);
            connectionJdbc20.printbytearray(bytearray, bytearray.length, 0);
            System.out.println("");
        } else {
            System.out.println("  as String");
            System.out.println(cobj.toString());
        }
    }

    static void get_using_bytes(ResultSet rs, int col_no) throws Exception {
        System.out.println("getBytes(" + col_no + ")");
        byte[] bytearray = rs.getBytes(col_no);
        connectionJdbc20.printbytearray(bytearray, bytearray.length, 0);
        System.out.println("");
    }

    static void get_using_string(ResultSet rs, int col_no) throws Exception {
        String s = rs.getString(col_no);
        System.out.println("getString(" + col_no + ") length " + s.length());
        System.out.println(s);
    }

    static void get_using_ascii_stream(ResultSet rs, int col_no) throws Exception {
        System.out.println("getAsciiStream(" + col_no + ")");
        int no_bytes_read = 0;
        InputStream rsbin = rs.getAsciiStream(col_no);
        byte[] bytearray = new byte[200];
        int count = 0;
        while ((no_bytes_read = rsbin.read(bytearray)) != -1) {
            count = connectionJdbc20.printbytearray(bytearray, no_bytes_read, count);
        }
        System.out.println("");
    }

    static void get_using_binary_stream(ResultSet rs, int col_no) throws Exception {
        System.out.println("getBinaryStream(" + col_no + ")");
        int no_bytes_read = 0;
        InputStream rsbin = rs.getBinaryStream(col_no);
        byte[] bytearray = new byte[200];
        int count = 0;
        while ((no_bytes_read = rsbin.read(bytearray)) != -1) {
            count = connectionJdbc20.printbytearray(bytearray, no_bytes_read, count);
        }
        System.out.println("");
    }
}

