/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class StatementJdbc20Test
extends BaseJDBCTestCase {
    public StatementJdbc20Test(String name) {
        super(name);
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("StatementJdbc20Test");
        suite.addTest(StatementJdbc20Test.baseSuite("StatementJdbc20Test:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(StatementJdbc20Test.baseSuite("StatementJdbc20Test:client")));
        return suite;
    }

    private static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(StatementJdbc20Test.class);
        return new CleanDatabaseTestSetup((Test)suite){

            protected void decorateSQL(Statement stmt) throws SQLException {
                Connection conn = this.getConnection();
                stmt.execute("create table tab1 (i int, s smallint, r real)");
                stmt.executeUpdate("insert into tab1 values(1, 2, 3.1)");
            }
        };
    }

    public void testWrongVaues() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.setFetchSize(25);
        stmt.setFetchDirection(1001);
        stmt.setEscapeProcessing(true);
        try {
            stmt.setFetchSize(-1000);
            StatementJdbc20Test.fail((String)"setFetchSize(-1000) expected to fail");
        }
        catch (SQLException e) {
            StatementJdbc20Test.assertSQLState("XJ065", e);
        }
        try {
            stmt.setFetchDirection(-1000);
            StatementJdbc20Test.fail((String)"setFetchDirection(-1000) expected to fail");
        }
        catch (SQLException e) {
            StatementJdbc20Test.assertSQLState("XJ064", e);
        }
        StatementJdbc20Test.assertEquals((int)stmt.getFetchSize(), (int)25);
        StatementJdbc20Test.assertEquals((int)stmt.getFetchDirection(), (int)1001);
        stmt.close();
    }

    public void testReadingData() throws SQLException {
        Statement stmt = this.createStatement();
        ResultSet rs = stmt.executeQuery("select * from tab1");
        while (rs.next()) {
            StatementJdbc20Test.assertEquals((int)rs.getInt(1), (int)1);
            StatementJdbc20Test.assertEquals((int)rs.getShort(2), (int)2);
            StatementJdbc20Test.assertEquals((double)rs.getDouble(3), (double)3.1, (double)0.01);
        }
        rs.close();
        stmt.close();
    }

    public void testLocalValuesOfResultSet() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.setFetchSize(25);
        stmt.setFetchDirection(1001);
        stmt.setEscapeProcessing(true);
        ResultSet rs = stmt.executeQuery("select * from tab1");
        StatementJdbc20Test.assertEquals((int)rs.getFetchSize(), (int)25);
        StatementJdbc20Test.assertEquals((int)rs.getFetchDirection(), (int)1001);
        rs.setFetchSize(250);
        try {
            rs.setFetchDirection(1000);
        }
        catch (SQLException e) {
            if (StatementJdbc20Test.usingEmbedded()) {
                StatementJdbc20Test.assertSQLState("XJ061", e);
            }
            StatementJdbc20Test.assertSQLState("XJ125", e);
        }
        StatementJdbc20Test.assertEquals((int)rs.getFetchSize(), (int)250);
        StatementJdbc20Test.assertEquals((int)rs.getFetchDirection(), (int)1001);
        stmt.setMaxRows(10);
        try {
            rs.setFetchSize(100);
        }
        catch (SQLException e) {
            StatementJdbc20Test.assertSQLState("XJ062", e);
        }
        try {
            rs.setFetchSize(-2000);
            StatementJdbc20Test.fail((String)"setFetchSize(-2000) expected to fail");
        }
        catch (SQLException e) {
            StatementJdbc20Test.assertSQLState("XJ062", e);
        }
        try {
            rs.setFetchDirection(-2000);
        }
        catch (SQLException e) {
            if (StatementJdbc20Test.usingEmbedded()) {
                StatementJdbc20Test.assertSQLState("XJ061", e);
            }
            StatementJdbc20Test.assertSQLState("XJ125", e);
        }
        rs.setFetchSize(0);
        stmt.setFetchSize(0);
        rs.close();
    }

    public void testCreateTableWithExecuteQuery() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeQuery("create table trash(c1 int)");
        }
        catch (SQLException e) {
            if (StatementJdbc20Test.usingEmbedded()) {
                StatementJdbc20Test.assertSQLState("X0Y78", e);
            }
            StatementJdbc20Test.assertSQLState("XJ207", e);
        }
        try {
            ResultSet rs = stmt.executeQuery("select * from trash");
            System.out.println("select from trash expected to fail");
        }
        catch (SQLException e) {
            StatementJdbc20Test.assertSQLState("42X05", e);
        }
        try {
            stmt.executeUpdate("values 1");
        }
        catch (SQLException e) {
            StatementJdbc20Test.assertSQLState("X0Y79", e);
        }
        stmt.close();
        this.commit();
    }
}

