/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.File;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class LDAPAuthenticationTest
extends BaseJDBCTestCase {
    private static String ldapServer;
    private static String ldapPort;
    private static String dnString;
    private static String ldapUser;
    private static String ldapPassword;
    private static String ldapContextFactory;
    private static String POLICY_FILE_NAME;
    private static String TARGET_POLICY_FILE_NAME;

    public LDAPAuthenticationTest(String name) {
        super(name);
    }

    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("cannt run with JSR169 - missing functionality for org.apache.derby.iapi.jdbc.AuthenticationService");
        }
        ldapUser = LDAPAuthenticationTest.getSystemProperty("derbyTesting.ldapUser");
        if (ldapUser == null || ldapUser.length() < 1) {
            return new TestSuite("LDAPAuthenticationTest requires property derbyTesting.ldapUser set to a valid user set up on the ldapServer, eg: -DderbyTesting.ldapUser=CharliesPwd. In addition,test requires a user 'kathy', pwd 'kathyS' to be set up");
        }
        ldapPassword = LDAPAuthenticationTest.getSystemProperty("derbyTesting.ldapPassword");
        if (ldapPassword == null || ldapPassword.length() < 1) {
            return new TestSuite("LDAPAuthenticationTest requires property derbyTesting.ldapPassword set the password of a valid user set up on the ldapServer, eg: -DderbyTesting.ldapPassword=Charlie");
        }
        ldapServer = LDAPAuthenticationTest.getSystemProperty("derbyTesting.ldapServer");
        if (ldapServer == null || ldapServer.length() < 1) {
            return new TestSuite("LDAPAuthenticationTest requires property derbyTesting.ldapServer set, eg: -DderbyTesting.ldapServer=myldapserver.myorg.org");
        }
        ldapPort = LDAPAuthenticationTest.getSystemProperty("derbyTesting.ldapPort");
        if (ldapPort == null || ldapPort.length() < 1) {
            return new TestSuite("LDAPAuthenticationTest requires property derbyTesting.ldapPort set, eg: -DderbyTesting.ldapPort=333");
        }
        dnString = LDAPAuthenticationTest.getSystemProperty("derbyTesting.dnString");
        if (dnString == null || dnString.length() < 1) {
            return new TestSuite("LDAPAuthenticationTest requires property derbyTesting.dnString for setting o=, eg: -DderbyTesting.dnString=myJNDIstring");
        }
        ldapContextFactory = LDAPAuthenticationTest.getSystemProperty("derbyTesting.ldapContextFactory");
        TestSuite suite = new TestSuite("LDAPAuthenticationTest");
        suite.addTest(LDAPAuthenticationTest.baseSuite("LDAPAuthenticationTest:embedded", "testLDAPConnection"));
        suite.addTest(TestConfiguration.clientServerDecorator(LDAPAuthenticationTest.baseSuite("LDAPAuthenticationTest:client", "testLDAPConnection")));
        Test test = LDAPAuthenticationTest.decorateWithPolicy((Test)suite);
        return test;
    }

    public static Test baseSuite(String name, String fixture) {
        TestSuite suite = new TestSuite(name);
        LDAPAuthenticationTest test = new LDAPAuthenticationTest(fixture);
        LDAPAuthenticationTest.setBaseProps(suite, (Test)test);
        return TestConfiguration.singleUseDatabaseDecorator((Test)suite);
    }

    protected static void setBaseProps(TestSuite suite, Test test) {
        Properties props = new Properties();
        props.setProperty("derby.infolog.append", "true");
        props.setProperty("derby.debug.true", "AuthenticationTrace");
        props.setProperty("derby.user.system", "manager");
        props.setProperty("derby.user.Jamie", "theHooligan");
        suite.addTest((Test)new DatabasePropertyTestSetup(test, props, true));
    }

    private static Test decorateWithPolicy(Test test) {
        String ldapPolicyName = new LDAPAuthenticationTest("test").makeServerPolicyName();
        test = new SecurityManagerSetup((Test)test, ldapPolicyName);
        test = new SupportFilesSetup((Test)test, null, new String[]{POLICY_FILE_NAME}, null, new String[]{TARGET_POLICY_FILE_NAME});
        return test;
    }

    private String makeServerPolicyName() {
        try {
            String userDir = LDAPAuthenticationTest.getSystemProperty("user.dir");
            String fileName = userDir + File.separator + "extinout" + File.separator + TARGET_POLICY_FILE_NAME;
            File file = new File(fileName);
            String urlString = file.toURL().toExternalForm();
            return urlString;
        }
        catch (Exception e) {
            return null;
        }
    }

    protected void tearDown() throws Exception {
        LDAPAuthenticationTest.removeSystemProperty("derby.connection.requireAuthentication");
        super.tearDown();
    }

    protected void setDatabaseProperty(String propertyName, String value, Connection conn) throws SQLException {
        CallableStatement setDBP = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        setDBP.setString(1, propertyName);
        setDBP.setString(2, value);
        setDBP.execute();
        setDBP.close();
    }

    protected String getDatabaseProperty(String propertyName, Connection conn) throws SQLException {
        PreparedStatement getDBP = conn.prepareStatement("VALUES SYSCS_UTIL.SYSCS_GET_DATABASE_PROPERTY(?)");
        getDBP.setString(1, propertyName);
        ResultSet rs = getDBP.executeQuery();
        rs.next();
        String value = rs.getString(1);
        rs.close();
        return value;
    }

    public void testLDAPConnection() throws SQLException {
        String dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        DataSource ds = JDBCDataSource.getDataSource();
        Connection conn = ds.getConnection("system", "admin");
        this.setDatabaseProperty("derby.connection.requireAuthentication", "true", conn);
        this.setDatabaseProperty("derby.authentication.provider", "LDAP", conn);
        this.setDatabaseProperty("derby.authentication.server", ldapServer, conn);
        this.setDatabaseProperty("derby.authentication.ldap.searchBase", "o=" + dnString, conn);
        this.setDatabaseProperty("derby.authentication.ldap.searchFilter", "(&(objectClass=inetOrgPerson)(uid=%USERNAME%))", conn);
        if (ldapContextFactory != null && ldapContextFactory.length() > 0) {
            this.setDatabaseProperty("java.naming.factory.initial", ldapContextFactory, conn);
        }
        this.commit();
        TestConfiguration.getCurrent().shutdownDatabase();
        conn.close();
        ds = JDBCDataSource.getDataSource(dbName);
        this.assertLDAPDSConnectionOK(ds, ldapUser, ldapPassword);
        this.assertLDAPDrvMgrConnectionOK(dbName, ldapUser, ldapPassword);
        this.assertInvalidLDAPDSConnectionFails(ds, "Jamie", "theHooligan");
        this.assertInvalidLDAPDrvMgrConnectionFails(dbName, "Jamie", "thHooligan");
        this.assertInvalidLDAPDSConnectionFails(ds, ldapUser, ldapPassword + "ish");
        this.assertInvalidLDAPDrvMgrConnectionFails(dbName, ldapUser, ldapPassword + "ish");
        Connection conn3 = ds.getConnection(ldapUser, ldapPassword);
        String tmpString1 = "derby.user." + ldapUser;
        String tmpString2 = "uid=" + ldapUser + ",ou=People,o=" + dnString;
        this.setDatabaseProperty(tmpString1, tmpString2, conn3);
        conn3.commit();
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        try {
            ds.getConnection(ldapUser, ldapPassword);
            LDAPAuthenticationTest.fail((String)"expected system shutdown resulting in 08006 error.");
        }
        catch (SQLException e) {
            LDAPAuthenticationTest.assertSQLState("08006", e);
        }
        conn3.close();
        dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
        ds = JDBCDataSource.getDataSource(dbName);
        this.assertLDAPDSConnectionOK(ds, ldapUser, ldapPassword);
        this.assertLDAPDrvMgrConnectionOK(dbName, ldapUser, ldapPassword);
        this.assertLDAPDSConnectionOK(ds, "kathy", "kathyS");
        this.assertLDAPDrvMgrConnectionOK(dbName, "kathy", "kathyS");
        this.assertInvalidLDAPDSConnectionFails(ds, "Jamie", "theHooligan");
        this.assertInvalidLDAPDrvMgrConnectionFails(dbName, "Jamie", "theHooligan");
        this.assertInvalidLDAPDSConnectionFails(ds, ldapUser, ldapPassword + "ish");
        this.assertInvalidLDAPDrvMgrConnectionFails(dbName, ldapUser, ldapPassword + "ish");
        this.assertLDAPDSConnectionOK(ds, ldapUser, ldapPassword);
        this.assertDSSystemShutdownOK("someuser", "somestring");
        this.cleanup(ds);
    }

    protected void cleanup(DataSource ds) throws SQLException {
        Connection conn2 = ds.getConnection(ldapUser, ldapPassword);
        this.setDatabaseProperty("derby.connection.requireAuthentication", "false", conn2);
        conn2.commit();
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        try {
            ds.getConnection(ldapUser, ldapPassword);
            LDAPAuthenticationTest.fail((String)"expected system shutdown resulting in 08006 error.");
        }
        catch (SQLException e) {
            LDAPAuthenticationTest.assertSQLState("08006", e);
        }
        conn2.close();
    }

    public void assertLDAPDSConnectionOK(DataSource ds, String user, String password) throws SQLException {
        Connection conn = ds.getConnection(user, password);
        LDAPAuthenticationTest.assertNotNull((Object)conn);
        conn.close();
    }

    protected void assertLDAPDrvMgrConnectionOK(String dbName, String user, String password) throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        Connection conn = DriverManager.getConnection(url, user, password);
        LDAPAuthenticationTest.assertNotNull((Object)conn);
        conn.close();
    }

    public void assertInvalidLDAPDSConnectionFails(DataSource ds, String user, String password) throws SQLException {
        try {
            ds.getConnection(user, password);
            LDAPAuthenticationTest.fail((String)"expected invalid connection error (for DataSource)");
        }
        catch (SQLException se) {
            LDAPAuthenticationTest.assertSQLState("08004", se);
        }
    }

    protected void assertInvalidLDAPDrvMgrConnectionFails(String dbName, String user, String password) throws SQLException {
        String url = TestConfiguration.getCurrent().getJDBCUrl(dbName);
        try {
            DriverManager.getConnection(url, user, password).close();
            LDAPAuthenticationTest.fail((String)"expected invalid connection error (for DataSource)");
        }
        catch (SQLException se) {
            LDAPAuthenticationTest.assertSQLState("08004", se);
        }
    }

    protected void assertDSSystemShutdownOK(String user, String password) throws SQLException {
        DataSource ds;
        if (LDAPAuthenticationTest.usingEmbedded()) {
            ds = JDBCDataSource.getDataSource();
            JDBCDataSource.clearStringBeanProperty(ds, "databaseName");
        } else {
            ds = JDBCDataSource.getDataSource("");
        }
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        try {
            ds.getConnection(user, password);
            LDAPAuthenticationTest.fail((String)"expected system shutdown resulting in XJ015 error");
        }
        catch (SQLException e) {
            LDAPAuthenticationTest.assertSQLState("XJ015", e);
        }
    }

    static {
        POLICY_FILE_NAME = "functionTests/tests/jdbcapi/LDAPTests.policy";
        TARGET_POLICY_FILE_NAME = "derby_tests.policy";
    }
}

