/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.JDBCDataSource;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class InvalidLDAPServerAuthenticationTest
extends BaseJDBCTestCase {
    public InvalidLDAPServerAuthenticationTest(String name) {
        super(name);
    }

    protected void initializeConnection(Connection conn) throws SQLException {
        conn.setAutoCommit(false);
    }

    public static Test suite() {
        if (JDBC.vmSupportsJSR169()) {
            return new TestSuite("InvalidLDAPServerAuthenticationTest - cannot run with JSR169 - missing functionality for org.apache.derby.iapi.jdbc.AuthenticationService");
        }
        TestSuite suite = new TestSuite("InvalidLDAPServerAuthenticationTest");
        suite.addTest(SecurityManagerSetup.noSecurityManager(InvalidLDAPServerAuthenticationTest.baseSuite("testInvalidLDAPServerConnectionError")));
        suite.addTest(TestConfiguration.clientServerDecorator(SecurityManagerSetup.noSecurityManager(InvalidLDAPServerAuthenticationTest.baseSuite("testInvalidLDAPServerConnectionError"))));
        return suite;
    }

    public static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        InvalidLDAPServerAuthenticationTest test = new InvalidLDAPServerAuthenticationTest("testInvalidLDAPServerConnectionError");
        suite.addTest((Test)test);
        return TestConfiguration.singleUseDatabaseDecoratorNoShutdown((Test)suite);
    }

    protected void setDatabaseProperty(String propertyName, String value, Connection conn) throws SQLException {
        CallableStatement setDBP = conn.prepareCall("CALL SYSCS_UTIL.SYSCS_SET_DATABASE_PROPERTY(?, ?)");
        setDBP.setString(1, propertyName);
        setDBP.setString(2, value);
        setDBP.execute();
        setDBP.close();
    }

    public void testInvalidLDAPServerConnectionError() throws SQLException {
        block5: {
            String dbName;
            block4: {
                Connection conn = this.getConnection();
                this.setDatabaseProperty("derby.connection.requireAuthentication", "true", conn);
                this.setDatabaseProperty("derby.authentication.provider", "LDAP", conn);
                this.setDatabaseProperty("derby.authentication.server", "noSuchServer", conn);
                this.setDatabaseProperty("derby.authentication.ldap.searchBase", "o=dnString", conn);
                this.setDatabaseProperty("derby.authentication.ldap.searchFilter", "(&(objectClass=inetOrgPerson)(uid=%USERNAME%))", conn);
                this.commit();
                conn.setAutoCommit(true);
                conn.close();
                TestConfiguration.getCurrent().shutdownDatabase();
                dbName = TestConfiguration.getCurrent().getDefaultDatabaseName();
                DataSource ds = JDBCDataSource.getDataSource(dbName);
                try {
                    ds.getConnection();
                    InvalidLDAPServerAuthenticationTest.fail((String)"expected java.net.UnknownHostException for datasource");
                }
                catch (SQLException se) {
                    InvalidLDAPServerAuthenticationTest.assertSQLState("08004", se);
                    if (!InvalidLDAPServerAuthenticationTest.usingEmbedded()) break block4;
                    InvalidLDAPServerAuthenticationTest.assertTrue((se.getMessage().indexOf("java.net.UnknownHostException") > 1 ? 1 : 0) != 0);
                }
            }
            String url2 = TestConfiguration.getCurrent().getJDBCUrl(dbName);
            try {
                DriverManager.getConnection(url2, "user", "password").close();
                InvalidLDAPServerAuthenticationTest.fail((String)"expected java.net.UnknownHostException for driver");
            }
            catch (SQLException se) {
                InvalidLDAPServerAuthenticationTest.assertSQLState("08004", se);
                if (!InvalidLDAPServerAuthenticationTest.usingEmbedded()) break block5;
                InvalidLDAPServerAuthenticationTest.assertTrue((se.getMessage().indexOf("java.net.UnknownHostException") > 1 ? 1 : 0) != 0);
            }
        }
        this.shutdownSystem();
    }

    protected void shutdownSystem() throws SQLException {
        DataSource ds;
        if (InvalidLDAPServerAuthenticationTest.usingEmbedded()) {
            ds = JDBCDataSource.getDataSource();
            JDBCDataSource.clearStringBeanProperty(ds, "databaseName");
        } else {
            ds = JDBCDataSource.getDataSource("");
        }
        JDBCDataSource.setBeanProperty(ds, "shutdownDatabase", "shutdown");
        try {
            ds.getConnection();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

