/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbcapi;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.sql.BatchUpdateException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Arrays;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.CleanDatabaseTestSetup;
import org.apache.derbyTesting.junit.DatabasePropertyTestSetup;
import org.apache.derbyTesting.junit.JDBC;
import org.apache.derbyTesting.junit.TestConfiguration;

public class BatchUpdateTest
extends BaseJDBCTestCase {
    public BatchUpdateTest(String name) {
        super(name);
    }

    public void setUp() throws Exception {
        this.getConnection().setAutoCommit(false);
        Statement s = this.createStatement();
        s.execute("delete from t1");
        s.close();
        this.commit();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("BatchUpdateTest");
        suite.addTest(BatchUpdateTest.baseSuite("BatchUpdateTest:embedded"));
        suite.addTest(TestConfiguration.clientServerDecorator(BatchUpdateTest.baseSuite("BatchUpdateTest:client")));
        return suite;
    }

    public static Test embeddedSuite() {
        TestSuite suite = new TestSuite("BatchUpdateTest");
        suite.addTest(BatchUpdateTest.baseSuite("BatchUpdateTest:embedded"));
        return suite;
    }

    protected static Test baseSuite(String name) {
        TestSuite suite = new TestSuite(name);
        suite.addTestSuite(BatchUpdateTest.class);
        return new CleanDatabaseTestSetup(DatabasePropertyTestSetup.setLockTimeouts((Test)suite, 2, 4)){

            protected void decorateSQL(Statement stmt) throws SQLException {
                stmt.execute("create table t1(c1 int)");
                stmt.execute("create table datetab(c1 date)");
                stmt.execute("create table timetab(c1 time)");
                stmt.execute("create table timestamptab(c1 timestamp)");
                stmt.execute("create table usertypetab(c1 DATE)");
                stmt.execute("create table assoc(x char(10) not null primary key, y char(100))");
                stmt.execute("create table assocout(x char(10))");
            }
        };
    }

    private void assertBatchUpdateCounts(int[] expectedBatchResult, int[] executeBatchResult) {
        BatchUpdateTest.assertEquals((String)"length of array should be identical", (int)expectedBatchResult.length, (int)executeBatchResult.length);
        for (int i = 0; i < expectedBatchResult.length; ++i) {
            String msg = "mismatch for array index [" + i + "] ; ";
            BatchUpdateTest.assertEquals((String)msg, (int)expectedBatchResult[i], (int)executeBatchResult[i]);
            BatchUpdateTest.println("expectedUpdate result #" + i + " : " + expectedBatchResult[i]);
            BatchUpdateTest.println("actual result #" + i + " : " + executeBatchResult[i]);
        }
    }

    protected void assertBatchExecuteError(String expectedError, Statement stmt, int[] expectedUpdateCount) throws SQLException {
        try {
            int[] updateCount = stmt.executeBatch();
            BatchUpdateTest.fail((String)"Expected batchExecute to fail");
        }
        catch (BatchUpdateException bue) {
            BatchUpdateTest.assertSQLState(expectedError, bue);
            int[] updateCount = bue.getUpdateCounts();
            this.assertBatchUpdateCounts(expectedUpdateCount, updateCount);
        }
    }

    public void testMinimalDDLInBatch() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.addBatch("create table ddltsttable1(c1 int)");
        stmt.addBatch("create procedure ddlinteg() language java parameter style java external name 'java.lang.Integer'");
        stmt.addBatch("create table ddltable2(c1 date)");
        int[] expectedCount = new int[]{0, 0, 0};
        this.assertBatchUpdateCounts(expectedCount, stmt.executeBatch());
        ResultSet rs = stmt.executeQuery("select count(*) from SYS.SYSTABLES where CAST(tablename AS VARCHAR(128)) like 'DDL%'");
        JDBC.assertSingleValueResultSet(rs, "2");
        rs = stmt.executeQuery("select count(*) from SYS.SYSALIASES where CAST(alias AS VARCHAR(128)) like 'DDL%'");
        JDBC.assertSingleValueResultSet(rs, "1");
        stmt.close();
        this.commit();
    }

    public void testEmptyStatementBatch() throws SQLException {
        Statement stmt = this.createStatement();
        BatchUpdateTest.println("Positive Statement: clear the batch and run the empty batch");
        stmt.clearBatch();
        this.assertBatchUpdateCounts(new int[0], stmt.executeBatch());
        stmt.close();
        this.commit();
    }

    public void testSingleStatementBatch() throws SQLException {
        Statement stmt = this.createStatement();
        BatchUpdateTest.println("Positive Statement: testing 1 statement batch");
        stmt.addBatch("insert into t1 values(2)");
        this.assertBatchUpdateCounts(new int[]{1}, stmt.executeBatch());
        stmt.close();
        this.commit();
    }

    public void testMultipleStatementsBatch() throws SQLException {
        Statement stmt = this.createStatement();
        BatchUpdateTest.println("Positive Statement: testing 2 inserts and 1 update batch");
        stmt.addBatch("insert into t1 values(2)");
        stmt.addBatch("update t1 set c1=4");
        stmt.addBatch("insert into t1 values(3)");
        this.assertBatchUpdateCounts(new int[]{1, 1, 1}, stmt.executeBatch());
        ResultSet rs = stmt.executeQuery("select count(*) from t1 where c1=2");
        rs.next();
        BatchUpdateTest.assertEquals((String)"expect 0 rows with c1 = 2", (int)0, (int)rs.getInt(1));
        rs.close();
        rs = stmt.executeQuery("select count(*) from t1 where c1=4");
        rs.next();
        BatchUpdateTest.assertEquals((String)"expect 1 row with c1 = 4", (int)1, (int)rs.getInt(1));
        rs.close();
        rs = stmt.executeQuery("select count(*) from t1 where c1=3");
        rs.next();
        BatchUpdateTest.assertEquals((String)"expect 1 row with c1 = 3", (int)1, (int)rs.getInt(1));
        rs.close();
        this.assertTableRowCount("T1", 2);
        stmt.close();
        this.commit();
    }

    public void test1000StatementsBatch() throws SQLException {
        Statement stmt = this.createStatement();
        BatchUpdateTest.println("Positive Statement: 1000 statements batch");
        for (int i = 0; i < 1000; ++i) {
            stmt.addBatch("insert into t1 values(1)");
        }
        int[] updateCount = stmt.executeBatch();
        int[] expectedUpdateCount = new int[1000];
        Arrays.fill(expectedUpdateCount, 1);
        this.assertBatchUpdateCounts(expectedUpdateCount, updateCount);
        this.assertTableRowCount("T1", 1000);
        stmt.close();
        this.commit();
    }

    public void testAutoCommitTrueBatch() throws SQLException {
        this.getConnection().setAutoCommit(true);
        Statement stmt = this.createStatement();
        BatchUpdateTest.println("Positive Statement: stmt testing with autocommit true");
        stmt.addBatch("insert into t1 values(1)");
        stmt.addBatch("insert into t1 values(1)");
        stmt.addBatch("delete from t1");
        this.assertBatchUpdateCounts(new int[]{1, 1, 2}, stmt.executeBatch());
        this.assertTableRowCount("T1", 0);
        stmt.close();
    }

    public void testCombinationsOfClearBatch() throws SQLException {
        Statement stmt = this.createStatement();
        BatchUpdateTest.println("Positive Statement: add 3 statements, clear and execute batch");
        stmt.addBatch("insert into t1 values(2)");
        stmt.addBatch("insert into t1 values(2)");
        stmt.addBatch("insert into t1 values(2)");
        stmt.clearBatch();
        this.assertBatchUpdateCounts(new int[0], stmt.executeBatch());
        this.assertTableRowCount("T1", 0);
        BatchUpdateTest.println("Positive Statement: add 3 statements, clear batch, add 3 more statements and execute batch");
        stmt.addBatch("insert into t1 values(2)");
        stmt.addBatch("insert into t1 values(2)");
        stmt.addBatch("insert into t1 values(2)");
        stmt.clearBatch();
        stmt.addBatch("insert into t1 values(2)");
        stmt.addBatch("insert into t1 values(2)");
        stmt.addBatch("insert into t1 values(2)");
        this.assertBatchUpdateCounts(new int[]{1, 1, 1}, stmt.executeBatch());
        this.assertTableRowCount("T1", 3);
        stmt.close();
        this.commit();
    }

    public void testAssociatedParams() throws SQLException {
        int i;
        Statement stmt = this.createStatement();
        BatchUpdateTest.println("Positive Statement: testing associated parameters");
        PreparedStatement checkps = this.prepareStatement("select x from assocout order by x");
        PreparedStatement ps = this.prepareStatement("insert into assoc values (?, 'hello')");
        for (i = 10; i < 60; ++i) {
            ps.setString(1, new Integer(i).toString());
            ps.executeUpdate();
        }
        ps.close();
        ps = this.prepareStatement("insert into assocout select x from assoc where x like ?");
        ps.setString(1, "33%");
        ps.addBatch();
        ps.setString(1, "21%");
        ps.addBatch();
        ps.setString(1, "49%");
        ps.addBatch();
        this.assertBatchUpdateCounts(new int[]{1, 1, 1}, ps.executeBatch());
        ps.close();
        checkps.execute();
        ResultSet rs = checkps.getResultSet();
        JDBC.assertFullResultSet(rs, new String[][]{{"21"}, {"33"}, {"49"}}, true);
        stmt.executeUpdate("delete from assocout");
        ps = this.prepareStatement("insert into assocout select x from assoc where x like ?");
        ps.setString(1, "3%");
        ps.addBatch();
        ps.setString(1, "2%");
        ps.addBatch();
        ps.setString(1, "1%");
        ps.addBatch();
        Object[][] expectedStrArray = new String[30][1];
        for (i = 10; i < 40; ++i) {
            expectedStrArray[i - 10][0] = String.valueOf(i);
        }
        this.assertBatchUpdateCounts(new int[]{10, 10, 10}, ps.executeBatch());
        ps.close();
        checkps.execute();
        rs = checkps.getResultSet();
        JDBC.assertFullResultSet(rs, expectedStrArray, true);
        stmt.executeUpdate("delete from assocout");
        ps = this.prepareStatement("insert into assocout select x from assoc where x like ?");
        ps.setString(1, "%");
        ps.addBatch();
        ps.setString(1, "666666");
        ps.addBatch();
        ps.setString(1, "%");
        ps.addBatch();
        Object[][] expectedStrArray2 = new String[100][1];
        int j = 0;
        for (i = 10; i < 60; ++i) {
            for (int twice = 0; twice < 2; ++twice) {
                expectedStrArray2[j][0] = String.valueOf(i);
                ++j;
            }
        }
        this.assertBatchUpdateCounts(new int[]{50, 0, 50}, ps.executeBatch());
        ps.close();
        checkps.execute();
        rs = checkps.getResultSet();
        JDBC.assertFullResultSet(rs, expectedStrArray2, true);
        checkps.close();
        stmt.close();
    }

    public void testStatementWithResultSetBatch() throws SQLException {
        Statement stmt = this.createStatement();
        BatchUpdateTest.println("Negative Statement: statement testing select as first statement in the batch");
        stmt.addBatch("SELECT * FROM SYS.SYSCOLUMNS");
        stmt.addBatch("insert into t1 values(1)");
        if (BatchUpdateTest.usingEmbedded()) {
            this.assertBatchExecuteError("X0Y79", stmt, new int[0]);
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            this.assertBatchExecuteError("XJ208", stmt, new int[]{-3, 1});
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 0 : 1);
        BatchUpdateTest.println("Negative Statement: statement testing select as nth stat in the batch");
        stmt.addBatch("insert into t1 values(1)");
        stmt.addBatch("SELECT * FROM SYS.SYSCOLUMNS");
        stmt.addBatch("insert into t1 values(1)");
        if (BatchUpdateTest.usingEmbedded()) {
            this.assertBatchExecuteError("X0Y79", stmt, new int[]{1});
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            this.assertBatchExecuteError("XJ208", stmt, new int[]{1, -3, 1});
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 1 : 3);
        BatchUpdateTest.println("Negative Statement: statement testing select as last stat in the batch");
        stmt.addBatch("insert into t1 values(1)");
        stmt.addBatch("insert into t1 values(1)");
        stmt.addBatch("SELECT * FROM SYS.SYSCOLUMNS");
        if (BatchUpdateTest.usingEmbedded()) {
            this.assertBatchExecuteError("X0Y79", stmt, new int[]{1, 1});
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            this.assertBatchExecuteError("XJ208", stmt, new int[]{1, 1, -3});
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 3 : 5);
        this.rollback();
        this.assertTableRowCount("T1", 0);
        stmt.close();
        this.commit();
    }

    public void testStatementNonBatchStuffInBatch() throws SQLException {
        Statement stmt = this.createStatement();
        int[] updateCount = null;
        BatchUpdateTest.println("Negative Statement: statement testing execute in the middle of batch");
        stmt.addBatch("SELECT * FROM SYS.SYSCOLUMNS");
        if (BatchUpdateTest.usingEmbedded()) {
            BatchUpdateTest.assertStatementError("XJ068", stmt, "insert into t1 values(1)");
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            stmt.addBatch("insert into t1 values(1)");
            this.assertBatchExecuteError("XJ208", stmt, new int[]{-3, 1});
            this.rollback();
        }
        stmt.clearBatch();
        this.assertTableRowCount("T1", 0);
        BatchUpdateTest.println("Negative Statement: statement testing executeQuery in the middle of batch");
        stmt.addBatch("insert into t1 values(1)");
        if (BatchUpdateTest.usingEmbedded()) {
            try {
                stmt.executeQuery("SELECT * FROM SYS.SYSTABLES");
                BatchUpdateTest.fail((String)"Expected executeQuerywith embedded");
            }
            catch (SQLException sqle) {
                BatchUpdateTest.assertSQLState("XJ068", sqle);
                stmt.clearBatch();
            }
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            stmt.executeQuery("SELECT * FROM SYS.SYSTABLES");
            updateCount = stmt.executeBatch();
            this.assertBatchUpdateCounts(new int[]{1}, updateCount);
            this.rollback();
        }
        this.assertTableRowCount("T1", 0);
        BatchUpdateTest.println("Negative Statement: statement testing executeUpdate in the middle of batch");
        BatchUpdateTest.println("Negative Statement: statement testing executeUpdate in the middle of batch");
        stmt.addBatch("insert into t1 values(1)");
        try {
            stmt.executeUpdate("insert into t1 values(1)");
            stmt.addBatch("insert into t1 values(1)");
            stmt.addBatch("SELECT * FROM SYS.SYSCOLUMNS");
            if (BatchUpdateTest.usingDerbyNetClient()) {
                this.assertBatchExecuteError("XJ208", stmt, new int[]{1, 1, -3});
            } else if (BatchUpdateTest.usingEmbedded()) {
                updateCount = stmt.executeBatch();
                BatchUpdateTest.fail((String)"Expected executeBatch to fail");
            }
        }
        catch (SQLException sqle) {
            if (BatchUpdateTest.usingEmbedded()) {
                BatchUpdateTest.assertSQLState("XJ068", sqle);
            } else if (BatchUpdateTest.usingDerbyNetClient()) {
                BatchUpdateTest.assertSQLState("XJ208", sqle);
            }
            stmt.clearBatch();
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 0 : 3);
        this.rollback();
        this.assertTableRowCount("T1", 0);
        stmt.close();
        this.commit();
    }

    public void testStatementWithErrorsBatch() throws SQLException {
        Statement stmt = this.createStatement();
        stmt.executeUpdate("insert into t1 values(1)");
        BatchUpdateTest.println("Negative Statement: statement testing overflow error as first statement in the batch");
        stmt.addBatch("update t1 set c1=2147483647 + 1");
        stmt.addBatch("insert into t1 values(1)");
        if (BatchUpdateTest.usingEmbedded()) {
            this.assertBatchExecuteError("22003", stmt, new int[0]);
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            this.assertBatchExecuteError("XJ208", stmt, new int[]{-3, 1});
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 1 : 2);
        BatchUpdateTest.println("Negative Statement: statement testing overflow error as nth statement in the batch");
        stmt.addBatch("insert into t1 values(1)");
        stmt.addBatch("update t1 set c1=2147483647 + 1");
        stmt.addBatch("insert into t1 values(1)");
        if (BatchUpdateTest.usingEmbedded()) {
            this.assertBatchExecuteError("22003", stmt, new int[]{1});
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            this.assertBatchExecuteError("XJ208", stmt, new int[]{1, -3, 1});
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 2 : 4);
        BatchUpdateTest.println("Negative Statement: statement testing overflow error as last stat in the batch");
        stmt.addBatch("insert into t1 values(1)");
        stmt.addBatch("insert into t1 values(1)");
        stmt.addBatch("update t1 set c1=2147483647 + 1");
        if (BatchUpdateTest.usingEmbedded()) {
            this.assertBatchExecuteError("22003", stmt, new int[]{1, 1});
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            this.assertBatchExecuteError("XJ208", stmt, new int[]{1, 1, -3});
        }
        this.assertTableRowCount("T1", BatchUpdateTest.usingEmbedded() ? 4 : 6);
        stmt.close();
        this.commit();
    }

    public void testTransactionErrorBatch() throws SQLException {
        Statement stmt2;
        Statement stmt;
        Connection conn2;
        Connection conn;
        block6: {
            conn = this.getConnection();
            conn2 = this.openDefaultConnection();
            conn.setAutoCommit(false);
            conn2.setAutoCommit(false);
            stmt = conn.createStatement();
            stmt2 = conn2.createStatement();
            int[] updateCount = null;
            BatchUpdateTest.println("Negative Statement: statement testing time out while getting the lock in the batch");
            stmt.execute("insert into t1 values(1)");
            stmt2.execute("insert into t1 values(2)");
            stmt.addBatch("update t1 set c1=3 where c1=2");
            stmt2.addBatch("update t1 set c1=4 where c1=1");
            try {
                stmt.executeBatch();
                BatchUpdateTest.fail((String)"Batch is expected to fail");
                updateCount = stmt2.executeBatch();
            }
            catch (BatchUpdateException bue) {
                if (BatchUpdateTest.usingEmbedded()) {
                    BatchUpdateTest.assertSQLState("40XL1", bue);
                } else if (BatchUpdateTest.usingDerbyNetClient()) {
                    BatchUpdateTest.assertSQLState("XJ208", bue);
                }
                updateCount = bue.getUpdateCounts();
                if (updateCount == null) break block6;
                if (BatchUpdateTest.usingEmbedded()) {
                    BatchUpdateTest.assertEquals((String)"first statement in the batch caused time out while getting the lock, there should be no update count", (int)0, (int)updateCount.length);
                }
                if (!BatchUpdateTest.usingDerbyNetClient()) break block6;
                this.assertBatchUpdateCounts(new int[]{-3}, updateCount);
            }
        }
        conn.rollback();
        conn2.rollback();
        stmt.clearBatch();
        stmt2.clearBatch();
        stmt.close();
        stmt2.close();
        this.commit();
        conn2.close();
    }

    public void testCallableStatementBatch() throws SQLException {
        BatchUpdateTest.println("Positive Callable Statement: statement testing callable statement batch");
        CallableStatement cs = this.prepareCall("insert into t1 values(?)");
        cs.setInt(1, 1);
        cs.addBatch();
        cs.setInt(1, 2);
        cs.addBatch();
        BatchUpdateTest.executeBatchCallableStatement(cs);
        this.cleanUpCallableStatement(cs, "t1");
        cs = this.prepareCall("insert into datetab values(?)");
        cs.setDate(1, Date.valueOf("1990-05-05"));
        cs.addBatch();
        cs.setDate(1, Date.valueOf("1990-06-06"));
        cs.addBatch();
        BatchUpdateTest.executeBatchCallableStatement(cs);
        this.cleanUpCallableStatement(cs, "datetab");
        cs = this.prepareCall("insert into timetab values(?)");
        cs.setTime(1, Time.valueOf("11:11:11"));
        cs.addBatch();
        cs.setTime(1, Time.valueOf("12:12:12"));
        cs.addBatch();
        BatchUpdateTest.executeBatchCallableStatement(cs);
        this.cleanUpCallableStatement(cs, "timestamptab");
        cs = this.prepareCall("insert into timestamptab values(?)");
        cs.setTimestamp(1, Timestamp.valueOf("1990-05-05 11:11:11.1"));
        cs.addBatch();
        cs.setTimestamp(1, Timestamp.valueOf("1992-07-07 12:12:12.2"));
        cs.addBatch();
        BatchUpdateTest.executeBatchCallableStatement(cs);
        this.cleanUpCallableStatement(cs, "timestamptab");
        cs = this.prepareCall("insert into usertypetab values(?)");
        cs.setObject(1, (Object)Date.valueOf("1990-05-05"));
        cs.addBatch();
        cs.setObject(1, (Object)Date.valueOf("1990-06-06"));
        cs.addBatch();
        BatchUpdateTest.executeBatchCallableStatement(cs);
        this.cleanUpCallableStatement(cs, "usertypetab");
    }

    private static void executeBatchCallableStatement(CallableStatement cs) throws SQLException {
        int[] updateCount = cs.executeBatch();
        BatchUpdateTest.assertEquals((String)"there were 2 statements in the batch", (int)2, (int)updateCount.length);
        for (int i = 0; i < updateCount.length; ++i) {
            BatchUpdateTest.assertEquals((String)"update count should be 1", (int)1, (int)updateCount[i]);
        }
    }

    protected void cleanUpCallableStatement(CallableStatement cs, String tableName) throws SQLException {
        cs.close();
        this.rollback();
        cs = this.prepareCall("delete from " + tableName);
        cs.executeUpdate();
        cs.close();
        this.commit();
    }

    public void testCallableStatementWithOutputParamBatch() throws SQLException {
        BatchUpdateTest.println("Negative Callable Statement: callable statement with output parameters in the batch");
        Statement s = this.createStatement();
        s.execute("CREATE PROCEDURE takesString(OUT P1 VARCHAR(40), IN P2 INT) EXTERNAL NAME '" + ((Object)((Object)this)).getClass().getName() + ".takesString'" + " NO SQL LANGUAGE JAVA PARAMETER STYLE JAVA");
        CallableStatement cs = this.prepareCall("call takesString(?,?)");
        cs.registerOutParameter(1, 1);
        cs.setInt(2, 4);
        try {
            cs.addBatch();
            if (BatchUpdateTest.usingEmbedded()) {
                BatchUpdateTest.fail((String)"Expected to see error XJ04C");
            } else if (BatchUpdateTest.usingDerbyNetClient()) {
                BatchUpdateTest.executeBatchCallableStatement(cs);
            }
        }
        catch (SQLException sqle) {
            BatchUpdateTest.assertSQLState("XJ04C", sqle);
        }
        cs.close();
        s.execute("drop procedure takesString");
        s.close();
        this.rollback();
    }

    public static void takesString(String[] outparam, int type) throws Throwable {
        outparam[0] = "3";
    }

    public void testEmptyValueSetPreparedBatch() throws SQLException {
        BatchUpdateTest.println("Positive Prepared Stat: set no parameter values and run the batch");
        PreparedStatement pStmt = this.prepareStatement("insert into t1 values(?)");
        this.assertBatchUpdateCounts(new int[0], pStmt.executeBatch());
        pStmt.close();
        this.commit();
    }

    public void testNoParametersPreparedBatch() throws SQLException {
        Statement stmt = this.createStatement();
        BatchUpdateTest.println("Positive Prepared Stat: no settable parameters");
        PreparedStatement pStmt = this.prepareStatement("insert into t1 values(5)");
        pStmt.addBatch();
        pStmt.addBatch();
        pStmt.addBatch();
        this.assertBatchUpdateCounts(new int[]{1, 1, 1}, pStmt.executeBatch());
        pStmt.close();
        ResultSet rs = stmt.executeQuery("select count(*) from t1 where c1=5");
        rs.next();
        BatchUpdateTest.assertEquals((String)"There should be 3 rows with c1 = 5", (int)3, (int)rs.getInt(1));
        rs.close();
        this.assertTableRowCount("T1", 3);
        stmt.close();
        this.commit();
    }

    public void testSingleValueSetPreparedBatch() throws SQLException {
        Statement stmt = this.createStatement();
        BatchUpdateTest.println("Positive Prepared Stat: set one set of parameter values and run the batch");
        PreparedStatement pStmt = this.prepareStatement("insert into t1 values(?)");
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        this.assertBatchUpdateCounts(new int[]{1}, pStmt.executeBatch());
        pStmt.close();
        ResultSet rs = stmt.executeQuery("select count(*) from t1 where c1=1");
        rs.next();
        BatchUpdateTest.assertEquals((String)"There should be 1 row with c1=1", (int)1, (int)rs.getInt(1));
        rs.close();
        this.assertTableRowCount("T1", 1);
        stmt.close();
        this.commit();
    }

    public void testMultipleValueSetPreparedBatch() throws SQLException {
        BatchUpdateTest.println("Positive Prepared Stat: set 3 set of parameter values and run the batch");
        PreparedStatement pStmt = this.prepareStatement("insert into t1 values(?)");
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 2);
        pStmt.addBatch();
        pStmt.setInt(1, 3);
        pStmt.addBatch();
        this.assertBatchUpdateCounts(new int[]{1, 1, 1}, pStmt.executeBatch());
        pStmt.close();
        this.assertTableRowCount("T1", 3);
        this.commit();
    }

    public void testMultipleValueSetNullPreparedBatch() throws SQLException {
        Statement stmt = this.createStatement();
        BatchUpdateTest.println("Positive Prepared Stat: set one set of parameter values to null and run the batch");
        PreparedStatement pStmt = this.prepareStatement("insert into t1 values(?)");
        pStmt.setNull(1, 4);
        pStmt.addBatch();
        pStmt.setNull(1, 4);
        pStmt.addBatch();
        this.assertBatchUpdateCounts(new int[]{1, 1}, pStmt.executeBatch());
        pStmt.close();
        ResultSet rs = stmt.executeQuery("select count(*) from t1 where c1 is null");
        rs.next();
        BatchUpdateTest.assertEquals((String)"There should be 2 rows with c1 is null", (int)2, (int)rs.getInt(1));
        rs.close();
        this.assertTableRowCount("T1", 2);
        stmt.close();
        this.commit();
    }

    public void test1000ValueSetPreparedBatch() throws SQLException {
        BatchUpdateTest.println("Positive Prepared Stat: 1000 parameter set batch");
        PreparedStatement pStmt = this.prepareStatement("insert into t1 values(?)");
        for (int i = 0; i < 1000; ++i) {
            pStmt.setInt(1, 1);
            pStmt.addBatch();
        }
        int[] updateCount = pStmt.executeBatch();
        int[] expectedUpdateCount = new int[1000];
        Arrays.fill(expectedUpdateCount, 1);
        this.assertBatchUpdateCounts(expectedUpdateCount, updateCount);
        this.assertTableRowCount("T1", 1000);
        pStmt.close();
        this.commit();
    }

    public void testPreparedStatRollbackAndCommitCombinations() throws SQLException {
        BatchUpdateTest.println("Positive Prepared Stat: batch, rollback, batch and commit combinations");
        PreparedStatement pStmt = this.prepareStatement("insert into t1 values(?)");
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        this.assertBatchUpdateCounts(new int[]{1, 1}, pStmt.executeBatch());
        this.rollback();
        this.assertTableRowCount("T1", 0);
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        this.assertBatchUpdateCounts(new int[]{1, 1}, pStmt.executeBatch());
        this.commit();
        this.assertTableRowCount("T1", 2);
        BatchUpdateTest.println("Positive Prepared Stat: batch and commit combinations");
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        this.assertBatchUpdateCounts(new int[]{1, 1}, pStmt.executeBatch());
        this.commit();
        this.assertTableRowCount("T1", 4);
        BatchUpdateTest.println("Positive Prepared Stat: batch, batch and rollback combinations");
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        this.assertBatchUpdateCounts(new int[]{1, 1}, pStmt.executeBatch());
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        this.assertBatchUpdateCounts(new int[]{1, 1}, pStmt.executeBatch());
        this.rollback();
        this.assertTableRowCount("T1", 4);
        BatchUpdateTest.println("Positive Prepared Stat: batch, batch and commit combinations");
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        this.assertBatchUpdateCounts(new int[]{1, 1}, pStmt.executeBatch());
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        this.assertBatchUpdateCounts(new int[]{1, 1}, pStmt.executeBatch());
        this.commit();
        this.assertTableRowCount("T1", 8);
        pStmt.close();
        this.commit();
    }

    public void testAutoCommitTruePreparedStatBatch() throws SQLException {
        this.getConnection().setAutoCommit(true);
        BatchUpdateTest.println("Positive Prepared Stat: testing batch with autocommit true");
        PreparedStatement pStmt = this.prepareStatement("insert into t1 values(?)");
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        this.assertBatchUpdateCounts(new int[]{1, 1, 1}, pStmt.executeBatch());
        this.assertTableRowCount("T1", 3);
        pStmt.close();
    }

    public void testCombinationsOfClearPreparedStatBatch() throws SQLException {
        BatchUpdateTest.println("Positive Prepared Stat: add 3 statements, clear batch and execute batch");
        PreparedStatement pStmt = this.prepareStatement("insert into t1 values(?)");
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 2);
        pStmt.addBatch();
        pStmt.setInt(1, 3);
        pStmt.addBatch();
        pStmt.clearBatch();
        this.assertBatchUpdateCounts(new int[0], pStmt.executeBatch());
        BatchUpdateTest.println("Positive Prepared Stat: add 3 statements, clear batch, add 3 and execute batch");
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 2);
        pStmt.addBatch();
        pStmt.setInt(1, 3);
        pStmt.addBatch();
        pStmt.clearBatch();
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 2);
        pStmt.addBatch();
        pStmt.setInt(1, 3);
        pStmt.addBatch();
        this.assertBatchUpdateCounts(new int[]{1, 1, 1}, pStmt.executeBatch());
        this.assertTableRowCount("T1", 3);
        pStmt.close();
        this.commit();
    }

    public void testPreparedStmtWithResultSetBatch() throws SQLException {
        BatchUpdateTest.println("Negative Prepared Stat: testing select in the batch");
        PreparedStatement pStmt = this.prepareStatement("select * from t1 where c1=?");
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        if (BatchUpdateTest.usingEmbedded()) {
            this.assertBatchExecuteError("X0Y79", pStmt, new int[0]);
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            this.assertBatchExecuteError("XJ117", pStmt, new int[]{-3});
        }
        pStmt.close();
        this.assertTableRowCount("T1", 0);
        this.commit();
    }

    public void testPreparedStmtNonBatchStuffInBatch() throws SQLException {
        PreparedStatement pStmt;
        block20: {
            int[] updateCount;
            block19: {
                block18: {
                    updateCount = null;
                    BatchUpdateTest.println("Negative Prepared Stat: testing execute in the middle of batch");
                    pStmt = this.prepareStatement("select * from t1 where c1=?");
                    pStmt.setInt(1, 1);
                    pStmt.addBatch();
                    try {
                        pStmt.execute();
                        if (BatchUpdateTest.usingEmbedded()) {
                            BatchUpdateTest.fail((String)"Expected executeBatch to fail");
                        } else if (BatchUpdateTest.usingDerbyNetClient()) {
                            updateCount = pStmt.executeBatch();
                        }
                    }
                    catch (SQLException sqle) {
                        if (BatchUpdateTest.usingEmbedded()) {
                            BatchUpdateTest.assertSQLState("XJ068", sqle);
                        }
                        if (!BatchUpdateTest.usingDerbyNetClient()) break block18;
                        BatchUpdateTest.assertSQLState("XJ117", sqle);
                    }
                }
                pStmt.close();
                this.assertTableRowCount("T1", 0);
                BatchUpdateTest.println("Negative Prepared Statement: testing executeQuery in the middle of batch");
                pStmt = this.prepareStatement("select * from t1 where c1=?");
                pStmt.setInt(1, 1);
                pStmt.addBatch();
                try {
                    pStmt.executeQuery();
                    if (BatchUpdateTest.usingEmbedded()) {
                        BatchUpdateTest.fail((String)"Expected executeBatch to fail");
                    } else if (BatchUpdateTest.usingDerbyNetClient()) {
                        updateCount = pStmt.executeBatch();
                    }
                }
                catch (SQLException sqle) {
                    if (BatchUpdateTest.usingEmbedded()) {
                        BatchUpdateTest.assertSQLState("XJ068", sqle);
                    }
                    if (!BatchUpdateTest.usingDerbyNetClient()) break block19;
                    BatchUpdateTest.assertSQLState("XJ117", sqle);
                }
            }
            pStmt.close();
            this.assertTableRowCount("T1", 0);
            BatchUpdateTest.println("Negative Prepared Stat: testing executeUpdate in the middle of batch");
            pStmt = this.prepareStatement("select * from t1 where c1=?");
            pStmt.setInt(1, 1);
            pStmt.addBatch();
            try {
                pStmt.executeUpdate();
                if (BatchUpdateTest.usingEmbedded()) {
                    BatchUpdateTest.fail((String)"Expected executeBatch to fail");
                } else if (BatchUpdateTest.usingDerbyNetClient()) {
                    updateCount = pStmt.executeBatch();
                }
            }
            catch (SQLException sqle) {
                if (BatchUpdateTest.usingEmbedded()) {
                    BatchUpdateTest.assertSQLState("XJ068", sqle);
                }
                if (!BatchUpdateTest.usingDerbyNetClient()) break block20;
                BatchUpdateTest.assertSQLState("X0Y79", sqle);
            }
        }
        pStmt.close();
        this.assertTableRowCount("T1", 0);
        this.commit();
    }

    public void testPreparedStmtWithErrorsBatch() throws SQLException {
        Statement stmt = this.createStatement();
        PreparedStatement pStmt = null;
        stmt.executeUpdate("insert into t1 values(1)");
        BatchUpdateTest.println("Negative Prepared Stat: testing overflow as first set of values");
        pStmt = this.prepareStatement("update t1 set c1=(? + 1)");
        pStmt.setInt(1, Integer.MAX_VALUE);
        pStmt.addBatch();
        if (BatchUpdateTest.usingEmbedded()) {
            this.assertBatchExecuteError("22003", pStmt, new int[0]);
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            this.assertBatchExecuteError("XJ208", pStmt, new int[]{-3});
        }
        pStmt.close();
        this.assertTableRowCount("T1", 1);
        BatchUpdateTest.println("Negative Prepared Stat: testing overflow as nth set of values");
        pStmt = this.prepareStatement("update t1 set c1=(? + 1)");
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, Integer.MAX_VALUE);
        pStmt.addBatch();
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        if (BatchUpdateTest.usingEmbedded()) {
            this.assertBatchExecuteError("22003", pStmt, new int[]{1});
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            this.assertBatchExecuteError("XJ208", pStmt, new int[]{1, -3, 1});
        }
        pStmt.close();
        this.assertTableRowCount("T1", 1);
        BatchUpdateTest.println("Negative Prepared Stat: testing overflow as last set of values");
        pStmt = this.prepareStatement("update t1 set c1=(? + 1)");
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, 1);
        pStmt.addBatch();
        pStmt.setInt(1, Integer.MAX_VALUE);
        pStmt.addBatch();
        if (BatchUpdateTest.usingEmbedded()) {
            this.assertBatchExecuteError("22003", pStmt, new int[]{1, 1});
        } else if (BatchUpdateTest.usingDerbyNetClient()) {
            this.assertBatchExecuteError("XJ208", pStmt, new int[]{1, 1, -3});
        }
        this.assertTableRowCount("T1", 1);
        pStmt.close();
        stmt.close();
        this.commit();
    }

    public void testTransactionErrorPreparedStmtBatch() throws SQLException {
        PreparedStatement pStmt2;
        PreparedStatement pStmt1;
        Statement stmt2;
        Statement stmt;
        Connection conn2;
        block6: {
            Connection conn = this.getConnection();
            conn2 = this.openDefaultConnection();
            conn.setAutoCommit(false);
            conn2.setAutoCommit(false);
            stmt = this.createStatement();
            stmt2 = conn2.createStatement();
            int[] updateCount = null;
            BatchUpdateTest.println("Negative Prepared Statement: testing transaction error, time out while getting the lock");
            stmt.execute("insert into t1 values(1)");
            stmt2.execute("insert into t1 values(2)");
            pStmt1 = this.prepareStatement("update t1 set c1=3 where c1=?");
            pStmt1.setInt(1, 2);
            pStmt1.addBatch();
            pStmt2 = conn.prepareStatement("update t1 set c1=4 where c1=?");
            pStmt2.setInt(1, 1);
            pStmt2.addBatch();
            try {
                pStmt1.executeBatch();
                updateCount = pStmt2.executeBatch();
                BatchUpdateTest.fail((String)"Batch is expected to fail");
            }
            catch (BatchUpdateException bue) {
                if (BatchUpdateTest.usingEmbedded()) {
                    BatchUpdateTest.assertSQLState("40XL1", bue);
                } else if (BatchUpdateTest.usingDerbyNetClient()) {
                    BatchUpdateTest.assertSQLState("XJ208", bue);
                }
                updateCount = bue.getUpdateCounts();
                if (updateCount == null) break block6;
                if (BatchUpdateTest.usingEmbedded()) {
                    BatchUpdateTest.assertEquals((String)"first statement in the batch caused time out while getting the lock, there should be no update count", (int)0, (int)updateCount.length);
                }
                if (!BatchUpdateTest.usingDerbyNetClient()) break block6;
                this.assertBatchUpdateCounts(new int[]{-3}, updateCount);
            }
        }
        pStmt1.close();
        pStmt2.close();
        stmt.close();
        stmt2.close();
        this.rollback();
        conn2.rollback();
        conn2.close();
    }

    public void testUnderlyingExceptionIsVisible() throws SQLException {
        this.setAutoCommit(false);
        Statement s = this.createStatement();
        s.addBatch("create table t(x int unique not null)");
        for (int i = 0; i < 3; ++i) {
            s.addBatch("insert into t values 1");
        }
        BatchUpdateException bue = null;
        try {
            s.executeBatch();
        }
        catch (BatchUpdateException e) {
            bue = e;
        }
        BatchUpdateTest.assertNotNull((String)"Did not get duplicate key exception", (Object)bue);
        StringWriter w = new StringWriter();
        bue.printStackTrace(new PrintWriter((Writer)w, true));
        String stackTrace = w.toString();
        if (stackTrace.indexOf("duplicate key") == -1) {
            BatchUpdateTest.fail("Could not see 'duplicate key' in printStackTrace()", bue);
        }
    }
}

