/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.jdbc4;

import java.io.UnsupportedEncodingException;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Assert;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestSetup;

public class CallableStatementTestSetup
extends BaseJDBCTestSetup {
    private static final String SOURCECLASS = "org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTestSetup.";
    private static final String[] TABLE_DROPS = new String[]{"CSDATA"};
    private static final String[] FUNCTION_DROPS = new String[]{"INT_TO_STRING", "GET_BINARY_DB", "GET_VARCHAR_DB"};
    private static final String[] PROCEDURE_DROPS = new String[]{"GET_BINARY_DIRECT"};
    public static final int STRING_BYTES_ID = 1;
    public static final String STRING_BYTES = "This is a string, converted to bytes and inserted into the database";
    public static final int SQL_NULL_ID = 2;

    public CallableStatementTestSetup(Test test) {
        super(test);
    }

    protected void setUp() throws SQLException {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        stmt.execute("CREATE TABLE CSDATA (ID INT PRIMARY KEY,BINARYDATA VARCHAR(256) FOR BIT DATA, CHARDATA VARCHAR(256))");
        PreparedStatement pStmt = con.prepareStatement("INSERT INTO CSDATA VALUES (?,?,?)");
        pStmt.setInt(1, 1);
        try {
            pStmt.setBytes(2, STRING_BYTES.getBytes("UTF-16BE"));
        }
        catch (UnsupportedEncodingException uee) {
            SQLException sqle = new SQLException(uee.getMessage());
            sqle.initCause(uee);
            throw sqle;
        }
        pStmt.setString(3, STRING_BYTES);
        pStmt.execute();
        pStmt.setInt(1, 2);
        pStmt.setNull(2, -3);
        pStmt.setNull(3, 12);
        pStmt.execute();
        pStmt.close();
        stmt.execute("CREATE FUNCTION INT_TO_STRING(INTNUM INT) RETURNS VARCHAR(10) PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'java.lang.Integer.toString'");
        stmt.execute("CREATE PROCEDURE GET_BINARY_DIRECT(IN INSTRING VARCHAR(40), OUT OUTBYTES VARCHAR(160) FOR BIT DATA) DYNAMIC RESULT SETS 0 PARAMETER STYLE JAVA NO SQL LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTestSetup.getBinaryDirect'");
        stmt.execute("CREATE FUNCTION GET_BINARY_DB(ID INT) RETURNS VARCHAR(256) FOR BIT DATA PARAMETER STYLE JAVA READS SQL DATA LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTestSetup.getBinaryFromDb'");
        stmt.execute("CREATE FUNCTION GET_VARCHAR_DB(ID INT) RETURNS VARCHAR(256) PARAMETER STYLE JAVA READS SQL DATA LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.jdbc4.CallableStatementTestSetup.getVarcharFromDb'");
        stmt.close();
    }

    protected void tearDown() throws Exception {
        Connection con = this.getConnection();
        Statement stmt = con.createStatement();
        for (String function : FUNCTION_DROPS) {
            stmt.execute("DROP FUNCTION " + function);
        }
        for (String procedure : PROCEDURE_DROPS) {
            stmt.execute("DROP PROCEDURE " + procedure);
        }
        for (String table : TABLE_DROPS) {
            stmt.execute("DROP TABLE " + table);
        }
        stmt.close();
        super.tearDown();
    }

    public static CallableStatement getIntToStringFunction(Connection con) throws SQLException {
        Assert.assertNotNull((String)"Connection cannot be null", (Object)con);
        CallableStatement cStmt = con.prepareCall("?= CALL INT_TO_STRING(?)");
        cStmt.registerOutParameter(1, 12);
        return cStmt;
    }

    public static CallableStatement getBinaryDirectProcedure(Connection con) throws SQLException {
        Assert.assertNotNull((String)"Connection cannot be null", (Object)con);
        CallableStatement cStmt = con.prepareCall("CALL GET_BINARY_DIRECT(?,?)");
        cStmt.registerOutParameter(2, -3);
        return cStmt;
    }

    public static CallableStatement getBinaryFromDbFunction(Connection con) throws SQLException {
        Assert.assertNotNull((String)"Connection cannot be null", (Object)con);
        CallableStatement cStmt = con.prepareCall("?= CALL GET_BINARY_DB(?)");
        cStmt.registerOutParameter(1, -3);
        return cStmt;
    }

    public static CallableStatement getVarcharFromDbFunction(Connection con) throws SQLException {
        Assert.assertNotNull((String)"Connection cannot be null", (Object)con);
        CallableStatement cStmt = con.prepareCall("?= CALL GET_VARCHAR_DB(?)");
        cStmt.registerOutParameter(1, 12);
        return cStmt;
    }

    public static void getBinaryDirect(String inputString, byte[][] outputByte) {
        try {
            outputByte[0] = inputString.getBytes("UTF-16BE");
        }
        catch (UnsupportedEncodingException uee) {
            outputByte[0] = new byte[0];
        }
    }

    public static byte[] getBinaryFromDb(int id) throws Exception {
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT BINARYDATA FROM CSDATA WHERE ID = " + id);
        rs.next();
        byte[] bytes = rs.getBytes(1);
        rs.close();
        stmt.close();
        con.close();
        return bytes;
    }

    public static String getVarcharFromDb(int id) throws Exception {
        Connection con = DriverManager.getConnection("jdbc:default:connection");
        Statement stmt = con.createStatement();
        ResultSet rs = stmt.executeQuery("SELECT CHARDATA FROM CSDATA WHERE ID = " + id);
        rs.next();
        String chardata = rs.getString(1);
        rs.close();
        stmt.close();
        con.close();
        return chardata;
    }
}

