/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.io.File;
import java.util.Enumeration;
import java.util.Properties;
import junit.framework.Test;
import junit.framework.TestSuite;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.NetworkServerTestSetup;
import org.apache.derbyTesting.junit.SecurityManagerSetup;
import org.apache.derbyTesting.junit.SupportFilesSetup;
import org.apache.derbyTesting.junit.TestConfiguration;

public class GetCurrentPropertiesTest
extends BaseJDBCTestCase {
    private static String POLICY_FILE_NAME = "functionTests/tests/derbynet/GetCurrentPropertiesTest.policy";
    private static String TARGET_POLICY_FILE_NAME = "server.policy";

    public GetCurrentPropertiesTest(String name) {
        super(name);
    }

    protected void tearDown() throws Exception {
        super.tearDown();
    }

    public static Test suite() {
        TestSuite suite = new TestSuite("GetCurrentPropertiesTest");
        Test test = TestConfiguration.clientServerSuite(GetCurrentPropertiesTest.class);
        test = GetCurrentPropertiesTest.decorateWithPolicy(test);
        suite.addTest(test);
        return TestConfiguration.singleUseDatabaseDecorator((Test)suite);
    }

    private static String makeServerPolicyName() {
        try {
            String userDir = GetCurrentPropertiesTest.getSystemProperty("user.dir");
            String fileName = userDir + File.separator + "extinout" + File.separator + TARGET_POLICY_FILE_NAME;
            File file = new File(fileName);
            String urlString = file.toURL().toExternalForm();
            return urlString;
        }
        catch (Exception e) {
            GetCurrentPropertiesTest.fail("Exception in REading Server policy file", e);
            return null;
        }
    }

    private static Test decorateWithPolicy(Test test) {
        String serverPolicyName = GetCurrentPropertiesTest.makeServerPolicyName();
        test = new SecurityManagerSetup((Test)test, serverPolicyName);
        test = new SupportFilesSetup((Test)test, null, new String[]{POLICY_FILE_NAME}, null, new String[]{TARGET_POLICY_FILE_NAME});
        return test;
    }

    public void testPropertiesBeforeConnection() throws Exception {
        Properties p = null;
        String userDir = GetCurrentPropertiesTest.getSystemProperty("user.dir");
        String traceDir = userDir + File.separator + "system";
        Properties expectedValues = new Properties();
        expectedValues.setProperty("derby.drda.traceDirectory", traceDir);
        expectedValues.setProperty("derby.drda.maxThreads", "0");
        expectedValues.setProperty("derby.drda.sslMode", "off");
        expectedValues.setProperty("derby.drda.keepAlive", "true");
        expectedValues.setProperty("derby.drda.minThreads", "0");
        expectedValues.setProperty("derby.drda.portNumber", "1527");
        expectedValues.setProperty("derby.drda.logConnections", "false");
        expectedValues.setProperty("derby.drda.timeSlice", "0");
        expectedValues.setProperty("derby.drda.startNetworkServer", "false");
        expectedValues.setProperty("derby.drda.host", "127.0.0.1");
        expectedValues.setProperty("derby.drda.traceAll", "false");
        p = NetworkServerTestSetup.getNetworkServerControl().getCurrentProperties();
        Enumeration<?> expectedProps = expectedValues.propertyNames();
        expectedProps = expectedValues.propertyNames();
        while (expectedProps.hasMoreElements()) {
            String propName = (String)expectedProps.nextElement();
            String propVal = (String)p.get(propName);
            GetCurrentPropertiesTest.println(expectedValues.getProperty(propName));
            GetCurrentPropertiesTest.println(propVal);
            GetCurrentPropertiesTest.assertEquals((String)expectedValues.getProperty(propName), (String)propVal);
        }
    }

    public void testPropertiesAfterConnection() throws Exception {
        Properties p = null;
        String userDir = GetCurrentPropertiesTest.getSystemProperty("user.dir");
        String traceDir = userDir + File.separator + "system";
        Properties expectedValues = new Properties();
        expectedValues.setProperty("derby.drda.traceDirectory", traceDir);
        expectedValues.setProperty("derby.drda.maxThreads", "0");
        expectedValues.setProperty("derby.drda.sslMode", "off");
        expectedValues.setProperty("derby.drda.trace.4", "true");
        expectedValues.setProperty("derby.drda.keepAlive", "true");
        expectedValues.setProperty("derby.drda.minThreads", "0");
        expectedValues.setProperty("derby.drda.portNumber", "1527");
        expectedValues.setProperty("derby.drda.logConnections", "true");
        expectedValues.setProperty("derby.drda.timeSlice", "0");
        expectedValues.setProperty("derby.drda.startNetworkServer", "false");
        expectedValues.setProperty("derby.drda.host", "127.0.0.1");
        expectedValues.setProperty("derby.drda.traceAll", "false");
        this.getConnection().setAutoCommit(false);
        NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl();
        nsctrl.trace(4, true);
        nsctrl.logConnections(true);
        p = NetworkServerTestSetup.getNetworkServerControl().getCurrentProperties();
        Enumeration<?> expectedProps = expectedValues.propertyNames();
        expectedProps = expectedValues.propertyNames();
        while (expectedProps.hasMoreElements()) {
            String propName = (String)expectedProps.nextElement();
            String propVal = (String)p.get(propName);
            GetCurrentPropertiesTest.println(expectedValues.getProperty(propName));
            GetCurrentPropertiesTest.println(propVal);
            GetCurrentPropertiesTest.assertEquals((String)expectedValues.getProperty(propName), (String)propVal);
        }
    }

    public void testPropertiesTraceOn() throws Exception {
        Properties p = null;
        NetworkServerControl nsctrl = NetworkServerTestSetup.getNetworkServerControl();
        nsctrl.trace(true);
        String derbySystemHome = GetCurrentPropertiesTest.getSystemProperty("derby.system.home");
        nsctrl.setTraceDirectory(derbySystemHome);
        Properties expectedValues = new Properties();
        expectedValues.setProperty("derby.drda.traceDirectory", derbySystemHome);
        expectedValues.setProperty("derby.drda.maxThreads", "0");
        expectedValues.setProperty("derby.drda.sslMode", "off");
        expectedValues.setProperty("derby.drda.keepAlive", "true");
        expectedValues.setProperty("derby.drda.minThreads", "0");
        expectedValues.setProperty("derby.drda.portNumber", "1527");
        expectedValues.setProperty("derby.drda.logConnections", "true");
        expectedValues.setProperty("derby.drda.timeSlice", "0");
        expectedValues.setProperty("derby.drda.startNetworkServer", "false");
        expectedValues.setProperty("derby.drda.host", "127.0.0.1");
        expectedValues.setProperty("derby.drda.traceAll", "true");
        p = NetworkServerTestSetup.getNetworkServerControl().getCurrentProperties();
        Enumeration<?> expectedProps = expectedValues.propertyNames();
        expectedProps = expectedValues.propertyNames();
        while (expectedProps.hasMoreElements()) {
            String propName = (String)expectedProps.nextElement();
            String propVal = (String)p.get(propName);
            GetCurrentPropertiesTest.println(expectedValues.getProperty(propName));
            GetCurrentPropertiesTest.println(propVal);
            GetCurrentPropertiesTest.assertEquals((String)expectedValues.getProperty(propName), (String)propVal);
        }
    }
}

