/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derbyTesting.functionTests.tests.derbynet;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import junit.framework.Test;
import org.apache.derbyTesting.junit.BaseJDBCTestCase;
import org.apache.derbyTesting.junit.TestConfiguration;

public class CheckSecurityManager
extends BaseJDBCTestCase {
    public static Test suite() {
        return TestConfiguration.defaultSuite(CheckSecurityManager.class);
    }

    public CheckSecurityManager(String name) {
        super(name);
    }

    public void testIllegalPropertySet() throws SQLException {
        Connection conn = this.getConnection();
        String createproc = "CREATE PROCEDURE setIllegalPropertyProc() DYNAMIC RESULT SETS 0 LANGUAGE JAVA EXTERNAL NAME 'org.apache.derbyTesting.functionTests.tests.derbynet.checkSecMgr.setIllegalPropertyProc' PARAMETER STYLE JAVA";
        PreparedStatement pstmt = conn.prepareStatement(createproc);
        pstmt.executeUpdate();
        CallableStatement cstmt = conn.prepareCall("{call setIllegalPropertyProc()}");
        try {
            cstmt.executeUpdate();
        }
        catch (SQLException e) {
            CheckSecurityManager.assertSQLState("38000", e);
        }
    }

    public static void setIllegalPropertyProc() {
        System.setProperty("notAllowed", "somevalue");
    }

    public void tearDown() throws SQLException {
        Statement stmt = this.createStatement();
        try {
            stmt.executeUpdate("drop procedure setIllegalPropertyProc");
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }
}

