/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.registry.configurator;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.registry.configurator.UIPropertyConfiguratorDescriptor;

public class UIPropertyConfiguratorRegistry {
    private static UIPropertyConfiguratorRegistry instance = null;
    private final Map<String, UIPropertyConfiguratorDescriptor> descriptors = new HashMap<String, UIPropertyConfiguratorDescriptor>();

    @NotNull
    public static synchronized UIPropertyConfiguratorRegistry getInstance() {
        if (instance == null) {
            instance = new UIPropertyConfiguratorRegistry(Platform.getExtensionRegistry());
        }
        return instance;
    }

    private UIPropertyConfiguratorRegistry(@NotNull IExtensionRegistry registry) {
        IConfigurationElement[] extElements;
        IConfigurationElement[] iConfigurationElementArray = extElements = registry.getConfigurationElementsFor("org.jkiss.dbeaver.ui.propertyConfigurator");
        int n = extElements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement ext = iConfigurationElementArray[n2];
            UIPropertyConfiguratorDescriptor descriptor = new UIPropertyConfiguratorDescriptor(ext);
            this.descriptors.put(descriptor.getObjectType(), descriptor);
            ++n2;
        }
    }

    @Nullable
    public UIPropertyConfiguratorDescriptor getDescriptor(@NotNull Object object) {
        Class<?> theClass = object.getClass();
        while (theClass != Object.class) {
            UIPropertyConfiguratorDescriptor descriptor = this.descriptors.get(theClass.getName());
            if (descriptor != null) {
                return descriptor;
            }
            theClass = theClass.getSuperclass();
        }
        return null;
    }

    @Nullable
    public UIPropertyConfiguratorDescriptor getDescriptor(@Nullable String className) {
        return this.descriptors.get(className);
    }
}

