/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.model.sql.semantics.model.expressions;

import org.antlr.v4.runtime.misc.Interval;
import org.jkiss.code.NotNull;
import org.jkiss.code.Nullable;
import org.jkiss.dbeaver.Log;
import org.jkiss.dbeaver.model.sql.semantics.SQLQueryRecognitionContext;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySemanticUtils;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbol;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolClass;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolEntry;
import org.jkiss.dbeaver.model.sql.semantics.SQLQuerySymbolOrigin;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryExprType;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsDataContext;
import org.jkiss.dbeaver.model.sql.semantics.context.SQLQueryRowsSourceContext;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryMemberAccessEntry;
import org.jkiss.dbeaver.model.sql.semantics.model.SQLQueryNodeModelVisitor;
import org.jkiss.dbeaver.model.sql.semantics.model.expressions.SQLQueryValueExpression;
import org.jkiss.dbeaver.model.stm.STMTreeNode;

public class SQLQueryValueMemberExpression
extends SQLQueryValueExpression {
    private static final Log log = Log.getLog(SQLQueryValueMemberExpression.class);
    @NotNull
    private final SQLQueryValueExpression owner;
    @Nullable
    private final SQLQuerySymbolEntry identifier;
    @Nullable
    private final SQLQueryMemberAccessEntry memberAccessEntry;

    public SQLQueryValueMemberExpression(@NotNull Interval range, @NotNull STMTreeNode syntaxNode, @NotNull SQLQueryValueExpression owner, @Nullable SQLQuerySymbolEntry identifier, @Nullable SQLQueryMemberAccessEntry memberAccessEntry) {
        super(range, syntaxNode, owner);
        this.owner = owner;
        this.identifier = identifier;
        this.memberAccessEntry = memberAccessEntry;
    }

    @Override
    @Nullable
    public SQLQuerySymbolClass getAssociatedSymbolClass() {
        return SQLQuerySemanticUtils.getIdentifierSymbolClass(this.identifier);
    }

    @NotNull
    public SQLQueryValueExpression getMemberOwner() {
        return this.owner;
    }

    @Nullable
    public SQLQuerySymbolEntry getMemberIdentifier() {
        return this.identifier;
    }

    @Override
    @Nullable
    public SQLQuerySymbol getColumnNameIfTrivialExpression() {
        return this.identifier == null ? null : this.identifier.getSymbol();
    }

    @Override
    protected void resolveRowSourcesImpl(@NotNull SQLQueryRowsSourceContext context, @NotNull SQLQueryRecognitionContext statistics) {
        this.owner.resolveRowSources(context, statistics);
    }

    @Override
    @NotNull
    protected SQLQueryExprType resolveValueTypeImpl(@NotNull SQLQueryRowsDataContext context, @NotNull SQLQueryRecognitionContext statistics) {
        this.resolveTypeImpl(statistics);
        return this.type;
    }

    private void resolveTypeImpl(@NotNull SQLQueryRecognitionContext statistics) {
        SQLQuerySymbolOrigin.MemberOfType memberOrigin = new SQLQuerySymbolOrigin.MemberOfType(this.owner.getValueType());
        if (this.identifier == null) {
            this.type = SQLQueryExprType.UNKNOWN;
            if (this.memberAccessEntry != null) {
                this.memberAccessEntry.setOrigin(memberOrigin);
            }
        } else if (this.identifier.isNotClassified()) {
            SQLQueryExprType type = SQLQuerySemanticUtils.tryResolveMemberReference(statistics, this.owner.getValueType(), this.identifier, memberOrigin);
            this.type = type != null ? type : SQLQueryExprType.UNKNOWN;
        }
    }

    @Override
    protected <R, T> R applyImpl(@NotNull SQLQueryNodeModelVisitor<T, R> visitor, @NotNull T arg) {
        return visitor.visitValueMemberReferenceExpr(this, arg);
    }

    public String toString() {
        return "ValueMember[(" + String.valueOf(this.owner) + ")." + (this.identifier == null ? "<NULL>" : this.identifier.getName()) + ":" + String.valueOf(this.type) + "]";
    }
}

