/*
 * Decompiled with CFR 0.152.
 */
package org.jkiss.dbeaver.ui.ai.controls;

import java.util.List;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Shell;
import org.jkiss.code.NotNull;
import org.jkiss.dbeaver.model.DBPDataSourceContainer;
import org.jkiss.dbeaver.model.app.DBPProject;
import org.jkiss.dbeaver.model.exec.DBCExecutionContext;
import org.jkiss.dbeaver.model.exec.DBCExecutionContextDefaults;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseFolder;
import org.jkiss.dbeaver.model.navigator.DBNDatabaseNode;
import org.jkiss.dbeaver.model.navigator.DBNModel;
import org.jkiss.dbeaver.model.navigator.DBNNode;
import org.jkiss.dbeaver.model.runtime.DBRProgressMonitor;
import org.jkiss.dbeaver.model.runtime.DBRRunnableContext;
import org.jkiss.dbeaver.model.runtime.VoidProgressMonitor;
import org.jkiss.dbeaver.model.struct.DBSEntity;
import org.jkiss.dbeaver.model.struct.DBSEntityContainer;
import org.jkiss.dbeaver.model.struct.DBSInstance;
import org.jkiss.dbeaver.model.struct.DBSObject;
import org.jkiss.dbeaver.model.struct.DBSStructContainer;
import org.jkiss.dbeaver.model.struct.rdb.DBSCatalog;
import org.jkiss.dbeaver.ui.UIUtils;
import org.jkiss.dbeaver.ui.ai.internal.AIUIActivator;
import org.jkiss.dbeaver.ui.dialogs.BaseDialog;
import org.jkiss.dbeaver.ui.navigator.database.DatabaseObjectsSelectorPanel;

public class ScopeSelectorDialog
extends BaseDialog {
    private static final String DIALOG_ID = "DBeaver.AIScopeSelectorDialog";
    private final DBRRunnableContext runnableContext;
    private final DBPDataSourceContainer dataSourceContainer;
    private final DBCExecutionContext executionContext;
    private DatabaseObjectsSelectorPanel selectorPanel;
    private List<? extends DBNNode> selectedNodes;

    public ScopeSelectorDialog(@NotNull Shell parentShell, @NotNull DBRRunnableContext runnableContext, @NotNull DBPDataSourceContainer container, @NotNull DBCExecutionContext executionContext, @NotNull List<? extends DBNNode> selectedNodes) {
        super(parentShell, "Select objects to include in completion scope", null);
        this.runnableContext = runnableContext;
        this.dataSourceContainer = container;
        this.executionContext = executionContext;
        this.selectedNodes = selectedNodes;
    }

    protected IDialogSettings getDialogBoundsSettings() {
        return UIUtils.getSettingsSection((IDialogSettings)AIUIActivator.getDefault().getDialogSettings(), (String)DIALOG_ID);
    }

    protected Composite createDialogArea(Composite parent) {
        DBNDatabaseNode catalogNode;
        DBSCatalog defaultCatalog;
        Composite dialogArea = super.createDialogArea(parent);
        final DBPProject project = this.dataSourceContainer.getProject();
        DBNModel navigatorModel = project.getNavigatorModel();
        DBNDatabaseNode rootNode = navigatorModel.getNodeByObject((DBSObject)this.dataSourceContainer);
        DBCExecutionContextDefaults contextDefaults = this.executionContext.getContextDefaults();
        if (contextDefaults != null && (defaultCatalog = contextDefaults.getDefaultCatalog()) instanceof DBSInstance && (catalogNode = navigatorModel.getNodeByObject((DBRProgressMonitor)new VoidProgressMonitor(), (DBSObject)defaultCatalog, false)) != null) {
            rootNode = catalogNode;
        }
        final DBNDatabaseNode finalRootNode = rootNode;
        this.selectorPanel = new DatabaseObjectsSelectorPanel(dialogArea, true, this.runnableContext){

            protected DBPProject getSelectedProject() {
                return project;
            }

            protected DBNNode getRootNode() {
                return finalRootNode;
            }

            protected boolean isDatabaseFolderVisible(DBNDatabaseFolder folder) {
                Class childrenClass = folder.getChildrenClass();
                if (childrenClass == null) {
                    return false;
                }
                return DBSEntity.class.isAssignableFrom(childrenClass) || DBSEntityContainer.class.isAssignableFrom(childrenClass) || DBSStructContainer.class.isAssignableFrom(childrenClass);
            }

            protected boolean isDatabaseObjectVisible(DBSObject obj) {
                return obj instanceof DBSStructContainer || obj instanceof DBSEntityContainer || obj instanceof DBSEntity;
            }
        };
        this.selectorPanel.getCheckboxTreeManager().setAutoCheckNested(false);
        this.selectorPanel.getNavigatorTree().getViewer().expandToLevel(2);
        this.selectorPanel.checkNodes(this.selectedNodes, true);
        this.selectorPanel.setSelection(this.selectedNodes);
        UIUtils.createInfoLabel((Composite)dialogArea, (String)"Define database metadata to send to AI");
        return dialogArea;
    }

    protected void okPressed() {
        this.selectedNodes = this.selectorPanel.getCheckedNodes();
        this.selectedNodes.removeIf(n -> {
            DBNDatabaseNode dbn;
            DBSObject object;
            return !(n instanceof DBNDatabaseNode) || !((object = (dbn = (DBNDatabaseNode)n).getObject()) instanceof DBSEntity) && !(object instanceof DBSEntityContainer) && !(object instanceof DBSStructContainer);
        });
        this.selectedNodes.removeIf(n -> this.selectedNodes.contains(n.getParentNode()));
        super.okPressed();
    }

    public List<? extends DBNNode> getSelectedNodes() {
        return this.selectedNodes;
    }
}

