/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.impl.AbstractInput;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.raw.RawObject;
import java.math.BigInteger;
import java.util.IdentityHashMap;

abstract class RawAbstractInput
extends AbstractInput {
    private IdentityHashMap converted;

    RawAbstractInput(Catalog catalog, boolean bl, IdentityHashMap identityHashMap) {
        super(catalog, bl);
        this.converted = identityHashMap;
    }

    @Override
    public Object readObject() {
        return this.readNext();
    }

    @Override
    public Object readKeyObject(Format format) {
        return this.readNext();
    }

    @Override
    public void registerPriKeyObject(Object object) {
    }

    @Override
    public int readArrayLength() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int readEnumConstant(String[] stringArray) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void skipField(Format format) {
    }

    abstract Object readNext();

    Object checkAndConvert(Object object, Format format) {
        if (object == null) {
            if (format.isPrimitive()) {
                throw new IllegalArgumentException("A primitive type may not be null or missing: " + format.getClassName());
            }
        } else if (format.isSimple()) {
            if (format.isPrimitive()) {
                if (object.getClass() != format.getWrapperFormat().getType()) {
                    throw new IllegalArgumentException("Raw value class: " + object.getClass().getName() + " must be the wrapper class for a primitive type: " + format.getClassName());
                }
            } else if (object.getClass() != format.getType()) {
                throw new IllegalArgumentException("Raw value class: " + object.getClass().getName() + " must be the declared class for a simple type: " + format.getClassName());
            }
        } else {
            if (object instanceof RawObject) {
                Object var3_3 = null;
                if (!this.rawAccess) {
                    if (this.converted != null) {
                        var3_3 = this.converted.get(object);
                    } else {
                        this.converted = new IdentityHashMap();
                    }
                }
                if (var3_3 != null) {
                    object = var3_3;
                } else if (!this.rawAccess) {
                    object = this.catalog.convertRawObject((RawObject)object, this.converted);
                }
            } else if (!SimpleCatalog.isSimpleType(object.getClass())) {
                throw new IllegalArgumentException("Raw value class: " + object.getClass().getName() + " must be RawObject a simple type");
            }
            if (this.rawAccess) {
                RawAbstractInput.checkRawType(this.catalog, object, format);
            } else if (!format.getType().isAssignableFrom(object.getClass())) {
                throw new IllegalArgumentException("Raw value class: " + object.getClass().getName() + " is not assignable to type: " + format.getClassName());
            }
        }
        return object;
    }

    static Format checkRawType(Catalog catalog, Object object, Format format) {
        Format format2;
        assert (format != null);
        if (object instanceof RawObject) {
            format2 = (Format)((RawObject)object).getType();
        } else {
            format2 = catalog.getFormat(object.getClass(), false);
            if (!format2.isSimple() || format2.isEnum()) {
                throw new IllegalArgumentException("Not a RawObject or a non-enum simple type: " + format2.getClassName());
            }
        }
        if (!format2.isAssignableTo(format)) {
            throw new IllegalArgumentException("Not a subtype of the field's declared class " + format.getClassName() + ": " + format2.getClassName());
        }
        if (!format2.isCurrentVersion()) {
            throw new IllegalArgumentException("Raw type version is not current.  Class: " + format2.getClassName() + " Version: " + format2.getVersion());
        }
        Format format3 = format2.getProxiedFormat();
        if (format3 != null) {
            format2 = format3;
        }
        return format2;
    }

    @Override
    public String readString() {
        return (String)this.readNext();
    }

    @Override
    public char readChar() {
        return ((Character)this.readNext()).charValue();
    }

    @Override
    public boolean readBoolean() {
        return (Boolean)this.readNext();
    }

    @Override
    public byte readByte() {
        return (Byte)this.readNext();
    }

    @Override
    public short readShort() {
        return (Short)this.readNext();
    }

    @Override
    public int readInt() {
        return (Integer)this.readNext();
    }

    @Override
    public long readLong() {
        return (Long)this.readNext();
    }

    @Override
    public float readSortedFloat() {
        return ((Float)this.readNext()).floatValue();
    }

    @Override
    public double readSortedDouble() {
        return (Double)this.readNext();
    }

    @Override
    public BigInteger readBigInteger() {
        return (BigInteger)this.readNext();
    }
}

