/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.persist.impl;

import com.sleepycat.persist.evolve.Converter;
import com.sleepycat.persist.evolve.Deleter;
import com.sleepycat.persist.evolve.EntityConverter;
import com.sleepycat.persist.evolve.Mutations;
import com.sleepycat.persist.evolve.Renamer;
import com.sleepycat.persist.impl.Accessor;
import com.sleepycat.persist.impl.Catalog;
import com.sleepycat.persist.impl.CollectionProxy;
import com.sleepycat.persist.impl.EnhancedAccessor;
import com.sleepycat.persist.impl.EntityInput;
import com.sleepycat.persist.impl.EntityOutput;
import com.sleepycat.persist.impl.Evolver;
import com.sleepycat.persist.impl.FieldInfo;
import com.sleepycat.persist.impl.Format;
import com.sleepycat.persist.impl.PersistKeyCreator;
import com.sleepycat.persist.impl.RawAccessor;
import com.sleepycat.persist.impl.RawComplexInput;
import com.sleepycat.persist.impl.RawSingleInput;
import com.sleepycat.persist.impl.Reader;
import com.sleepycat.persist.impl.RecordInput;
import com.sleepycat.persist.impl.ReflectionAccessor;
import com.sleepycat.persist.impl.SimpleCatalog;
import com.sleepycat.persist.impl.WidenerInput;
import com.sleepycat.persist.model.ClassMetadata;
import com.sleepycat.persist.model.DeleteAction;
import com.sleepycat.persist.model.EntityMetadata;
import com.sleepycat.persist.model.EntityModel;
import com.sleepycat.persist.model.FieldMetadata;
import com.sleepycat.persist.model.Relationship;
import com.sleepycat.persist.model.SecondaryKeyMetadata;
import com.sleepycat.persist.raw.RawField;
import com.sleepycat.persist.raw.RawObject;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ComplexFormat
extends Format {
    private static final long serialVersionUID = -2847843033590454917L;
    private ClassMetadata clsMeta;
    private EntityMetadata entityMeta;
    private FieldInfo priKeyField;
    private List<FieldInfo> secKeyFields;
    private List<FieldInfo> nonKeyFields;
    private FieldReader secKeyFieldReader;
    private FieldReader nonKeyFieldReader;
    private Map<String, String> oldToNewKeyMap;
    private Map<String, String> newToOldFieldMap;
    private boolean evolveNeeded;
    private transient Accessor objAccessor;
    private transient Accessor rawAccessor;
    private transient ComplexFormat entityFormat;
    private transient Map<String, FieldAddress> secKeyAddresses;
    private volatile transient Map<String, RawField> rawFields;
    private volatile transient FieldInfo[] rawInputFields;
    private volatile transient int[] rawInputLevels;
    private volatile transient int rawInputDepth;

    ComplexFormat(Class clazz, ClassMetadata classMetadata, EntityMetadata entityMetadata) {
        super(clazz);
        this.clsMeta = classMetadata;
        this.entityMeta = entityMetadata;
        this.secKeyFields = new ArrayList<FieldInfo>();
        this.nonKeyFields = FieldInfo.getInstanceFields(clazz, classMetadata);
        if (classMetadata.getPrimaryKey() != null) {
            String string = classMetadata.getPrimaryKey().getName();
            FieldInfo serializable = FieldInfo.getField(this.nonKeyFields, string);
            if (serializable == null) {
                throw new IllegalArgumentException("Primary key field does not exist: " + this.getClassName() + '.' + (String)string);
            }
            this.nonKeyFields.remove(serializable);
            this.priKeyField = serializable;
        }
        if (classMetadata.getSecondaryKeys() != null) {
            for (SecondaryKeyMetadata secondaryKeyMetadata : classMetadata.getSecondaryKeys().values()) {
                String string = secondaryKeyMetadata.getName();
                FieldInfo fieldInfo = FieldInfo.getField(this.nonKeyFields, string);
                if (fieldInfo == null) {
                    throw new IllegalArgumentException("Secondary key field does not exist: " + this.getClassName() + '.' + string);
                }
                Class clazz2 = fieldInfo.getFieldClass();
                Relationship relationship = secondaryKeyMetadata.getRelationship();
                if (relationship == Relationship.ONE_TO_MANY || relationship == Relationship.MANY_TO_MANY) {
                    if (!PersistKeyCreator.isManyType(clazz2)) {
                        throw new IllegalArgumentException("ONE_TO_MANY and MANY_TO_MANY keys must have an array or Collection type: " + this.getClassName() + '.' + string);
                    }
                } else if (PersistKeyCreator.isManyType(clazz2)) {
                    throw new IllegalArgumentException("ONE_TO_ONE and MANY_TO_ONE keys must not have an array or Collection type: " + this.getClassName() + '.' + string);
                }
                if (clazz2.isPrimitive() && secondaryKeyMetadata.getDeleteAction() == DeleteAction.NULLIFY) {
                    throw new IllegalArgumentException("NULLIFY may not be used with primitive fields: " + this.getClassName() + '.' + string);
                }
                this.nonKeyFields.remove(fieldInfo);
                this.secKeyFields.add(fieldInfo);
            }
        }
        Collections.sort(this.secKeyFields);
        Collections.sort(this.nonKeyFields);
    }

    @Override
    void migrateFromBeta(Map<String, Format> map) {
        super.migrateFromBeta(map);
        if (this.priKeyField != null) {
            this.priKeyField.migrateFromBeta(map);
        }
        for (FieldInfo fieldInfo : this.secKeyFields) {
            fieldInfo.migrateFromBeta(map);
        }
        for (FieldInfo fieldInfo : this.nonKeyFields) {
            fieldInfo.migrateFromBeta(map);
        }
    }

    ComplexFormat getComplexSuper() {
        return (ComplexFormat)this.getSuperFormat();
    }

    private ComplexFormat getComplexLatest() {
        return (ComplexFormat)this.getLatestVersion();
    }

    FieldInfo getPriKeyFieldInfo() {
        return this.priKeyField;
    }

    String getPriKeyField() {
        if (this.clsMeta.getPrimaryKey() != null) {
            return this.clsMeta.getPrimaryKey().getName();
        }
        return null;
    }

    @Override
    boolean isEntity() {
        return this.clsMeta.isEntityClass();
    }

    @Override
    boolean isModelClass() {
        return true;
    }

    @Override
    public ClassMetadata getClassMetadata() {
        return this.clsMeta;
    }

    @Override
    public EntityMetadata getEntityMetadata() {
        return this.entityMeta;
    }

    @Override
    ComplexFormat getEntityFormat() {
        if (this.isInitialized()) {
            return this.entityFormat;
        }
        if (this.isNew()) {
            throw new IllegalStateException(this.toString());
        }
        for (ComplexFormat complexFormat = this; complexFormat != null; complexFormat = complexFormat.getComplexSuper()) {
            if (!complexFormat.isEntity()) continue;
            return complexFormat;
        }
        return null;
    }

    @Override
    void setEvolveNeeded(boolean bl) {
        this.evolveNeeded = bl;
    }

    @Override
    boolean getEvolveNeeded() {
        return this.evolveNeeded;
    }

    @Override
    public Map<String, RawField> getFields() {
        if (this.rawFields == null) {
            HashMap<String, RawField> hashMap = new HashMap<String, RawField>();
            if (this.priKeyField != null) {
                hashMap.put(this.priKeyField.getName(), this.priKeyField);
            }
            for (RawField rawField : this.secKeyFields) {
                hashMap.put(rawField.getName(), rawField);
            }
            for (RawField rawField : this.nonKeyFields) {
                hashMap.put(rawField.getName(), rawField);
            }
            this.rawFields = hashMap;
        }
        return this.rawFields;
    }

    @Override
    void collectRelatedFormats(Catalog catalog, Map<String, Format> map) {
        Format format;
        Class clazz = this.getType();
        if (this.priKeyField != null) {
            this.priKeyField.collectRelatedFormats(catalog, map);
        }
        for (FieldInfo object2 : this.secKeyFields) {
            object2.collectRelatedFormats(catalog, map);
        }
        Iterator<SecondaryKeyMetadata> iterator = this.nonKeyFields.iterator();
        while (iterator.hasNext()) {
            FieldInfo fieldInfo = iterator.next();
            fieldInfo.collectRelatedFormats(catalog, map);
        }
        if (this.entityMeta != null) {
            iterator = this.entityMeta.getSecondaryKeys().values().iterator();
            while (iterator.hasNext()) {
                SecondaryKeyMetadata secondaryKeyMetadata = iterator.next();
                String string = secondaryKeyMetadata.getElementClassName();
                if (string == null) continue;
                Class clazz2 = SimpleCatalog.keyClassForName(string);
                catalog.createFormat(clazz2, map);
            }
        }
        if ((iterator = clazz.getSuperclass()) != Object.class && !((format = catalog.createFormat((Class)((Object)iterator), map)) instanceof ComplexFormat)) {
            throw new IllegalArgumentException("The superclass of a complex type must not be a composite key class or a simple type class: " + ((Class)((Object)iterator)).getName());
        }
        String string = this.clsMeta.getProxiedClassName();
        if (string != null) {
            catalog.createFormat(string, map);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    void initialize(Catalog catalog, EntityModel entityModel, int n) {
        void var7_15;
        Class clazz;
        Class clazz2 = this.getType();
        boolean bl = false;
        if (clazz2 != null) {
            bl = EnhancedAccessor.isEnhanced(clazz2);
        }
        if (this.priKeyField != null) {
            this.priKeyField.initialize(catalog, entityModel, n);
        }
        for (FieldInfo object2 : this.secKeyFields) {
            object2.initialize(catalog, entityModel, n);
        }
        for (FieldInfo fieldInfo : this.nonKeyFields) {
            fieldInfo.initialize(catalog, entityModel, n);
        }
        Object object3 = this.getComplexSuper();
        if (clazz2 != null && object3 == null && (clazz = clazz2.getSuperclass()) != Object.class) {
            object3 = (ComplexFormat)catalog.getFormat(clazz.getName());
            this.setSuperFormat((Format)object3);
        }
        if (object3 != null) {
            ((Format)object3).initializeIfNeeded(catalog, entityModel);
            Accessor accessor = ((ComplexFormat)object3).objAccessor;
            if (clazz2 != null && accessor != null) {
                if (bl) {
                    if (!(accessor instanceof EnhancedAccessor)) {
                        throw new IllegalStateException("The superclass of an enhanced class must also be enhanced: " + this.getClassName() + " extends " + ((Format)object3).getClassName());
                    }
                } else if (!(accessor instanceof ReflectionAccessor)) {
                    throw new IllegalStateException("The superclass of an unenhanced class must not be enhanced: " + this.getClassName() + " extends " + ((Format)object3).getClassName());
                }
            }
        }
        ComplexFormat complexFormat = this;
        while (var7_15 != null) {
            if (var7_15.isEntity()) {
                this.entityFormat = var7_15;
                break;
            }
            ComplexFormat complexFormat2 = var7_15.getComplexSuper();
        }
        if (this.isEntity() && this.isCurrentVersion()) {
            this.entityMeta = entityModel.getEntityMetadata(this.getClassName());
        }
        if (this.clsMeta.getProxiedClassName() != null && this.entityFormat != null) {
            throw new IllegalArgumentException("A proxy may not be an entity: " + this.getClassName());
        }
        if (this.entityFormat != null && this.entityFormat != this && this.priKeyField != null) {
            throw new IllegalArgumentException("A PrimaryKey may not appear on an Entity subclass: " + this.getClassName() + " field: " + this.priKeyField.getName());
        }
        if (clazz2 != null) {
            if (bl) {
                this.objAccessor = new EnhancedAccessor(catalog, clazz2, this);
            } else {
                Accessor accessor = object3 != null ? ((ComplexFormat)object3).objAccessor : null;
                this.objAccessor = new ReflectionAccessor(catalog, clazz2, accessor, this.priKeyField, this.secKeyFields, this.nonKeyFields);
            }
        }
        Accessor accessor = object3 != null ? ((ComplexFormat)object3).rawAccessor : null;
        this.rawAccessor = new RawAccessor(this, accessor, this.priKeyField, this.secKeyFields, this.nonKeyFields);
        EntityMetadata entityMetadata = null;
        if (this.entityFormat != null) {
            entityMetadata = this.entityFormat.getLatestVersion().getEntityMetadata();
        }
        if (entityMetadata != null) {
            this.secKeyAddresses = new HashMap<String, FieldAddress>();
            ComplexFormat complexFormat3 = this.getComplexLatest();
            if (complexFormat3 != this) {
                complexFormat3.initializeIfNeeded(catalog, entityModel);
            }
            block3: for (SecondaryKeyMetadata secondaryKeyMetadata : entityMetadata.getSecondaryKeys().values()) {
                String string = secondaryKeyMetadata.getDeclaringClassName();
                String string2 = secondaryKeyMetadata.getName();
                int n2 = 0;
                for (ComplexFormat complexFormat4 = this; complexFormat4 != null; complexFormat4 = complexFormat4.getComplexSuper()) {
                    if (string.equals(complexFormat4.getLatestVersion().getClassName())) {
                        int n3;
                        boolean bl2;
                        String string3 = null;
                        string3 = complexFormat4.newToOldFieldMap != null && complexFormat4.newToOldFieldMap.containsKey(string2) ? complexFormat4.newToOldFieldMap.get(string2) : string2;
                        FieldInfo fieldInfo = FieldInfo.getField(complexFormat4.secKeyFields, string3);
                        if (fieldInfo != null) {
                            bl2 = true;
                            n3 = complexFormat4.secKeyFields.indexOf(fieldInfo);
                        } else {
                            bl2 = false;
                            fieldInfo = FieldInfo.getField(complexFormat4.nonKeyFields, string3);
                            if (fieldInfo == null) {
                                assert (complexFormat3 != this);
                                complexFormat3.checkNewSecKeyInitializer(secondaryKeyMetadata);
                                continue block3;
                            }
                            n3 = complexFormat4.nonKeyFields.indexOf(fieldInfo);
                        }
                        FieldAddress fieldAddress = new FieldAddress(bl2, n3, n2, complexFormat4, fieldInfo.getType());
                        this.secKeyAddresses.put(secondaryKeyMetadata.getKeyName(), fieldAddress);
                    }
                    ++n2;
                }
            }
        }
    }

    private void checkNewSecKeyInitializer(SecondaryKeyMetadata secondaryKeyMetadata) {
        if (this.objAccessor != null) {
            FieldAddress fieldAddress = this.secKeyAddresses.get(secondaryKeyMetadata.getKeyName());
            Object object = this.objAccessor.newInstance();
            Object object2 = this.objAccessor.getField(object, fieldAddress.fieldNum, fieldAddress.superLevel, fieldAddress.isSecField);
            if (object2 != null) {
                if (fieldAddress.keyFormat.isPrimitive()) {
                    throw new IllegalArgumentException("For a new secondary key field the field type must not be a primitive -- class: " + secondaryKeyMetadata.getDeclaringClassName() + " field: " + secondaryKeyMetadata.getName());
                }
                throw new IllegalArgumentException("For a new secondary key field the default constructor must not initialize the field to a non-null value -- class: " + secondaryKeyMetadata.getDeclaringClassName() + " field: " + secondaryKeyMetadata.getName());
            }
        }
    }

    private boolean nullOrEqual(Object object, Object object2) {
        if (object == null) {
            return object2 == null;
        }
        return object.equals(object2);
    }

    @Override
    Object newArray(int n) {
        return this.objAccessor.newArray(n);
    }

    @Override
    public Object newInstance(EntityInput entityInput, boolean bl) {
        Accessor accessor = bl ? this.rawAccessor : this.objAccessor;
        return accessor.newInstance();
    }

    @Override
    public Object readObject(Object object, EntityInput entityInput, boolean bl) {
        Accessor accessor = bl ? this.rawAccessor : this.objAccessor;
        accessor.readSecKeyFields(object, entityInput, 0, 0x7FFFFFFE, -1);
        accessor.readNonKeyFields(object, entityInput, 0, 0x7FFFFFFE, -1);
        return object;
    }

    @Override
    void writeObject(Object object, EntityOutput entityOutput, boolean bl) {
        Accessor accessor = bl ? this.rawAccessor : this.objAccessor;
        accessor.writeSecKeyFields(object, entityOutput);
        accessor.writeNonKeyFields(object, entityOutput);
    }

    @Override
    Object convertRawObject(Catalog catalog, boolean bl, RawObject rawObjectArray, IdentityHashMap identityHashMap) {
        RawObject[] rawObjectArray2;
        Object object;
        int n;
        FieldInfo[] fieldInfoArray = this.rawInputFields;
        int[] nArray = this.rawInputLevels;
        int n2 = this.rawInputDepth;
        if (fieldInfoArray == null || nArray == null || n2 == 0) {
            Object object2;
            n2 = 0;
            int n3 = 0;
            for (object2 = this; object2 != null; object2 = object2.getComplexSuper()) {
                n3 += object2.getNFields();
                ++n2;
            }
            object2 = new ComplexFormat[n2];
            int n4 = n2;
            for (Object object3 = this; object3 != null; object3 = object3.getComplexSuper()) {
                object2[--n4] = object3;
            }
            assert (n4 == 0);
            nArray = new int[n3];
            fieldInfoArray = new FieldInfo[n3];
            n = 0;
            if (this.getEntityFormat() != null) {
                for (n4 = n2 - 1; n4 >= 0; --n4) {
                    object = object2[n4];
                    if (((ComplexFormat)object).priKeyField == null) continue;
                    nArray[n] = n4;
                    fieldInfoArray[n] = ((ComplexFormat)object).priKeyField;
                    ++n;
                    break;
                }
                assert (n == 1);
            }
            for (n4 = 0; n4 < n2; ++n4) {
                object = object2[n4];
                for (FieldInfo fieldInfo : ((ComplexFormat)object).secKeyFields) {
                    nArray[n] = n4;
                    fieldInfoArray[n] = fieldInfo;
                    ++n;
                }
            }
            for (n4 = 0; n4 < n2; ++n4) {
                object = object2[n4];
                for (FieldInfo fieldInfo : ((ComplexFormat)object).nonKeyFields) {
                    nArray[n] = n4;
                    fieldInfoArray[n] = fieldInfo;
                    ++n;
                }
            }
            assert (n == fieldInfoArray.length);
            this.rawInputFields = fieldInfoArray;
            this.rawInputLevels = nArray;
            this.rawInputDepth = n2;
        }
        RawObject[] rawObjectArray3 = new RawObject[n2];
        int n5 = n2;
        for (rawObjectArray2 = rawObjectArray; rawObjectArray2 != null; rawObjectArray2 = rawObjectArray2.getSuper()) {
            if (n5 == 0) {
                throw new IllegalArgumentException("RawObject has too many superclasses: " + rawObjectArray.getType().getClassName());
            }
            rawObjectArray3[--n5] = rawObjectArray2;
        }
        if (n5 > 0) {
            throw new IllegalArgumentException("RawObject has too few superclasses: " + rawObjectArray.getType().getClassName());
        }
        assert (n5 == 0);
        rawObjectArray2 = new RawObject[fieldInfoArray.length];
        for (n = 0; n < rawObjectArray2.length; ++n) {
            rawObjectArray2[n] = rawObjectArray3[nArray[n]];
        }
        RawComplexInput rawComplexInput = new RawComplexInput(catalog, bl, identityHashMap, fieldInfoArray, rawObjectArray2);
        object = this.newInstance(rawComplexInput, bl);
        identityHashMap.put(rawObjectArray, object);
        if (this.getEntityFormat() != null) {
            this.readPriKey(object, rawComplexInput, bl);
        }
        return this.readObject(object, rawComplexInput, bl);
    }

    @Override
    boolean isPriKeyNullOrZero(Object object, boolean bl) {
        Accessor accessor = bl ? this.rawAccessor : this.objAccessor;
        return accessor.isPriKeyFieldNullOrZero(object);
    }

    @Override
    void writePriKey(Object object, EntityOutput entityOutput, boolean bl) {
        Accessor accessor = bl ? this.rawAccessor : this.objAccessor;
        accessor.writePriKeyField(object, entityOutput);
    }

    @Override
    public void readPriKey(Object object, EntityInput entityInput, boolean bl) {
        Accessor accessor = bl ? this.rawAccessor : this.objAccessor;
        accessor.readPriKeyField(object, entityInput);
    }

    @Override
    boolean nullifySecKey(Catalog catalog, Object object, String string, Object object2) {
        if (this.secKeyAddresses == null) {
            throw new IllegalStateException();
        }
        FieldAddress fieldAddress = this.secKeyAddresses.get(string);
        if (fieldAddress != null) {
            Object object3 = this.rawAccessor.getField(object, fieldAddress.fieldNum, fieldAddress.superLevel, fieldAddress.isSecField);
            if (object3 != null) {
                if (object2 != null) {
                    boolean bl;
                    RawObject rawObject = (RawObject)object3;
                    Object[] objectArray = rawObject.getElements();
                    boolean bl2 = bl = objectArray != null;
                    if (!bl) {
                        objectArray = CollectionProxy.getElements(rawObject);
                    }
                    if (objectArray != null) {
                        for (int i = 0; i < objectArray.length; ++i) {
                            if (!object2.equals(objectArray[i])) continue;
                            int n = objectArray.length - 1;
                            Object[] objectArray2 = new Object[n];
                            System.arraycopy(objectArray, 0, objectArray2, 0, i);
                            System.arraycopy(objectArray, i + 1, objectArray2, i, n - i);
                            if (bl) {
                                this.rawAccessor.setField(object, fieldAddress.fieldNum, fieldAddress.superLevel, fieldAddress.isSecField, new RawObject(rawObject.getType(), objectArray2));
                            } else {
                                CollectionProxy.setElements(rawObject, objectArray2);
                            }
                            return true;
                        }
                    }
                    return false;
                }
                this.rawAccessor.setField(object, fieldAddress.fieldNum, fieldAddress.superLevel, fieldAddress.isSecField, null);
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    void skipContents(RecordInput recordInput) {
        this.skipToSecKeyField(recordInput, 0x7FFFFFFE);
        this.skipToNonKeyField(recordInput, 0x7FFFFFFE);
    }

    @Override
    void copySecMultiKey(RecordInput recordInput, Format format, Set set) {
        CollectionProxy.copyElements(recordInput, this, format, set);
    }

    @Override
    Format skipToSecKey(RecordInput recordInput, String string) {
        if (this.secKeyAddresses == null) {
            throw new IllegalStateException();
        }
        FieldAddress fieldAddress = this.secKeyAddresses.get(string);
        if (fieldAddress != null) {
            if (fieldAddress.isSecField) {
                fieldAddress.clsFormat.skipToSecKeyField(recordInput, fieldAddress.fieldNum);
            } else {
                this.skipToSecKeyField(recordInput, 0x7FFFFFFE);
                fieldAddress.clsFormat.skipToNonKeyField(recordInput, fieldAddress.fieldNum);
            }
            return fieldAddress.keyFormat;
        }
        return null;
    }

    private int getNFields() {
        return (this.priKeyField != null ? 1 : 0) + this.secKeyFields.size() + this.nonKeyFields.size();
    }

    private void skipToSecKeyField(RecordInput recordInput, int n) {
        ComplexFormat complexFormat = this.getComplexSuper();
        if (complexFormat != null) {
            complexFormat.skipToSecKeyField(recordInput, 0x7FFFFFFE);
        }
        int n2 = Math.min(this.secKeyFields.size(), n);
        for (int i = 0; i < n2; ++i) {
            recordInput.skipField(this.secKeyFields.get(i).getType());
        }
    }

    private void skipToNonKeyField(RecordInput recordInput, int n) {
        ComplexFormat complexFormat = this.getComplexSuper();
        if (complexFormat != null) {
            complexFormat.skipToNonKeyField(recordInput, 0x7FFFFFFE);
        }
        int n2 = Math.min(this.nonKeyFields.size(), n);
        for (int i = 0; i < n2; ++i) {
            recordInput.skipField(this.nonKeyFields.get(i).getType());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    boolean evolve(Format format, Evolver evolver) {
        Object object;
        Iterator iterator;
        Serializable serializable;
        Serializable serializable2;
        String string;
        String string2;
        if (!(format instanceof ComplexFormat)) {
            evolver.addMissingMutation(this, format, "Converter is required when a complex type is changed to a simple type or enum type");
            return false;
        }
        ComplexFormat complexFormat = (ComplexFormat)format;
        Mutations mutations = evolver.getMutations();
        boolean bl = false;
        boolean bl2 = false;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        assert (this.isEntity() == complexFormat.isEntity());
        assert (this.isEntity() == (this.entityMeta != null));
        assert (complexFormat.isEntity() == (complexFormat.entityMeta != null));
        if (this.isEntity()) {
            string2 = this.getClassName();
            string = complexFormat.getClassName();
        } else {
            string2 = null;
            string = null;
        }
        for (serializable2 = this.getComplexSuper(); serializable2 != null; serializable2 = ((ComplexFormat)serializable2).getComplexSuper()) {
            serializable = mutations.getConverter(((Format)serializable2).getClassName(), ((Format)serializable2).getVersion(), null);
            if (serializable != null) {
                evolver.addMissingMutation(this, format, "Converter is required for this subclass when a Converter appears on its superclass: " + serializable);
                return false;
            }
            if (!evolver.evolveFormat((Format)serializable2)) {
                return false;
            }
            if (((Format)serializable2).isCurrentVersion()) continue;
            if (((Format)serializable2).isDeleted() && !super.evolveDeletedClass(evolver)) {
                return false;
            }
            if (((ComplexFormat)serializable2).oldToNewKeyMap != null) {
                hashMap.putAll(((ComplexFormat)serializable2).oldToNewKeyMap);
            }
            bl2 = true;
        }
        serializable = serializable2 = complexFormat.getExistingType();
        ArrayList<Integer> arrayList = new ArrayList<Integer>();
        int n = 0;
        arrayList.add(n);
        if (this.getSuperFormat() == null) {
            if (((Class)serializable2).getSuperclass() != Object.class) {
                bl = true;
                bl2 = true;
            }
        } else if (!this.getSuperFormat().getLatestVersion().getClassName().equals(((Class)serializable2).getSuperclass().getName())) {
            bl = true;
            bl2 = true;
        }
        for (ComplexFormat complexFormat2 = this.getComplexSuper(); complexFormat2 != null; complexFormat2 = complexFormat2.getComplexSuper()) {
            Object object2;
            Object object3;
            void object4;
            iterator = complexFormat2.getLatestVersion().getClassName();
            Object var16_18 = null;
            int n2 = n;
            for (object = ((Class)serializable).getSuperclass(); object != Object.class; object = ((Class)object).getSuperclass()) {
                ++n2;
                if (!((String)((Object)iterator)).equals(((Class)object).getName())) continue;
                Class clazz = object;
                n = n2;
                if (!complexFormat2.isEntity()) break;
                assert (string2 == null);
                assert (string == null);
                string2 = complexFormat2.getClassName();
                string = clazz.getName();
                break;
            }
            if (object4 != null) {
                for (object = ((Class)serializable).getSuperclass(); object != object4; object = ((Class)object).getSuperclass()) {
                    bl2 = true;
                    for (object3 = complexFormat2.getComplexSuper(); object3 != null; object3 = ((ComplexFormat)object3).getComplexSuper()) {
                        object2 = ((Format)object3).getLatestVersion().getClassName();
                        if (!((String)object2).equals(((Class)object).getName())) continue;
                        evolver.addMissingMutation(this, format, "Class Converter is required when a superclass is moved in the class hierarchy: " + ((Class)object).getName());
                        return false;
                    }
                }
                serializable = object4;
                arrayList.add(n);
                continue;
            }
            bl2 = true;
            if (!complexFormat2.isDeleted() && super.getNFields() != 0) {
                evolver.addMissingMutation(this, format, "When a superclass is removed from the class hierarchy, the superclass or all of its persistent fields must be deleted with a Deleter: " + ((Format)object).getClassName());
                return false;
            }
            if (string2 != null && this.isCurrentVersion()) {
                object = complexFormat2.clsMeta.getSecondaryKeys();
                object3 = complexFormat2.secKeyFields.iterator();
                while (object3.hasNext()) {
                    object2 = (FieldInfo)object3.next();
                    SecondaryKeyMetadata secondaryKeyMetadata = ComplexFormat.getSecondaryKeyMetadataByFieldName(object, ((FieldInfo)object2).getName());
                    assert (secondaryKeyMetadata != null);
                    hashMap.put(secondaryKeyMetadata.getKeyName(), null);
                }
            }
            arrayList.add(Integer.MAX_VALUE);
        }
        int n3 = this.evolveAllFields(complexFormat, evolver);
        if (n3 == 2) {
            return false;
        }
        if (n3 == 1) {
            bl = true;
        }
        if (this.oldToNewKeyMap != null) {
            hashMap.putAll(this.oldToNewKeyMap);
        }
        if (bl && !evolver.checkUpdatedVersion("Changes to the fields or superclass were detected", (Format)this, (Format)complexFormat)) {
            return false;
        }
        if (hashMap.size() > 0 && string2 != null && string != null && this.isCurrentVersion()) {
            for (Map.Entry entry : hashMap.entrySet()) {
                String string3 = (String)entry.getKey();
                object = (String)entry.getValue();
                if (object != null) {
                    evolver.renameSecondaryDatabase(string2, string, string3, (String)object);
                    continue;
                }
                evolver.deleteSecondaryDatabase(string2, string3);
            }
        }
        if (bl2 || bl) {
            iterator = new EvolveReader(arrayList);
            evolver.useEvolvedFormat(this, (Reader)((Object)iterator), complexFormat);
        } else {
            evolver.useOldFormat(this, complexFormat);
        }
        return true;
    }

    @Override
    boolean evolveMetadata(Format format, Converter converter, Evolver evolver) {
        Set<Object> set;
        Object object;
        assert (!this.isDeleted());
        assert (this.isEntity());
        assert (format.isEntity());
        ComplexFormat complexFormat = (ComplexFormat)format;
        if (!this.checkKeyTypeChange(complexFormat, this.entityMeta.getPrimaryKey(), complexFormat.entityMeta.getPrimaryKey(), "primary key", evolver)) {
            return false;
        }
        if (converter instanceof EntityConverter) {
            object = (EntityConverter)converter;
            set = ((EntityConverter)object).getDeletedKeys();
        } else {
            set = Collections.emptySet();
        }
        object = this.entityMeta.getSecondaryKeys();
        Map<String, SecondaryKeyMetadata> map = complexFormat.entityMeta.getSecondaryKeys();
        HashSet<String> hashSet = new HashSet<String>(map.keySet());
        for (SecondaryKeyMetadata secondaryKeyMetadata : object.values()) {
            String string = secondaryKeyMetadata.getKeyName();
            if (set.contains(string)) {
                if (!this.isCurrentVersion()) continue;
                evolver.deleteSecondaryDatabase(this.getClassName(), string);
                continue;
            }
            SecondaryKeyMetadata secondaryKeyMetadata2 = map.get(string);
            if (secondaryKeyMetadata2 == null) {
                evolver.addInvalidMutation(this, complexFormat, converter, "Existing key not found in new entity metadata: " + string);
                return false;
            }
            hashSet.remove(string);
            String string2 = "secondary key: " + string;
            if (!this.checkKeyTypeChange(complexFormat, secondaryKeyMetadata, secondaryKeyMetadata2, string2, evolver)) {
                return false;
            }
            if (this.checkSecKeyMetadata(complexFormat, secondaryKeyMetadata, secondaryKeyMetadata2, evolver)) continue;
            return false;
        }
        if (!hashSet.isEmpty()) {
            evolver.addEvolveError(this, complexFormat, "Error", "New keys " + hashSet + " not allowed when using a Converter with an entity class");
        }
        return true;
    }

    private boolean checkSecKeyMetadata(Format format, SecondaryKeyMetadata secondaryKeyMetadata, SecondaryKeyMetadata secondaryKeyMetadata2, Evolver evolver) {
        if (secondaryKeyMetadata.getRelationship() != secondaryKeyMetadata2.getRelationship()) {
            evolver.addEvolveError(this, format, "Change detected in the relate attribute (Relationship) of a secondary key", "Old key: " + secondaryKeyMetadata.getKeyName() + " relate: " + (Object)((Object)secondaryKeyMetadata.getRelationship()) + " new key: " + secondaryKeyMetadata2.getKeyName() + " relate: " + (Object)((Object)secondaryKeyMetadata2.getRelationship()));
            return false;
        }
        return true;
    }

    private boolean checkKeyTypeChange(Format format, FieldMetadata fieldMetadata, FieldMetadata fieldMetadata2, String string, Evolver evolver) {
        String string2;
        String string3 = fieldMetadata.getClassName();
        if (!string3.equals(string2 = fieldMetadata2.getClassName())) {
            SimpleCatalog simpleCatalog = SimpleCatalog.getInstance();
            Format format2 = simpleCatalog.getFormat(string3);
            Format format3 = simpleCatalog.getFormat(string2);
            if (format2 == null || format3 == null || (format2.getWrapperFormat() == null || format2.getWrapperFormat().getId() != format3.getId()) && (format3.getWrapperFormat() == null || format3.getWrapperFormat().getId() != format2.getId())) {
                evolver.addEvolveError(this, format, "Type change detected for " + string, "Old field type: " + string3 + " is not compatible with the new type: " + string2 + " old field: " + fieldMetadata.getName() + " new field: " + fieldMetadata2.getName());
                return false;
            }
        }
        return true;
    }

    private boolean evolveDeletedClass(Evolver evolver) {
        assert (this.isDeleted());
        if (this.secKeyFieldReader == null || this.nonKeyFieldReader == null) {
            if (this.priKeyField != null && this.getEntityFormat() != null && !this.getEntityFormat().isDeleted()) {
                evolver.addEvolveError(this, this, "Class containing primary key field was deleted ", "Primary key is needed in an entity class hierarchy: " + this.priKeyField.getName());
                return false;
            }
            this.secKeyFieldReader = new SkipFieldReader(0, this.secKeyFields);
            this.nonKeyFieldReader = new SkipFieldReader(0, this.nonKeyFields);
            return true;
        }
        return true;
    }

    private int evolveAllFields(ComplexFormat complexFormat, Evolver evolver) {
        FieldReader fieldReader;
        assert (!this.isDeleted());
        this.secKeyFieldReader = null;
        this.nonKeyFieldReader = null;
        this.oldToNewKeyMap = null;
        boolean bl = false;
        boolean bl2 = false;
        if (this.priKeyField != null) {
            int n = evolver.evolveRequiredKeyField(this, complexFormat, this.priKeyField, complexFormat.priKeyField);
            if (n == 2) {
                bl = true;
            } else if (n == 1) {
                bl2 = true;
            }
        }
        if ((fieldReader = this.evolveFieldList(this.secKeyFields, complexFormat.secKeyFields, true, complexFormat.nonKeyFields, complexFormat, evolver)) == FieldReader.EVOLVE_FAILURE) {
            bl = true;
        } else if (fieldReader != null) {
            bl2 = true;
        }
        if (fieldReader != FieldReader.EVOLVE_NEEDED) {
            this.secKeyFieldReader = fieldReader;
        }
        if ((fieldReader = this.evolveFieldList(this.nonKeyFields, complexFormat.nonKeyFields, false, complexFormat.secKeyFields, complexFormat, evolver)) == FieldReader.EVOLVE_FAILURE) {
            bl = true;
        } else if (fieldReader != null) {
            bl2 = true;
        }
        if (fieldReader != FieldReader.EVOLVE_NEEDED) {
            this.nonKeyFieldReader = fieldReader;
        }
        if (bl) {
            return 2;
        }
        if (bl2) {
            return 1;
        }
        return 0;
    }

    private FieldReader getDoNothingFieldReader() {
        List<FieldReader> list = Collections.emptyList();
        return new MultiFieldReader(list);
    }

    private FieldReader evolveFieldList(List<FieldInfo> list, List<FieldInfo> list2, boolean bl, List<FieldInfo> list3, ComplexFormat complexFormat, Evolver evolver) {
        Mutations mutations = evolver.getMutations();
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = false;
        ArrayList<FieldReader> arrayList = new ArrayList<FieldReader>();
        FieldReader fieldReader = null;
        int n = 0;
        block0: for (int i = 0; i < list.size(); ++i) {
            Serializable serializable;
            Object object;
            Object object2;
            String string;
            FieldInfo fieldInfo = list.get(i);
            String string2 = fieldInfo.getName();
            SecondaryKeyMetadata secondaryKeyMetadata = null;
            if (bl) {
                secondaryKeyMetadata = ComplexFormat.getSecondaryKeyMetadataByFieldName(this.clsMeta.getSecondaryKeys(), string2);
                assert (secondaryKeyMetadata != null);
            }
            Renamer renamer = mutations.getRenamer(this.getClassName(), this.getVersion(), string2);
            Deleter deleter = mutations.getDeleter(this.getClassName(), this.getVersion(), string2);
            Converter converter = mutations.getConverter(this.getClassName(), this.getVersion(), string2);
            if (deleter != null && (converter != null || renamer != null)) {
                evolver.addInvalidMutation(this, complexFormat, deleter, "Field Deleter is not allowed along with a Renamer or Converter for the same field: " + string2);
                bl2 = true;
                continue;
            }
            String string3 = string = renamer != null ? renamer.getNewName() : string2;
            if (!string2.equals(string)) {
                if (this.newToOldFieldMap == null) {
                    this.newToOldFieldMap = new HashMap<String, String>();
                }
                this.newToOldFieldMap.put(string, string2);
            }
            int n2 = FieldInfo.getFieldIndex(list2, string);
            FieldInfo fieldInfo2 = null;
            boolean bl5 = bl;
            if (n2 >= 0) {
                fieldInfo2 = list2.get(n2);
            } else {
                n2 = FieldInfo.getFieldIndex(list3, string);
                if (n2 >= 0) {
                    fieldInfo2 = list3.get(n2);
                    bl5 = !bl;
                }
                bl3 = true;
                bl4 = true;
            }
            if (deleter != null) {
                if (fieldInfo2 != null) {
                    evolver.addInvalidMutation(this, complexFormat, deleter, "Field Deleter is not allowed when the persistent field is still present: " + string2);
                    bl2 = true;
                }
                if (fieldReader instanceof SkipFieldReader && fieldReader.acceptField(i, n2, bl5)) {
                    fieldReader.addField(fieldInfo);
                } else {
                    fieldReader = new SkipFieldReader(i, fieldInfo);
                    arrayList.add(fieldReader);
                    bl4 = true;
                    bl3 = true;
                }
                if (!bl) continue;
                if (this.oldToNewKeyMap == null) {
                    this.oldToNewKeyMap = new HashMap<String, String>();
                }
                this.oldToNewKeyMap.put(secondaryKeyMetadata.getKeyName(), null);
                continue;
            }
            if (fieldInfo2 == null) {
                evolver.addMissingMutation(this, complexFormat, "Field is not present or not persistent: " + string2);
                bl2 = true;
                continue;
            }
            ++n;
            SecondaryKeyMetadata secondaryKeyMetadata2 = null;
            if (bl && bl5) {
                secondaryKeyMetadata2 = ComplexFormat.getSecondaryKeyMetadataByFieldName(complexFormat.clsMeta.getSecondaryKeys(), string);
                assert (secondaryKeyMetadata2 != null);
                if (!this.checkSecKeyMetadata(complexFormat, secondaryKeyMetadata, secondaryKeyMetadata2, evolver)) {
                    bl2 = true;
                    continue;
                }
                String string4 = secondaryKeyMetadata.getKeyName();
                if (!string4.equals(object2 = secondaryKeyMetadata2.getKeyName())) {
                    if (this.oldToNewKeyMap == null) {
                        this.oldToNewKeyMap = new HashMap<String, String>();
                    }
                    this.oldToNewKeyMap.put(string2, string);
                    bl3 = true;
                }
            } else if (bl && !bl5) {
                if (this.oldToNewKeyMap == null) {
                    this.oldToNewKeyMap = new HashMap<String, String>();
                }
                this.oldToNewKeyMap.put(secondaryKeyMetadata.getKeyName(), null);
            }
            if (converter != null) {
                if (bl) {
                    evolver.addInvalidMutation(this, complexFormat, converter, "Field Converter is not allowed for secondary key fields: " + string2);
                    bl2 = true;
                    continue;
                }
                fieldReader = new ConvertFieldReader(converter, i, n2, bl5);
                arrayList.add(fieldReader);
                bl4 = true;
                bl3 = true;
                continue;
            }
            boolean bl6 = true;
            object2 = fieldInfo.getType();
            Format format = ((Format)object2).getLatestVersion();
            while (true) {
                assert (format != null);
                if (!evolver.evolveFormat(format)) {
                    bl2 = true;
                    continue block0;
                }
                if (!format.isNew() && !evolver.isClassConverted(format)) {
                    bl6 = false;
                }
                if ((object = evolver.getSubclassFormats(format)) != null) {
                    Iterator<Format> iterator = object.iterator();
                    while (iterator.hasNext()) {
                        serializable = iterator.next();
                        if (!evolver.evolveFormat((Format)serializable)) {
                            bl2 = true;
                            continue block0;
                        }
                        if (serializable.isNew() || evolver.isClassConverted((Format)serializable)) continue;
                        bl6 = false;
                    }
                }
                if (format == object2) break;
                format = format.getPreviousVersion();
            }
            format = ((Format)object2).getLatestVersion();
            object = fieldInfo2.getType();
            if (!format.getClassName().equals(((Format)object).getClassName()) || format.isDeleted()) {
                if (bl6) {
                    bl3 = true;
                } else {
                    if (WidenerInput.isWideningSupported(format, (Format)object, bl)) {
                        fieldReader = new WidenFieldReader(format, (Format)object, n2, bl5);
                        arrayList.add(fieldReader);
                        bl4 = true;
                        bl3 = true;
                        continue;
                    }
                    boolean bl7 = false;
                    if (!(((Format)object).isPrimitive() || format.isPrimitive() || format.isDeleted() || evolver.isClassConverted(format))) {
                        serializable = format.getExistingType();
                        Class clazz = ((Format)object).getExistingType();
                        if (clazz.isAssignableFrom((Class<?>)serializable)) {
                            bl7 = true;
                        }
                    }
                    if (bl7) {
                        bl3 = true;
                    } else {
                        evolver.addMissingMutation(this, complexFormat, "Old field type: " + format.getClassName() + " is not compatible with the new type: " + ((Format)object).getClassName() + " for field: " + string2);
                        bl2 = true;
                        continue;
                    }
                }
            }
            if (fieldReader instanceof PlainFieldReader && fieldReader.acceptField(i, n2, bl5)) {
                fieldReader.addField(fieldInfo);
                continue;
            }
            fieldReader = new PlainFieldReader(i, n2, bl5);
            arrayList.add(fieldReader);
        }
        if (n < list2.size()) {
            bl3 = true;
            bl4 = true;
        }
        if (bl2) {
            return FieldReader.EVOLVE_FAILURE;
        }
        if (bl4) {
            if (arrayList.size() == 0) {
                return this.getDoNothingFieldReader();
            }
            if (arrayList.size() == 1) {
                return (FieldReader)arrayList.get(0);
            }
            return new MultiFieldReader(arrayList);
        }
        if (bl3) {
            return FieldReader.EVOLVE_NEEDED;
        }
        return null;
    }

    static SecondaryKeyMetadata getSecondaryKeyMetadataByFieldName(Map<String, SecondaryKeyMetadata> map, String string) {
        for (SecondaryKeyMetadata secondaryKeyMetadata : map.values()) {
            if (!secondaryKeyMetadata.getName().equals(string)) continue;
            return secondaryKeyMetadata;
        }
        return null;
    }

    private static class EvolveReader
    implements Reader {
        static final int DO_NOT_READ_ACCESSOR = Integer.MAX_VALUE;
        private static final long serialVersionUID = -1016140948306913283L;
        private transient ComplexFormat newFormat;
        private transient ComplexFormat[] oldHierarchy;
        private int[] newHierarchyLevels;

        EvolveReader(List<Integer> list) {
            int n = list.size();
            this.newHierarchyLevels = new int[n];
            list.toArray();
            for (int i = 0; i < n; ++i) {
                this.newHierarchyLevels[i] = list.get(i);
            }
        }

        @Override
        public void initializeReader(Catalog catalog, EntityModel entityModel, int n, Format format) {
            Object object;
            ComplexFormat complexFormat = (ComplexFormat)format;
            this.newFormat = complexFormat.getComplexLatest();
            this.newFormat.initializeIfNeeded(catalog, entityModel);
            int n2 = 0;
            for (object = this.newFormat; object != null; object = object.getSuperFormat()) {
                ++n2;
            }
            object = new ComplexFormat[n2];
            int n3 = 0;
            for (ComplexFormat complexFormat2 = this.newFormat; complexFormat2 != null; complexFormat2 = complexFormat2.getComplexSuper()) {
                object[n3] = complexFormat2;
                ++n3;
            }
            assert (n3 == n2);
            int n4 = this.newHierarchyLevels.length;
            this.oldHierarchy = new ComplexFormat[n4];
            n3 = 0;
            for (ComplexFormat complexFormat3 = complexFormat; complexFormat3 != null; complexFormat3 = complexFormat3.getComplexSuper()) {
                this.oldHierarchy[n3] = complexFormat3;
                int n5 = this.newHierarchyLevels[n3];
                ComplexFormat complexFormat4 = n5 != Integer.MAX_VALUE ? object[n5] : null;
                ++n3;
                if (complexFormat3.secKeyFieldReader != null) {
                    complexFormat3.secKeyFieldReader.initialize(catalog, n, complexFormat3, complexFormat4, true);
                }
                if (complexFormat3.nonKeyFieldReader == null) continue;
                complexFormat3.nonKeyFieldReader.initialize(catalog, n, complexFormat3, complexFormat4, false);
            }
            assert (n3 == n4);
        }

        @Override
        public Object newInstance(EntityInput entityInput, boolean bl) {
            return this.newFormat.newInstance(entityInput, bl);
        }

        @Override
        public void readPriKey(Object object, EntityInput entityInput, boolean bl) {
            this.newFormat.readPriKey(object, entityInput, bl);
        }

        @Override
        public Object readObject(Object object, EntityInput entityInput, boolean bl) {
            int n;
            FieldReader fieldReader;
            int n2;
            int n3;
            Accessor accessor = bl ? this.newFormat.rawAccessor : this.newFormat.objAccessor;
            for (n3 = n2 = this.oldHierarchy.length - 1; n3 >= 0; --n3) {
                fieldReader = this.oldHierarchy[n3].secKeyFieldReader;
                n = this.newHierarchyLevels[n3];
                if (fieldReader != null) {
                    fieldReader.readFields(object, entityInput, accessor, n);
                    continue;
                }
                if (n == Integer.MAX_VALUE) continue;
                accessor.readSecKeyFields(object, entityInput, 0, 0x7FFFFFFE, n);
            }
            for (n3 = n2; n3 >= 0; --n3) {
                fieldReader = this.oldHierarchy[n3].nonKeyFieldReader;
                n = this.newHierarchyLevels[n3];
                if (fieldReader != null) {
                    fieldReader.readFields(object, entityInput, accessor, n);
                    continue;
                }
                if (n == Integer.MAX_VALUE) continue;
                accessor.readNonKeyFields(object, entityInput, 0, 0x7FFFFFFE, n);
            }
            return object;
        }
    }

    private static class MultiFieldReader
    extends FieldReader {
        private static final long serialVersionUID = -6035976787562441473L;
        private List<FieldReader> subReaders;

        MultiFieldReader(List<FieldReader> list) {
            this.subReaders = list;
        }

        @Override
        void initialize(Catalog catalog, int n, ComplexFormat complexFormat, ComplexFormat complexFormat2, boolean bl) {
            for (FieldReader fieldReader : this.subReaders) {
                fieldReader.initialize(catalog, n, complexFormat, complexFormat2, bl);
            }
        }

        @Override
        final void readFields(Object object, EntityInput entityInput, Accessor accessor, int n) {
            for (FieldReader fieldReader : this.subReaders) {
                fieldReader.readFields(object, entityInput, accessor, n);
            }
        }
    }

    private static class WidenFieldReader
    extends FieldReader {
        private static final long serialVersionUID = -2054520670170407282L;
        private int fromFormatId;
        private int toFormatId;
        private int fieldNum;
        private boolean secKeyField;

        WidenFieldReader(Format format, Format format2, int n, boolean bl) {
            this.fromFormatId = format.getId();
            this.toFormatId = format2.getId();
            this.fieldNum = n;
            this.secKeyField = bl;
        }

        @Override
        final void readFields(Object object, EntityInput entityInput, Accessor accessor, int n) {
            WidenerInput widenerInput = new WidenerInput(entityInput, this.fromFormatId, this.toFormatId);
            if (this.secKeyField) {
                accessor.readSecKeyFields(object, widenerInput, this.fieldNum, this.fieldNum, n);
            } else {
                accessor.readNonKeyFields(object, widenerInput, this.fieldNum, this.fieldNum, n);
            }
        }
    }

    private static class ConvertFieldReader
    extends FieldReader {
        private static final long serialVersionUID = 8736410481633998710L;
        private Converter converter;
        private int oldFieldNum;
        private int fieldNum;
        private boolean secKeyField;
        private transient Format oldFormat;
        private transient Format newFormat;

        ConvertFieldReader(Converter converter, int n, int n2, boolean bl) {
            this.converter = converter;
            this.oldFieldNum = n;
            this.fieldNum = n2;
            this.secKeyField = bl;
        }

        @Override
        void initialize(Catalog catalog, int n, ComplexFormat complexFormat, ComplexFormat complexFormat2, boolean bl) {
            if (n < 1) {
                this.oldFieldNum = this.fieldNum;
            }
            this.oldFormat = bl ? ((FieldInfo)complexFormat.secKeyFields.get(this.oldFieldNum)).getType() : ((FieldInfo)complexFormat.nonKeyFields.get(this.oldFieldNum)).getType();
            this.newFormat = this.secKeyField ? ((FieldInfo)complexFormat2.secKeyFields.get(this.fieldNum)).getType() : ((FieldInfo)complexFormat2.nonKeyFields.get(this.fieldNum)).getType();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        final void readFields(Object object, EntityInput entityInput, Accessor accessor, int n) {
            Object object2;
            boolean bl = entityInput.setRawAccess(true);
            try {
                object2 = this.oldFormat.isPrimitive() ? entityInput.readKeyObject(this.oldFormat) : entityInput.readObject();
            }
            finally {
                entityInput.setRawAccess(bl);
            }
            Catalog catalog = entityInput.getCatalog();
            object2 = this.converter.getConversion().convert(object2);
            RawSingleInput rawSingleInput = new RawSingleInput(catalog, bl, null, object2, this.newFormat);
            if (this.secKeyField) {
                accessor.readSecKeyFields(object, rawSingleInput, this.fieldNum, this.fieldNum, n);
            } else {
                accessor.readNonKeyFields(object, rawSingleInput, this.fieldNum, this.fieldNum, n);
            }
        }
    }

    private static class SkipFieldReader
    extends FieldReader {
        private static final long serialVersionUID = -3060281692155253098L;
        private List<Format> fieldFormats;
        private transient int endField;

        SkipFieldReader(int n, List<FieldInfo> list) {
            this.endField = n + list.size() - 1;
            this.fieldFormats = new ArrayList<Format>(list.size());
            for (FieldInfo fieldInfo : list) {
                this.fieldFormats.add(fieldInfo.getType());
            }
        }

        SkipFieldReader(int n, FieldInfo fieldInfo) {
            this.endField = n;
            this.fieldFormats = new ArrayList<Format>();
            this.fieldFormats.add(fieldInfo.getType());
        }

        @Override
        boolean acceptField(int n, int n2, boolean bl) {
            return n == this.endField + 1;
        }

        @Override
        void addField(FieldInfo fieldInfo) {
            ++this.endField;
            this.fieldFormats.add(fieldInfo.getType());
        }

        @Override
        final void readFields(Object object, EntityInput entityInput, Accessor accessor, int n) {
            for (Format format : this.fieldFormats) {
                entityInput.skipField(format);
            }
        }
    }

    private static class PlainFieldReader
    extends FieldReader {
        private static final long serialVersionUID = 1795593463439931402L;
        private int startField;
        private int endField;
        private boolean secKeyField;
        private transient int endOldField;

        PlainFieldReader(int n, int n2, boolean bl) {
            this.endOldField = n;
            this.startField = n2;
            this.endField = n2;
            this.secKeyField = bl;
        }

        @Override
        boolean acceptField(int n, int n2, boolean bl) {
            return n == this.endOldField + 1 && n2 == this.endField + 1 && this.secKeyField == bl;
        }

        @Override
        void addField(FieldInfo fieldInfo) {
            ++this.endField;
            ++this.endOldField;
        }

        @Override
        final void readFields(Object object, EntityInput entityInput, Accessor accessor, int n) {
            if (this.secKeyField) {
                accessor.readSecKeyFields(object, entityInput, this.startField, this.endField, n);
            } else {
                accessor.readNonKeyFields(object, entityInput, this.startField, this.endField, n);
            }
        }
    }

    private static abstract class FieldReader
    implements Serializable {
        static final FieldReader EVOLVE_NEEDED = new PlainFieldReader(0, 0, false);
        static final FieldReader EVOLVE_FAILURE = new PlainFieldReader(0, 0, false);
        private static final long serialVersionUID = 866041475399255164L;

        FieldReader() {
        }

        void initialize(Catalog catalog, int n, ComplexFormat complexFormat, ComplexFormat complexFormat2, boolean bl) {
        }

        boolean acceptField(int n, int n2, boolean bl) {
            return false;
        }

        void addField(FieldInfo fieldInfo) {
            throw new UnsupportedOperationException();
        }

        abstract void readFields(Object var1, EntityInput var2, Accessor var3, int var4);
    }

    private static class FieldAddress {
        boolean isSecField;
        int fieldNum;
        int superLevel;
        ComplexFormat clsFormat;
        Format keyFormat;

        FieldAddress(boolean bl, int n, int n2, ComplexFormat complexFormat, Format format) {
            this.isSecField = bl;
            this.fieldNum = n;
            this.superLevel = n2;
            this.clsFormat = complexFormat;
            this.keyFormat = format;
        }
    }
}

