/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.asm;

import com.sleepycat.asm.AnnotationVisitor;
import com.sleepycat.asm.AnnotationWriter;
import com.sleepycat.asm.Attribute;
import com.sleepycat.asm.ByteVector;
import com.sleepycat.asm.ClassWriter;
import com.sleepycat.asm.Edge;
import com.sleepycat.asm.Handler;
import com.sleepycat.asm.Item;
import com.sleepycat.asm.Label;
import com.sleepycat.asm.MethodVisitor;
import com.sleepycat.asm.Type;

class MethodWriter
implements MethodVisitor {
    MethodWriter next;
    ClassWriter cw;
    private int access;
    private int name;
    private int desc;
    private String descriptor;
    int classReaderOffset;
    int classReaderLength;
    String signature;
    int exceptionCount;
    int[] exceptions;
    private ByteVector annd;
    private AnnotationWriter anns;
    private AnnotationWriter ianns;
    private AnnotationWriter[] panns;
    private AnnotationWriter[] ipanns;
    private Attribute attrs;
    private ByteVector code = new ByteVector();
    private int maxStack;
    private int maxLocals;
    private int catchCount;
    private Handler catchTable;
    private Handler lastHandler;
    private int localVarCount;
    private ByteVector localVar;
    private int localVarTypeCount;
    private ByteVector localVarType;
    private int lineNumberCount;
    private ByteVector lineNumber;
    private Attribute cattrs;
    private boolean resize;
    private final boolean computeMaxs;
    private int stackSize;
    private int maxStackSize;
    private Label currentBlock;
    private Label blockStack;
    private static final int[] SIZE;

    MethodWriter(ClassWriter classWriter, int n, String string, String string2, String string3, String[] stringArray, boolean bl) {
        int n2;
        if (classWriter.firstMethod == null) {
            classWriter.firstMethod = this;
        } else {
            classWriter.lastMethod.next = this;
        }
        classWriter.lastMethod = this;
        this.cw = classWriter;
        this.access = n;
        this.name = classWriter.newUTF8(string);
        this.desc = classWriter.newUTF8(string2);
        this.descriptor = string2;
        this.signature = string3;
        if (stringArray != null && stringArray.length > 0) {
            this.exceptionCount = stringArray.length;
            this.exceptions = new int[this.exceptionCount];
            for (n2 = 0; n2 < this.exceptionCount; ++n2) {
                this.exceptions[n2] = classWriter.newClass(stringArray[n2]);
            }
        }
        this.computeMaxs = bl;
        if (bl) {
            n2 = MethodWriter.getArgumentsAndReturnSizes(string2) >> 2;
            if ((n & 8) != 0) {
                --n2;
            }
            this.maxLocals = n2;
            this.currentBlock = new Label();
            this.currentBlock.pushed = true;
            this.blockStack = this.currentBlock;
        }
    }

    @Override
    public AnnotationVisitor visitAnnotationDefault() {
        this.annd = new ByteVector();
        return new AnnotationWriter(this.cw, false, this.annd, null, 0);
    }

    @Override
    public AnnotationVisitor visitAnnotation(String string, boolean bl) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(this.cw.newUTF8(string)).putShort(0);
        AnnotationWriter annotationWriter = new AnnotationWriter(this.cw, true, byteVector, byteVector, 2);
        if (bl) {
            annotationWriter.next = this.anns;
            this.anns = annotationWriter;
        } else {
            annotationWriter.next = this.ianns;
            this.ianns = annotationWriter;
        }
        return annotationWriter;
    }

    @Override
    public AnnotationVisitor visitParameterAnnotation(int n, String string, boolean bl) {
        ByteVector byteVector = new ByteVector();
        byteVector.putShort(this.cw.newUTF8(string)).putShort(0);
        AnnotationWriter annotationWriter = new AnnotationWriter(this.cw, true, byteVector, byteVector, 2);
        if (bl) {
            if (this.panns == null) {
                this.panns = new AnnotationWriter[Type.getArgumentTypes(this.descriptor).length];
            }
            annotationWriter.next = this.panns[n];
            this.panns[n] = annotationWriter;
        } else {
            if (this.ipanns == null) {
                this.ipanns = new AnnotationWriter[Type.getArgumentTypes(this.descriptor).length];
            }
            annotationWriter.next = this.ipanns[n];
            this.ipanns[n] = annotationWriter;
        }
        return annotationWriter;
    }

    @Override
    public void visitAttribute(Attribute attribute) {
        if (attribute.isCodeAttribute()) {
            attribute.next = this.cattrs;
            this.cattrs = attribute;
        } else {
            attribute.next = this.attrs;
            this.attrs = attribute;
        }
    }

    @Override
    public void visitCode() {
    }

    @Override
    public void visitInsn(int n) {
        if (this.computeMaxs) {
            int n2 = this.stackSize + SIZE[n];
            if (n2 > this.maxStackSize) {
                this.maxStackSize = n2;
            }
            this.stackSize = n2;
            if ((n >= 172 && n <= 177 || n == 191) && this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.currentBlock = null;
            }
        }
        this.code.putByte(n);
    }

    @Override
    public void visitIntInsn(int n, int n2) {
        if (this.computeMaxs && n != 188) {
            int n3 = this.stackSize + 1;
            if (n3 > this.maxStackSize) {
                this.maxStackSize = n3;
            }
            this.stackSize = n3;
        }
        if (n == 17) {
            this.code.put12(n, n2);
        } else {
            this.code.put11(n, n2);
        }
    }

    @Override
    public void visitVarInsn(int n, int n2) {
        int n3;
        if (this.computeMaxs) {
            if (n == 169) {
                if (this.currentBlock != null) {
                    this.currentBlock.maxStackSize = this.maxStackSize;
                    this.currentBlock = null;
                }
            } else {
                n3 = this.stackSize + SIZE[n];
                if (n3 > this.maxStackSize) {
                    this.maxStackSize = n3;
                }
                this.stackSize = n3;
            }
            if ((n3 = n == 22 || n == 24 || n == 55 || n == 57 ? n2 + 2 : n2 + 1) > this.maxLocals) {
                this.maxLocals = n3;
            }
        }
        if (n2 < 4 && n != 169) {
            n3 = n < 54 ? 26 + (n - 21 << 2) + n2 : 59 + (n - 54 << 2) + n2;
            this.code.putByte(n3);
        } else if (n2 >= 256) {
            this.code.putByte(196).put12(n, n2);
        } else {
            this.code.put11(n, n2);
        }
    }

    @Override
    public void visitTypeInsn(int n, String string) {
        if (this.computeMaxs && n == 187) {
            int n2 = this.stackSize + 1;
            if (n2 > this.maxStackSize) {
                this.maxStackSize = n2;
            }
            this.stackSize = n2;
        }
        this.code.put12(n, this.cw.newClass(string));
    }

    @Override
    public void visitFieldInsn(int n, String string, String string2, String string3) {
        if (this.computeMaxs) {
            int n2;
            char c = string3.charAt(0);
            switch (n) {
                case 178: {
                    n2 = this.stackSize + (c == 'D' || c == 'J' ? 2 : 1);
                    break;
                }
                case 179: {
                    n2 = this.stackSize + (c == 'D' || c == 'J' ? -2 : -1);
                    break;
                }
                case 180: {
                    n2 = this.stackSize + (c == 'D' || c == 'J' ? 1 : 0);
                    break;
                }
                default: {
                    n2 = this.stackSize + (c == 'D' || c == 'J' ? -3 : -2);
                }
            }
            if (n2 > this.maxStackSize) {
                this.maxStackSize = n2;
            }
            this.stackSize = n2;
        }
        this.code.put12(n, this.cw.newField(string, string2, string3));
    }

    @Override
    public void visitMethodInsn(int n, String string, String string2, String string3) {
        boolean bl = n == 185;
        Item item = this.cw.newMethodItem(string, string2, string3, bl);
        int n2 = item.intVal;
        if (this.computeMaxs) {
            int n3;
            if (n2 == 0) {
                item.intVal = n2 = MethodWriter.getArgumentsAndReturnSizes(string3);
            }
            if ((n3 = n == 184 ? this.stackSize - (n2 >> 2) + (n2 & 3) + 1 : this.stackSize - (n2 >> 2) + (n2 & 3)) > this.maxStackSize) {
                this.maxStackSize = n3;
            }
            this.stackSize = n3;
        }
        if (bl) {
            if (!this.computeMaxs && n2 == 0) {
                item.intVal = n2 = MethodWriter.getArgumentsAndReturnSizes(string3);
            }
            this.code.put12(185, item.index).put11(n2 >> 2, 0);
        } else {
            this.code.put12(n, item.index);
        }
    }

    @Override
    public void visitJumpInsn(int n, Label label) {
        if (this.computeMaxs) {
            if (n == 167) {
                if (this.currentBlock != null) {
                    this.currentBlock.maxStackSize = this.maxStackSize;
                    this.addSuccessor(this.stackSize, label);
                    this.currentBlock = null;
                }
            } else if (n == 168) {
                if (this.currentBlock != null) {
                    this.addSuccessor(this.stackSize + 1, label);
                }
            } else {
                this.stackSize += SIZE[n];
                if (this.currentBlock != null) {
                    this.addSuccessor(this.stackSize, label);
                }
            }
        }
        if (label.resolved && label.position - this.code.length < Short.MIN_VALUE) {
            if (n == 167) {
                this.code.putByte(200);
            } else if (n == 168) {
                this.code.putByte(201);
            } else {
                this.code.putByte(n <= 166 ? (n + 1 ^ 1) - 1 : n ^ 1);
                this.code.putShort(8);
                this.code.putByte(200);
            }
            label.put(this, this.code, this.code.length - 1, true);
        } else {
            this.code.putByte(n);
            label.put(this, this.code, this.code.length - 1, false);
        }
    }

    @Override
    public void visitLabel(Label label) {
        if (this.computeMaxs) {
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
            }
            this.currentBlock = label;
            this.stackSize = 0;
            this.maxStackSize = 0;
        }
        this.resize |= label.resolve(this, this.code.length, this.code.data);
    }

    @Override
    public void visitLdcInsn(Object object) {
        int n;
        Item item = this.cw.newConstItem(object);
        if (this.computeMaxs) {
            n = item.type == 5 || item.type == 6 ? this.stackSize + 2 : this.stackSize + 1;
            if (n > this.maxStackSize) {
                this.maxStackSize = n;
            }
            this.stackSize = n;
        }
        n = item.index;
        if (item.type == 5 || item.type == 6) {
            this.code.put12(20, n);
        } else if (n >= 256) {
            this.code.put12(19, n);
        } else {
            this.code.put11(18, n);
        }
    }

    @Override
    public void visitIincInsn(int n, int n2) {
        int n3;
        if (this.computeMaxs && (n3 = n + 1) > this.maxLocals) {
            this.maxLocals = n3;
        }
        if (n > 255 || n2 > 127 || n2 < -128) {
            this.code.putByte(196).put12(132, n).putShort(n2);
        } else {
            this.code.putByte(132).put11(n, n2);
        }
    }

    @Override
    public void visitTableSwitchInsn(int n, int n2, Label label, Label[] labelArray) {
        int n3;
        if (this.computeMaxs) {
            --this.stackSize;
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
                for (n3 = 0; n3 < labelArray.length; ++n3) {
                    this.addSuccessor(this.stackSize, labelArray[n3]);
                }
                this.currentBlock = null;
            }
        }
        n3 = this.code.length;
        this.code.putByte(170);
        while (this.code.length % 4 != 0) {
            this.code.putByte(0);
        }
        label.put(this, this.code, n3, true);
        this.code.putInt(n).putInt(n2);
        for (int i = 0; i < labelArray.length; ++i) {
            labelArray[i].put(this, this.code, n3, true);
        }
    }

    @Override
    public void visitLookupSwitchInsn(Label label, int[] nArray, Label[] labelArray) {
        int n;
        if (this.computeMaxs) {
            --this.stackSize;
            if (this.currentBlock != null) {
                this.currentBlock.maxStackSize = this.maxStackSize;
                this.addSuccessor(this.stackSize, label);
                for (n = 0; n < labelArray.length; ++n) {
                    this.addSuccessor(this.stackSize, labelArray[n]);
                }
                this.currentBlock = null;
            }
        }
        n = this.code.length;
        this.code.putByte(171);
        while (this.code.length % 4 != 0) {
            this.code.putByte(0);
        }
        label.put(this, this.code, n, true);
        this.code.putInt(labelArray.length);
        for (int i = 0; i < labelArray.length; ++i) {
            this.code.putInt(nArray[i]);
            labelArray[i].put(this, this.code, n, true);
        }
    }

    @Override
    public void visitMultiANewArrayInsn(String string, int n) {
        if (this.computeMaxs) {
            this.stackSize += 1 - n;
        }
        this.code.put12(197, this.cw.newClass(string)).putByte(n);
    }

    @Override
    public void visitTryCatchBlock(Label label, Label label2, Label label3, String string) {
        if (this.computeMaxs && !label3.pushed) {
            label3.beginStackSize = 1;
            label3.pushed = true;
            label3.next = this.blockStack;
            this.blockStack = label3;
        }
        ++this.catchCount;
        Handler handler = new Handler();
        handler.start = label;
        handler.end = label2;
        handler.handler = label3;
        handler.desc = string;
        int n = handler.type = string != null ? this.cw.newClass(string) : 0;
        if (this.lastHandler == null) {
            this.catchTable = handler;
        } else {
            this.lastHandler.next = handler;
        }
        this.lastHandler = handler;
    }

    @Override
    public void visitLocalVariable(String string, String string2, String string3, Label label, Label label2, int n) {
        if (string3 != null) {
            if (this.localVarType == null) {
                this.localVarType = new ByteVector();
            }
            ++this.localVarTypeCount;
            this.localVarType.putShort(label.position).putShort(label2.position - label.position).putShort(this.cw.newUTF8(string)).putShort(this.cw.newUTF8(string3)).putShort(n);
        }
        if (this.localVar == null) {
            this.localVar = new ByteVector();
        }
        ++this.localVarCount;
        this.localVar.putShort(label.position).putShort(label2.position - label.position).putShort(this.cw.newUTF8(string)).putShort(this.cw.newUTF8(string2)).putShort(n);
    }

    @Override
    public void visitLineNumber(int n, Label label) {
        if (this.lineNumber == null) {
            this.lineNumber = new ByteVector();
        }
        ++this.lineNumberCount;
        this.lineNumber.putShort(label.position);
        this.lineNumber.putShort(n);
    }

    @Override
    public void visitMaxs(int n, int n2) {
        if (this.computeMaxs) {
            int n3 = 0;
            Label label = this.blockStack;
            while (label != null) {
                Label label2 = label;
                label = label.next;
                int n4 = label2.beginStackSize;
                int n5 = n4 + label2.maxStackSize;
                if (n5 > n3) {
                    n3 = n5;
                }
                Edge edge = label2.successors;
                while (edge != null) {
                    label2 = edge.successor;
                    if (!label2.pushed) {
                        label2.beginStackSize = n4 + edge.stackSize;
                        label2.pushed = true;
                        label2.next = label;
                        label = label2;
                    }
                    edge = edge.next;
                }
            }
            this.maxStack = n3;
        } else {
            this.maxStack = n;
            this.maxLocals = n2;
        }
    }

    @Override
    public void visitEnd() {
    }

    private static int getArgumentsAndReturnSizes(String string) {
        int n = 1;
        int n2 = 1;
        while (true) {
            char c;
            if ((c = string.charAt(n2++)) == ')') {
                c = string.charAt(n2);
                return n << 2 | (c == 'V' ? 0 : (c == 'D' || c == 'J' ? 2 : 1));
            }
            if (c == 'L') {
                while (string.charAt(n2++) != ';') {
                }
                ++n;
                continue;
            }
            if (c == '[') {
                while ((c = string.charAt(n2)) == '[') {
                    ++n2;
                }
                if (c != 'D' && c != 'J') continue;
                --n;
                continue;
            }
            if (c == 'D' || c == 'J') {
                n += 2;
                continue;
            }
            ++n;
        }
    }

    private void addSuccessor(int n, Label label) {
        Edge edge = new Edge();
        edge.stackSize = n;
        edge.successor = label;
        edge.next = this.currentBlock.successors;
        this.currentBlock.successors = edge;
    }

    final int getSize() {
        int n;
        if (this.classReaderOffset != 0) {
            return 6 + this.classReaderLength;
        }
        if (this.resize) {
            this.resizeInstructions(new int[0], new int[0], 0);
        }
        int n2 = 8;
        if (this.code.length > 0) {
            this.cw.newUTF8("Code");
            n2 += 18 + this.code.length + 8 * this.catchCount;
            if (this.localVar != null) {
                this.cw.newUTF8("LocalVariableTable");
                n2 += 8 + this.localVar.length;
            }
            if (this.localVarType != null) {
                this.cw.newUTF8("LocalVariableTypeTable");
                n2 += 8 + this.localVarType.length;
            }
            if (this.lineNumber != null) {
                this.cw.newUTF8("LineNumberTable");
                n2 += 8 + this.lineNumber.length;
            }
            if (this.cattrs != null) {
                n2 += this.cattrs.getSize(this.cw, this.code.data, this.code.length, this.maxStack, this.maxLocals);
            }
        }
        if (this.exceptionCount > 0) {
            this.cw.newUTF8("Exceptions");
            n2 += 8 + 2 * this.exceptionCount;
        }
        if ((this.access & 0x1000) != 0 && (this.cw.version & 0xFFFF) < 49) {
            this.cw.newUTF8("Synthetic");
            n2 += 6;
        }
        if ((this.access & 0x20000) != 0) {
            this.cw.newUTF8("Deprecated");
            n2 += 6;
        }
        if (this.cw.version == 48) {
            if ((this.access & 0x80) != 0) {
                this.cw.newUTF8("Varargs");
                n2 += 6;
            }
            if ((this.access & 0x40) != 0) {
                this.cw.newUTF8("Bridge");
                n2 += 6;
            }
        }
        if (this.signature != null) {
            this.cw.newUTF8("Signature");
            this.cw.newUTF8(this.signature);
            n2 += 8;
        }
        if (this.annd != null) {
            this.cw.newUTF8("AnnotationDefault");
            n2 += 6 + this.annd.length;
        }
        if (this.anns != null) {
            this.cw.newUTF8("RuntimeVisibleAnnotations");
            n2 += 8 + this.anns.getSize();
        }
        if (this.ianns != null) {
            this.cw.newUTF8("RuntimeInvisibleAnnotations");
            n2 += 8 + this.ianns.getSize();
        }
        if (this.panns != null) {
            this.cw.newUTF8("RuntimeVisibleParameterAnnotations");
            n2 += 7 + 2 * this.panns.length;
            for (n = this.panns.length - 1; n >= 0; --n) {
                n2 += this.panns[n] == null ? 0 : this.panns[n].getSize();
            }
        }
        if (this.ipanns != null) {
            this.cw.newUTF8("RuntimeInvisibleParameterAnnotations");
            n2 += 7 + 2 * this.ipanns.length;
            for (n = this.ipanns.length - 1; n >= 0; --n) {
                n2 += this.ipanns[n] == null ? 0 : this.ipanns[n].getSize();
            }
        }
        if (this.attrs != null) {
            n2 += this.attrs.getSize(this.cw, null, 0, -1, -1);
        }
        return n2;
    }

    final void put(ByteVector byteVector) {
        int n;
        byteVector.putShort(this.access).putShort(this.name).putShort(this.desc);
        if (this.classReaderOffset != 0) {
            byteVector.putByteArray(this.cw.cr.b, this.classReaderOffset, this.classReaderLength);
            return;
        }
        int n2 = 0;
        if (this.code.length > 0) {
            ++n2;
        }
        if (this.exceptionCount > 0) {
            ++n2;
        }
        if ((this.access & 0x1000) != 0 && (this.cw.version & 0xFFFF) < 49) {
            ++n2;
        }
        if ((this.access & 0x20000) != 0) {
            ++n2;
        }
        if (this.cw.version == 48) {
            if ((this.access & 0x80) != 0) {
                ++n2;
            }
            if ((this.access & 0x40) != 0) {
                ++n2;
            }
        }
        if (this.signature != null) {
            ++n2;
        }
        if (this.annd != null) {
            ++n2;
        }
        if (this.anns != null) {
            ++n2;
        }
        if (this.ianns != null) {
            ++n2;
        }
        if (this.panns != null) {
            ++n2;
        }
        if (this.ipanns != null) {
            ++n2;
        }
        if (this.attrs != null) {
            n2 += this.attrs.getCount();
        }
        byteVector.putShort(n2);
        if (this.code.length > 0) {
            n = 12 + this.code.length + 8 * this.catchCount;
            if (this.localVar != null) {
                n += 8 + this.localVar.length;
            }
            if (this.localVarType != null) {
                n += 8 + this.localVarType.length;
            }
            if (this.lineNumber != null) {
                n += 8 + this.lineNumber.length;
            }
            if (this.cattrs != null) {
                n += this.cattrs.getSize(this.cw, this.code.data, this.code.length, this.maxStack, this.maxLocals);
            }
            byteVector.putShort(this.cw.newUTF8("Code")).putInt(n);
            byteVector.putShort(this.maxStack).putShort(this.maxLocals);
            byteVector.putInt(this.code.length).putByteArray(this.code.data, 0, this.code.length);
            byteVector.putShort(this.catchCount);
            if (this.catchCount > 0) {
                Handler handler = this.catchTable;
                while (handler != null) {
                    byteVector.putShort(handler.start.position).putShort(handler.end.position).putShort(handler.handler.position).putShort(handler.type);
                    handler = handler.next;
                }
            }
            n2 = 0;
            if (this.localVar != null) {
                ++n2;
            }
            if (this.localVarType != null) {
                ++n2;
            }
            if (this.lineNumber != null) {
                ++n2;
            }
            if (this.cattrs != null) {
                n2 += this.cattrs.getCount();
            }
            byteVector.putShort(n2);
            if (this.localVar != null) {
                byteVector.putShort(this.cw.newUTF8("LocalVariableTable"));
                byteVector.putInt(this.localVar.length + 2).putShort(this.localVarCount);
                byteVector.putByteArray(this.localVar.data, 0, this.localVar.length);
            }
            if (this.localVarType != null) {
                byteVector.putShort(this.cw.newUTF8("LocalVariableTypeTable"));
                byteVector.putInt(this.localVarType.length + 2).putShort(this.localVarTypeCount);
                byteVector.putByteArray(this.localVarType.data, 0, this.localVarType.length);
            }
            if (this.lineNumber != null) {
                byteVector.putShort(this.cw.newUTF8("LineNumberTable"));
                byteVector.putInt(this.lineNumber.length + 2).putShort(this.lineNumberCount);
                byteVector.putByteArray(this.lineNumber.data, 0, this.lineNumber.length);
            }
            if (this.cattrs != null) {
                this.cattrs.put(this.cw, this.code.data, this.code.length, this.maxLocals, this.maxStack, byteVector);
            }
        }
        if (this.exceptionCount > 0) {
            byteVector.putShort(this.cw.newUTF8("Exceptions")).putInt(2 * this.exceptionCount + 2);
            byteVector.putShort(this.exceptionCount);
            for (n = 0; n < this.exceptionCount; ++n) {
                byteVector.putShort(this.exceptions[n]);
            }
        }
        if ((this.access & 0x1000) != 0 && (this.cw.version & 0xFFFF) < 49) {
            byteVector.putShort(this.cw.newUTF8("Synthetic")).putInt(0);
        }
        if ((this.access & 0x20000) != 0) {
            byteVector.putShort(this.cw.newUTF8("Deprecated")).putInt(0);
        }
        if (this.cw.version == 48) {
            if ((this.access & 0x80) != 0) {
                byteVector.putShort(this.cw.newUTF8("Varargs")).putInt(0);
            }
            if ((this.access & 0x40) != 0) {
                byteVector.putShort(this.cw.newUTF8("Bridge")).putInt(0);
            }
        }
        if (this.signature != null) {
            byteVector.putShort(this.cw.newUTF8("Signature")).putInt(2).putShort(this.cw.newUTF8(this.signature));
        }
        if (this.annd != null) {
            byteVector.putShort(this.cw.newUTF8("AnnotationDefault"));
            byteVector.putInt(this.annd.length);
            byteVector.putByteArray(this.annd.data, 0, this.annd.length);
        }
        if (this.anns != null) {
            byteVector.putShort(this.cw.newUTF8("RuntimeVisibleAnnotations"));
            this.anns.put(byteVector);
        }
        if (this.ianns != null) {
            byteVector.putShort(this.cw.newUTF8("RuntimeInvisibleAnnotations"));
            this.ianns.put(byteVector);
        }
        if (this.panns != null) {
            byteVector.putShort(this.cw.newUTF8("RuntimeVisibleParameterAnnotations"));
            AnnotationWriter.put(this.panns, byteVector);
        }
        if (this.ipanns != null) {
            byteVector.putShort(this.cw.newUTF8("RuntimeInvisibleParameterAnnotations"));
            AnnotationWriter.put(this.ipanns, byteVector);
        }
        if (this.attrs != null) {
            this.attrs.put(this.cw, null, 0, -1, -1, byteVector);
        }
    }

    private int[] resizeInstructions(int[] nArray, int[] nArray2, int n) {
        int n2;
        Object object;
        int n3;
        int n4;
        int n5;
        int n6;
        byte[] byArray = this.code.data;
        int[] nArray3 = new int[n];
        int[] nArray4 = new int[n];
        System.arraycopy(nArray, 0, nArray3, 0, n);
        System.arraycopy(nArray2, 0, nArray4, 0, n);
        boolean[] blArray = new boolean[this.code.length];
        int n7 = 3;
        do {
            if (n7 == 3) {
                n7 = 2;
            }
            n6 = 0;
            while (n6 < byArray.length) {
                int n8 = byArray[n6] & 0xFF;
                n5 = 0;
                switch (ClassWriter.TYPE[n8]) {
                    case 0: 
                    case 4: {
                        ++n6;
                        break;
                    }
                    case 8: {
                        if (n8 > 201) {
                            n8 = n8 < 218 ? n8 - 49 : n8 - 20;
                            n4 = n6 + MethodWriter.readUnsignedShort(byArray, n6 + 1);
                        } else {
                            n4 = n6 + MethodWriter.readShort(byArray, n6 + 1);
                        }
                        n3 = MethodWriter.getNewOffset(nArray3, nArray4, n6, n4);
                        if (!(n3 >= Short.MIN_VALUE && n3 <= Short.MAX_VALUE || blArray[n6])) {
                            n5 = n8 == 167 || n8 == 168 ? 2 : 5;
                            blArray[n6] = true;
                        }
                        n6 += 3;
                        break;
                    }
                    case 9: {
                        n6 += 5;
                        break;
                    }
                    case 13: {
                        if (n7 == 1) {
                            n3 = MethodWriter.getNewOffset(nArray3, nArray4, 0, n6);
                            n5 = -(n3 & 3);
                        } else if (!blArray[n6]) {
                            n5 = n6 & 3;
                            blArray[n6] = true;
                        }
                        n6 = n6 + 4 - (n6 & 3);
                        n6 += 4 * (MethodWriter.readInt(byArray, n6 + 8) - MethodWriter.readInt(byArray, n6 + 4) + 1) + 12;
                        break;
                    }
                    case 14: {
                        if (n7 == 1) {
                            n3 = MethodWriter.getNewOffset(nArray3, nArray4, 0, n6);
                            n5 = -(n3 & 3);
                        } else if (!blArray[n6]) {
                            n5 = n6 & 3;
                            blArray[n6] = true;
                        }
                        n6 = n6 + 4 - (n6 & 3);
                        n6 += 8 * MethodWriter.readInt(byArray, n6 + 4) + 8;
                        break;
                    }
                    case 16: {
                        n8 = byArray[n6 + 1] & 0xFF;
                        if (n8 == 132) {
                            n6 += 6;
                            break;
                        }
                        n6 += 4;
                        break;
                    }
                    case 1: 
                    case 3: 
                    case 10: {
                        n6 += 2;
                        break;
                    }
                    case 2: 
                    case 5: 
                    case 6: 
                    case 11: 
                    case 12: {
                        n6 += 3;
                        break;
                    }
                    case 7: {
                        n6 += 5;
                        break;
                    }
                    default: {
                        n6 += 4;
                    }
                }
                if (n5 == 0) continue;
                object = new int[nArray3.length + 1];
                int[] nArray5 = new int[nArray4.length + 1];
                System.arraycopy(nArray3, 0, object, 0, nArray3.length);
                System.arraycopy(nArray4, 0, nArray5, 0, nArray4.length);
                object[nArray3.length] = n6;
                nArray5[nArray4.length] = n5;
                nArray3 = object;
                nArray4 = nArray5;
                if (n5 <= 0) continue;
                n7 = 3;
            }
            if (n7 >= 3) continue;
            --n7;
        } while (n7 != 0);
        ByteVector byteVector = new ByteVector(this.code.length);
        n6 = 0;
        block24: while (n6 < this.code.length) {
            for (n2 = nArray3.length - 1; n2 >= 0; --n2) {
                if (nArray3[n2] != n6 || n2 >= n) continue;
                if (nArray2[n2] > 0) {
                    byteVector.putByteArray(null, 0, nArray2[n2]);
                } else {
                    byteVector.length += nArray2[n2];
                }
                nArray[n2] = byteVector.length;
            }
            n5 = byArray[n6] & 0xFF;
            switch (ClassWriter.TYPE[n5]) {
                case 0: 
                case 4: {
                    byteVector.putByte(n5);
                    ++n6;
                    continue block24;
                }
                case 8: {
                    if (n5 > 201) {
                        n5 = n5 < 218 ? n5 - 49 : n5 - 20;
                        n4 = n6 + MethodWriter.readUnsignedShort(byArray, n6 + 1);
                    } else {
                        n4 = n6 + MethodWriter.readShort(byArray, n6 + 1);
                    }
                    n3 = MethodWriter.getNewOffset(nArray3, nArray4, n6, n4);
                    if (blArray[n6]) {
                        if (n5 == 167) {
                            byteVector.putByte(200);
                        } else if (n5 == 168) {
                            byteVector.putByte(201);
                        } else {
                            byteVector.putByte(n5 <= 166 ? (n5 + 1 ^ 1) - 1 : n5 ^ 1);
                            byteVector.putShort(8);
                            byteVector.putByte(200);
                            n3 -= 3;
                        }
                        byteVector.putInt(n3);
                    } else {
                        byteVector.putByte(n5);
                        byteVector.putShort(n3);
                    }
                    n6 += 3;
                    continue block24;
                }
                case 9: {
                    n4 = n6 + MethodWriter.readInt(byArray, n6 + 1);
                    n3 = MethodWriter.getNewOffset(nArray3, nArray4, n6, n4);
                    byteVector.putByte(n5);
                    byteVector.putInt(n3);
                    n6 += 5;
                    continue block24;
                }
                case 13: {
                    int n9 = n6;
                    n6 = n6 + 4 - (n9 & 3);
                    byteVector.putByte(170);
                    while (byteVector.length % 4 != 0) {
                        byteVector.putByte(0);
                    }
                    n4 = n9 + MethodWriter.readInt(byArray, n6);
                    n3 = MethodWriter.getNewOffset(nArray3, nArray4, n9, n4);
                    byteVector.putInt(n3);
                    int n10 = MethodWriter.readInt(byArray, n6 += 4);
                    byteVector.putInt(n10);
                    byteVector.putInt(MethodWriter.readInt(byArray, (n6 += 4) - 4));
                    for (n10 = MethodWriter.readInt(byArray, n6 += 4) - n10 + 1; n10 > 0; --n10) {
                        n4 = n9 + MethodWriter.readInt(byArray, n6);
                        n6 += 4;
                        n3 = MethodWriter.getNewOffset(nArray3, nArray4, n9, n4);
                        byteVector.putInt(n3);
                    }
                    continue block24;
                }
                case 14: {
                    int n10;
                    int n9 = n6;
                    n6 = n6 + 4 - (n9 & 3);
                    byteVector.putByte(171);
                    while (byteVector.length % 4 != 0) {
                        byteVector.putByte(0);
                    }
                    n4 = n9 + MethodWriter.readInt(byArray, n6);
                    n3 = MethodWriter.getNewOffset(nArray3, nArray4, n9, n4);
                    byteVector.putInt(n3);
                    n6 += 4;
                    byteVector.putInt(n10);
                    for (n10 = MethodWriter.readInt(byArray, n6 += 4); n10 > 0; --n10) {
                        byteVector.putInt(MethodWriter.readInt(byArray, n6));
                        n4 = n9 + MethodWriter.readInt(byArray, n6 += 4);
                        n6 += 4;
                        n3 = MethodWriter.getNewOffset(nArray3, nArray4, n9, n4);
                        byteVector.putInt(n3);
                    }
                    continue block24;
                }
                case 16: {
                    n5 = byArray[n6 + 1] & 0xFF;
                    if (n5 == 132) {
                        byteVector.putByteArray(byArray, n6, 6);
                        n6 += 6;
                        continue block24;
                    }
                    byteVector.putByteArray(byArray, n6, 4);
                    n6 += 4;
                    continue block24;
                }
                case 1: 
                case 3: 
                case 10: {
                    byteVector.putByteArray(byArray, n6, 2);
                    n6 += 2;
                    continue block24;
                }
                case 2: 
                case 5: 
                case 6: 
                case 11: 
                case 12: {
                    byteVector.putByteArray(byArray, n6, 3);
                    n6 += 3;
                    continue block24;
                }
                case 7: {
                    byteVector.putByteArray(byArray, n6, 5);
                    n6 += 5;
                    continue block24;
                }
            }
            byteVector.putByteArray(byArray, n6, 4);
            n6 += 4;
        }
        Handler handler = this.catchTable;
        while (handler != null) {
            MethodWriter.getNewOffset(nArray3, nArray4, handler.start);
            MethodWriter.getNewOffset(nArray3, nArray4, handler.end);
            MethodWriter.getNewOffset(nArray3, nArray4, handler.handler);
            handler = handler.next;
        }
        for (n2 = 0; n2 < 2; ++n2) {
            object = n2 == 0 ? this.localVar : this.localVarType;
            if (object == null) continue;
            byArray = object.data;
            for (n6 = 0; n6 < object.length; n6 += 10) {
                n4 = MethodWriter.readUnsignedShort(byArray, n6);
                n3 = MethodWriter.getNewOffset(nArray3, nArray4, 0, n4);
                MethodWriter.writeShort(byArray, n6, n3);
                n3 = MethodWriter.getNewOffset(nArray3, nArray4, 0, n4 += MethodWriter.readUnsignedShort(byArray, n6 + 2)) - n3;
                MethodWriter.writeShort(byArray, n6 + 2, n3);
            }
        }
        if (this.lineNumber != null) {
            byArray = this.lineNumber.data;
            for (n6 = 0; n6 < this.lineNumber.length; n6 += 4) {
                MethodWriter.writeShort(byArray, n6, MethodWriter.getNewOffset(nArray3, nArray4, 0, MethodWriter.readUnsignedShort(byArray, n6)));
            }
        }
        while (this.cattrs != null) {
            object = this.cattrs.getLabels();
            if (object == null) continue;
            for (n2 = ((int[])object).length - 1; n2 >= 0; --n2) {
                if (object[n2].resized) continue;
                object[n2].position = MethodWriter.getNewOffset(nArray3, nArray4, 0, object[n2].position);
                object[n2].resized = true;
            }
        }
        this.code = byteVector;
        return nArray;
    }

    static int readUnsignedShort(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF;
    }

    static short readShort(byte[] byArray, int n) {
        return (short)((byArray[n] & 0xFF) << 8 | byArray[n + 1] & 0xFF);
    }

    static int readInt(byte[] byArray, int n) {
        return (byArray[n] & 0xFF) << 24 | (byArray[n + 1] & 0xFF) << 16 | (byArray[n + 2] & 0xFF) << 8 | byArray[n + 3] & 0xFF;
    }

    static void writeShort(byte[] byArray, int n, int n2) {
        byArray[n] = (byte)(n2 >>> 8);
        byArray[n + 1] = (byte)n2;
    }

    static int getNewOffset(int[] nArray, int[] nArray2, int n, int n2) {
        int n3 = n2 - n;
        for (int i = 0; i < nArray.length; ++i) {
            if (n < nArray[i] && nArray[i] <= n2) {
                n3 += nArray2[i];
                continue;
            }
            if (n2 >= nArray[i] || nArray[i] > n) continue;
            n3 -= nArray2[i];
        }
        return n3;
    }

    static void getNewOffset(int[] nArray, int[] nArray2, Label label) {
        if (!label.resized) {
            label.position = MethodWriter.getNewOffset(nArray, nArray2, 0, label.position);
            label.resized = true;
        }
    }

    static {
        int[] nArray = new int[202];
        String string = "EFFFFFFFFGGFFFGGFFFEEFGFGFEEEEEEEEEEEEEEEEEEEEDEDEDDDDDCDCDEEEEEEEEEEEEEEEEEEEEBABABBBBDCFFFGGGEDCDCDCDCDCDCDCDCDCDCEEEEDDDDDDDCDCDCEFEFDDEEFFDEDEEEBDDBBDDDDDDCCCCCCCCEFEDDDCDCDEEEEEEEEEEFEEEEEEDDEEDDEE";
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = string.charAt(i) - 69;
        }
        SIZE = nArray;
    }
}

