/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin;

import java.io.File;
import java.util.Map;
import java.util.Properties;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecution;
import org.apache.maven.plugin.descriptor.MojoDescriptor;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.path.PathTranslator;
import org.codehaus.plexus.component.configurator.expression.ExpressionEvaluationException;
import org.codehaus.plexus.component.configurator.expression.TypeAwareExpressionEvaluator;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.introspection.ReflectionValueExtractor;

public class PluginParameterExpressionEvaluator
implements TypeAwareExpressionEvaluator {
    private MavenSession session;
    private MojoExecution mojoExecution;
    private MavenProject project;
    private String basedir;
    private Properties properties;

    @Deprecated
    public PluginParameterExpressionEvaluator(MavenSession session2, MojoExecution mojoExecution, PathTranslator pathTranslator, Logger logger, MavenProject project2, Properties properties) {
        this(session2, mojoExecution);
    }

    public PluginParameterExpressionEvaluator(MavenSession session2) {
        this(session2, null);
    }

    public PluginParameterExpressionEvaluator(MavenSession session2, MojoExecution mojoExecution) {
        File projectFile;
        this.session = session2;
        this.mojoExecution = mojoExecution;
        this.properties = new Properties();
        this.project = session2.getCurrentProject();
        this.properties.putAll((Map<?, ?>)session2.getUserProperties());
        this.properties.putAll((Map<?, ?>)session2.getSystemProperties());
        String basedir = null;
        if (this.project != null && (projectFile = this.project.getBasedir()) != null) {
            basedir = projectFile.getAbsolutePath();
        }
        if (basedir == null) {
            basedir = session2.getExecutionRootDirectory();
        }
        if (basedir == null) {
            basedir = System.getProperty("user.dir");
        }
        this.basedir = basedir;
    }

    @Override
    public Object evaluate(String expr) throws ExpressionEvaluationException {
        return this.evaluate(expr, null);
    }

    @Override
    public Object evaluate(String expr, Class<?> type2) throws ExpressionEvaluationException {
        String val2;
        int exprStartDelimiter;
        String pathExpression;
        int pathSeparator;
        Object value = null;
        if (expr == null) {
            return null;
        }
        String expression = this.stripTokens(expr);
        if (expression.equals(expr)) {
            int lastIndex;
            int index2 = expr.indexOf("${");
            if (index2 >= 0 && (lastIndex = expr.indexOf(125, index2)) >= 0) {
                Object subResult;
                String retVal = expr.substring(0, index2);
                retVal = index2 > 0 && expr.charAt(index2 - 1) == '$' ? retVal + expr.substring(index2 + 1, lastIndex + 1) : ((subResult = this.evaluate(expr.substring(index2, lastIndex + 1))) != null ? retVal + subResult : retVal + "$" + expr.substring(index2 + 1, lastIndex + 1));
                retVal = retVal + this.evaluate(expr.substring(lastIndex + 1));
                return retVal;
            }
            return expression.replace("$$", "$");
        }
        MojoDescriptor mojoDescriptor = this.mojoExecution.getMojoDescriptor();
        if ("localRepository".equals(expression)) {
            value = this.session.getLocalRepository();
        } else if ("session".equals(expression)) {
            value = this.session;
        } else if (expression.startsWith("session")) {
            try {
                pathSeparator = expression.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.session);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.session);
            }
            catch (Exception e2) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e2);
            }
        } else if ("reactorProjects".equals(expression)) {
            value = this.session.getProjects();
        } else if ("mojoExecution".equals(expression)) {
            value = this.mojoExecution;
        } else if ("project".equals(expression)) {
            value = this.project;
        } else if ("executedProject".equals(expression)) {
            value = this.project.getExecutionProject();
        } else if (expression.startsWith("project") || expression.startsWith("pom")) {
            try {
                pathSeparator = expression.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(0, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.project);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.project);
            }
            catch (Exception e3) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e3);
            }
        } else if (expression.equals("repositorySystemSession")) {
            value = this.session.getRepositorySession();
        } else if (expression.equals("mojo")) {
            value = this.mojoExecution;
        } else if (expression.startsWith("mojo")) {
            try {
                pathSeparator = expression.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.mojoExecution);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.mojoExecution);
            }
            catch (Exception e4) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e4);
            }
        } else if (expression.equals("plugin")) {
            value = mojoDescriptor.getPluginDescriptor();
        } else if (expression.startsWith("plugin")) {
            try {
                pathSeparator = expression.indexOf(47);
                PluginDescriptor pluginDescriptor = mojoDescriptor.getPluginDescriptor();
                if (pathSeparator > 0) {
                    String pathExpression2 = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression2, pluginDescriptor);
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), pluginDescriptor);
            }
            catch (Exception e5) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e5);
            }
        } else if ("settings".equals(expression)) {
            value = this.session.getSettings();
        } else if (expression.startsWith("settings")) {
            try {
                pathSeparator = expression.indexOf(47);
                if (pathSeparator > 0) {
                    pathExpression = expression.substring(1, pathSeparator);
                    value = ReflectionValueExtractor.evaluate(pathExpression, this.session.getSettings());
                    value = value + expression.substring(pathSeparator);
                }
                value = ReflectionValueExtractor.evaluate(expression.substring(1), this.session.getSettings());
            }
            catch (Exception e6) {
                throw new ExpressionEvaluationException("Error evaluating plugin parameter expression: " + expression, e6);
            }
        } else if ("basedir".equals(expression)) {
            value = this.basedir;
        } else if (expression.startsWith("basedir") && (pathSeparator = expression.indexOf(47)) > 0) {
            value = this.basedir + expression.substring(pathSeparator);
        }
        if (value != null && type2 != null && !(value instanceof String) && !PluginParameterExpressionEvaluator.isTypeCompatible(type2, value)) {
            value = null;
        }
        if (value == null) {
            if (this.properties != null) {
                value = this.properties.getProperty(expression);
            }
            if (value == null && this.project != null && this.project.getProperties() != null) {
                value = this.project.getProperties().getProperty(expression);
            }
        }
        if (value instanceof String && (exprStartDelimiter = (val2 = (String)value).indexOf("${")) >= 0) {
            value = exprStartDelimiter > 0 ? val2.substring(0, exprStartDelimiter) + this.evaluate(val2.substring(exprStartDelimiter)) : this.evaluate(val2.substring(exprStartDelimiter));
        }
        return value;
    }

    private static boolean isTypeCompatible(Class<?> type2, Object value) {
        if (type2.isInstance(value)) {
            return true;
        }
        return (type2.isPrimitive() || type2.getName().startsWith("java.lang.")) && value.getClass().getName().startsWith("java.lang.");
    }

    private String stripTokens(String expr) {
        if (expr.startsWith("${") && expr.indexOf(125) == expr.length() - 1) {
            expr = expr.substring(2, expr.length() - 1);
        }
        return expr;
    }

    @Override
    public File alignToBaseDirectory(File file2) {
        if (file2 != null && !file2.isAbsolute()) {
            file2 = file2.getPath().startsWith(File.separator) ? file2.getAbsoluteFile() : new File(new File(this.basedir, file2.getPath()).toURI().normalize()).getAbsoluteFile();
        }
        return file2;
    }
}

