### tex.driver.pdftex.mk -- Supervise la production des fichiers PDF

# Author: Michael Grünewald
# Date: Dim  9 sep 2007 14:49:18 CEST
# Cookie: SYNOPSIS TARGET VARIABLE EN DOCUMENTATION

# BSD Owl Scripts (https://bitbucket.org/michipili/bsdowl)
# This file is part of BSD Owl Scripts
#
# Copyright © 2005–2014 Michael Grünewald
#
# This file must be used under the terms of the CeCILL-B.
# This source file is licensed as described in the file COPYING, which
# you should have received as part of this distribution. The terms
# are also available at
# http://www.cecill.info/licences/Licence_CeCILL-B_V1-en.txt


### SYNOPSIS

# TEX = /usr/local/bin/tex
#
# _TEX_PDF+= lalala.hp920c.ps.pdf
# _TEX_SRC.lalala.hp920c.ps.pdf = lalala.tex
# _TEX_PDF+= lalala.pdf
#
# _TEX_AUX_SUFFIXES = .aux .log
#
# _TEX_VARS = TEXINPUTS TEXMFOUTPUT TEXFORMATS TEXPOOL TFMFONTS
# _TEX_VARS+= INTERACTION JOBNAME FORMAT
# _TEX_VARS+= COMMENT PROGNAME
#
# MULTIPASS = aux ref final
# DRAFT = yes			# Inhibe MULTIPASS
#
# ${var}.{pdf:T} = value


### RÉALISATION

.if !target(__<tex.driver.pdftex.mk>__)
__<tex.driver.pdftex.mk>__:

#
# Initialisation des paramètres
#

_TEX_AUX_SUFFIXES?= .log

#
# Spécialisation des variables
#

# La spécialisation produit les variables TEXINPUTS.lalala.pdf, elle
# fournit une valeur en cherchant d'abord TEXINPUTS.lalala puis
# TEXINPUTS. Si aucune valeur n'est trouvée, la variable n'est pas
# affectée.

.for var in ${_TEX_VARS} FORMAT.pdf
.for pdf in ${_TEX_PDF}
.if defined(${var}.${pdf:T:.pdf=})&&!empty(${var.${pdf:T:.pdf=}})&&!defined(${var}.${pdf:T})
${var}.${pdf:T} = ${${var}.${pdf:T:.pdf=}}
.endif
.if defined(${var})&&!empty(${var})&&!defined(${var}.${pdf:T})
${var}.${pdf:T} = ${${var}}
.endif
.endfor
.endfor


#
# Définition de _TEX_SRC
#

.for pdf in ${_TEX_PDF}
.if !defined(_TEX_SRC.${pdf:T})||empty(_TEX_SRC.${pdf:T})
_TEX_SRC.${pdf:T}=${pdf:.pdf=.tex}
.endif
.endfor


#
# Création des lignes de commande
#

.for pdf in ${_TEX_PDF}
# On commence par calculer l'environnement d'éxécution
.if defined(TEXINPUTS.${pdf:T})&&!empty(TEXINPUTS.${pdf:T})
.if !defined(USE_STRICT_TEXINPUTS)|| ${USE_STRICT_TEXINPUTS} != yes
_TEX_ENV.${pdf:T}+= TEXINPUTS=".:${TEXINPUTS.${pdf:T}:Q:S/\\ /:/g}:"
.else
_TEX_ENV.${pdf:T}+= TEXINPUTS="${TEXINPUTS.${pdf:T}:Q:S/\\ /:/g}"
.endif
.endif
.if defined(TEXMFOUTPUT.${pdf:T})&&!empty(TEXMFOUTPUT.${pdf:T})
_TEX_ENV.${pdf:T}+= TEXMFOUTPUT=${TEXMFOUTPUT.${pdf:T}:Q}
.endif
.if defined(TEXFORMATS.${pdf:T})&&!empty(TEXFORMATS.${pdf:T})
_TEX_ENV.${pdf:T}+= TEXFORMATS=${TEXFORMATS.${pdf:T}:Q}
.endif
.if defined(TEXPOOL.${pdf:T})&&!empty(TEXPOOL.${pdf:T})
_TEX_ENV.${pdf:T}+= TEXPOOL=${TEXPOOL.${pdf:T}:q}
.endif
.if defined(TFMFONTS.${pdf:T})&&!empty(TFMFONTS.${pdf:T})
_TEX_ENV.${pdf:T}+= TFMFONTS=${TFMFONTS.${pdf:T}:Q}
.endif
# On insère cet environnement sur la ligne de commande
.if defined(_TEX_ENV.${pdf:T})&&!empty(_TEX_ENV.${pdf:T})
_TEX_BUILD.${pdf:T} = ${ENVTOOL} ${_TEX_ENV.${pdf:T}} ${TEX.pdf}
.else
_TEX_BUILD.${pdf:T} = ${TEX.pdf}
.endif
# On traite les variables dont l'argument est transmis au programme
.if defined(FORMAT.pdf.${pdf:T})&&!empty(FORMAT.pdf.${pdf:T})
_TEX_BUILD.${pdf:T}+= -fmt ${FORMAT.pdf.${pdf:T}}
.endif
.if defined(INTERACTION.${pdf:T})&&!empty(INTERACTION.${pdf:T})
_TEX_BUILD.${pdf:T}+= -interaction ${INTERACTION.${pdf:T}}mode
.endif
.if defined(JOBNAME.${pdf:T})&&!empty(JOBNAME.${pdf:T})
_TEX_BUILD.${pdf:T}+= -jobname ${JOBNAME.${pdf:T}}
.endif
.if defined(COMMENT.${pdf:T})&&!empty(COMMENT.${pdf:T})
_TEX_BUILD.${pdf:T}+= -output-comment ${COMMENT.${pdf:T}}
.endif
.if defined(PROGNAME.${pdf:T})&&!empty(PROGNAME.${pdf:T})
_TEX_BUILD.${pdf:T}+= -progname ${PROGNAME.${pdf:T}}
.endif
# On termine en ajoutant le fichier source principal
_TEX_BUILD.${pdf:T}+=${_TEX_SRC.${pdf:T}}
.endfor


#
# Production des recettes
#

# La production des recttes est controlée par les variables
# MULTIPASS et DRAFT.
#
# La dépendance ${pdf}: ${_TEX_SRC.${pdf:T}} est ajoutée
# automatiquement.

# Pour les traitements à plusieurs passes, on utilise des fichiers
# intermédiaires (des `cookies') pour faciliter la gestion des
# dépendances, et permettre l'insertion de passes supplémentaires, par
# exemple pour la préparation des bibliographies ou des index.

.for pdf in ${_TEX_PDF}
.if defined(MULTIPASS)&&!empty(MULTIPASS)&&(${DRAFT} == no)
.undef _TEX_pass_last
.for pass in ${MULTIPASS}
.if defined(_TEX_pass_last)
${COOKIEPREFIX}${pdf:T}.${pass}: ${COOKIEPREFIX}${pdf:T}.${_TEX_pass_last}
.endif
_TEX_pass_last:= ${pass}
.endfor
.for pass in ${MULTIPASS}
${COOKIEPREFIX}${pdf:T}.${pass}: ${_TEX_SRC.${pdf:T}}
	${INFO} 'Multipass job for ${pdf:T} (${pass})'
	${_TEX_BUILD.${pdf:T}}
	@${RM} -f ${pdf}
	@${TOUCH} ${.TARGET}
COOKIEFILES+= ${COOKIEPREFIX}${pdf:T}.${pass}
.endfor
${pdf}: ${_TEX_SRC.${pdf:T}} ${COOKIEPREFIX}${pdf:T}.${_TEX_pass_last}
	${INFO} 'Multipass job for ${pdf:T} (final)'
	${_TEX_BUILD.${pdf:T}}
.else
${pdf}: ${_TEX_SRC.${pdf:T}}
	${_TEX_BUILD.${pdf:T}}
.endif
.endfor

.endif #!target(__<tex.driver.pdftex.mk>__)

### End of file `tex.driver.pdftex.mk'
