/*
 * Decompiled with CFR 0.152.
 */
package com.android.tools.smali.dexlib2.analysis;

import com.android.tools.smali.dexlib2.Opcodes;
import com.android.tools.smali.dexlib2.analysis.ArrayProto;
import com.android.tools.smali.dexlib2.analysis.ClassProto;
import com.android.tools.smali.dexlib2.analysis.ClassProvider;
import com.android.tools.smali.dexlib2.analysis.DexClassProvider;
import com.android.tools.smali.dexlib2.analysis.OdexedFieldInstructionMapper;
import com.android.tools.smali.dexlib2.analysis.PrimitiveProto;
import com.android.tools.smali.dexlib2.analysis.TypeProto;
import com.android.tools.smali.dexlib2.analysis.UnknownClassProto;
import com.android.tools.smali.dexlib2.analysis.UnresolvedClassException;
import com.android.tools.smali.dexlib2.analysis.reflection.ReflectionClassDef;
import com.android.tools.smali.dexlib2.analysis.util.LruCache;
import com.android.tools.smali.dexlib2.analysis.util.MemoizingSupplier;
import com.android.tools.smali.dexlib2.iface.ClassDef;
import com.android.tools.smali.dexlib2.immutable.ImmutableDexFile;
import com.android.tools.smali.util.IteratorUtils;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;

public class ClassPath {
    @Nonnull
    private final TypeProto unknownClass;
    @Nonnull
    private List<ClassProvider> classProviders;
    private final boolean checkPackagePrivateAccess;
    public final int oatVersion;
    public static final int NOT_ART = -1;
    public static final int NOT_SPECIFIED = -2;
    @Nonnull
    private LruCache<String, TypeProto> loadedClasses = new LruCache<String, TypeProto>(30000){

        @Override
        protected TypeProto create(String key) {
            if (key.charAt(0) == '[') {
                return new ArrayProto(ClassPath.this, key);
            }
            return new ClassProto(ClassPath.this, key);
        }
    };
    private final Supplier<OdexedFieldInstructionMapper> fieldInstructionMapperSupplier = MemoizingSupplier.memoize(new Supplier<OdexedFieldInstructionMapper>(){

        @Override
        public OdexedFieldInstructionMapper get() {
            return new OdexedFieldInstructionMapper(ClassPath.this.isArt());
        }
    });

    public ClassPath(ClassProvider ... classProviders) throws IOException {
        this(Arrays.asList(classProviders), false, -1);
    }

    public ClassPath(Iterable<ClassProvider> classProviders) throws IOException {
        this(classProviders, false, -1);
    }

    public ClassPath(@Nonnull Iterable<? extends ClassProvider> classProviders, boolean checkPackagePrivateAccess, int oatVersion) {
        this.unknownClass = new UnknownClassProto(this);
        this.loadedClasses.put(this.unknownClass.getType(), this.unknownClass);
        this.checkPackagePrivateAccess = checkPackagePrivateAccess;
        this.oatVersion = oatVersion;
        this.loadPrimitiveType("Z");
        this.loadPrimitiveType("B");
        this.loadPrimitiveType("S");
        this.loadPrimitiveType("C");
        this.loadPrimitiveType("I");
        this.loadPrimitiveType("J");
        this.loadPrimitiveType("F");
        this.loadPrimitiveType("D");
        this.loadPrimitiveType("L");
        this.classProviders = IteratorUtils.toList(classProviders);
        this.classProviders.add(ClassPath.getBasicClasses());
    }

    private void loadPrimitiveType(String type) {
        this.loadedClasses.put(type, new PrimitiveProto(this, type));
    }

    private static ClassProvider getBasicClasses() {
        return new DexClassProvider(new ImmutableDexFile(Opcodes.getDefault(), (Collection<? extends ClassDef>)Collections.unmodifiableSet(new HashSet<ReflectionClassDef>(Arrays.asList(new ReflectionClassDef(Class.class), new ReflectionClassDef(Cloneable.class), new ReflectionClassDef(Object.class), new ReflectionClassDef(Serializable.class), new ReflectionClassDef(String.class), new ReflectionClassDef(Throwable.class))))));
    }

    public boolean isArt() {
        return this.oatVersion != -1;
    }

    @Nonnull
    public TypeProto getClass(@Nonnull CharSequence type) {
        return this.loadedClasses.get(type.toString());
    }

    @Nonnull
    public ClassDef getClassDef(String type) {
        for (ClassProvider provider : this.classProviders) {
            ClassDef classDef = provider.getClassDef(type);
            if (classDef == null) continue;
            return classDef;
        }
        throw new UnresolvedClassException("Could not resolve class %s", type);
    }

    @Nonnull
    public TypeProto getUnknownClass() {
        return this.unknownClass;
    }

    public boolean shouldCheckPackagePrivateAccess() {
        return this.checkPackagePrivateAccess;
    }

    @Nonnull
    public OdexedFieldInstructionMapper getFieldInstructionMapper() {
        return this.fieldInstructionMapperSupplier.get();
    }
}

