# ===========================================================================
# File: default.tcl
# Target: markdown
#                        Created: 2010-10-24 12:37:16
#              Last modification: 2010-10-24 12:37:02
# Author: Bernard Desgraupes
# e-mail: <bdesgraupes@users.sourceforge.net>
# (c) Copyright: Bernard Desgraupes 2010
# All rights reserved.
# Description: default Aida settings for target markdown
# ===========================================================================


# Array of header keywords
# ------------------------

namespace eval markdown {
	variable aida_head
	
	## The HorizRule parameter lets you specify the marker for horizontal
	## rules. In markdown syntax, you can produce a horizontal rule tag by
	## placing three or more hyphens, asterisks, or underscores on a line
	## by themselves. If you wish, you may use spaces between the hyphens
	## or asterisks. For instance:
	## 		* * *
	## 		***
	## 		*****
	## 		- - -
	## 		---------------------------------------
	set aida_head(HorizRule)	"----"

	## Symbol to mark italic style. Can be single '*' or '_'.
	set aida_head(EmphMark)			"*"

	## Symbol to mark bold style. Can be double '*' or '_'.
	set aida_head(StrongMark)		"**"
	
	# Prefix of index marks
	set aida_head(IndexMark)		"MARKIDX"
	
	# Prefix of section marks
	set aida_head(SectionMark)		"MARKSEC"
	
	# By default, enable the navigation bar in split files
	set aida_head(NavBar)			1

	# Define the extension of the split files in the navigation bar
	set aida_head(NavExtension)		""

}




# Attributes dictionary
# ---------------------

dict set aida_attr table border 1
