# ===========================================================================
# File: callbacks.tcl
#                        Created: 2010-09-08 07:27:55
#              Last modification: 2012-04-11 09:39:43
# Author: Bernard Desgraupes
# e-mail: <bdesgraupes@users.sourceforge.net>
# (c) Copyright: Bernard Desgraupes 2010-2012
# All rights reserved.
# Description: default Aida settings
# ===========================================================================


namespace eval aida {}


# Callbacks
# =========

proc aida::anchorProc {target str} {
	aida::execCallback anchorProc $target $str
}

proc aida::commentProc {target str} {
	aida::execCallback commentProc $target $str
}

proc aida::horizRuleProc {target} {
	aida::execCallback horizRuleProc $target
}

proc aida::imageProc {target str attr} {
	aida::execCallback imageProc $target $str $attr
}

proc aida::printIndexProc {target} {
	aida::execCallback printIndexProc $target
}

proc aida::linkProc {target str url} {
	aida::execCallback linkProc $target $str $url
}

proc aida::listProc {target kind depth attr itemList} {
	aida::execCallback listProc $target $kind $depth $attr $itemList
}

proc aida::navBarProc {target curr prev next top} {
	aida::execCallback navBarProc $target $curr $prev $next $top
}

proc aida::newLineProc {target} {
	aida::execCallback newLineProc $target
}

proc aida::preambleProc {target} {
	aida::execCallback preambleProc $target
}

proc aida::postambleProc {target} {
	aida::execCallback postambleProc $target
}

proc aida::refProc {target str label {file ""}} {
	aida::execCallback refProc $target $str $label $file
}

proc aida::sectionProc {target str level {file ""}} {
	aida::execCallback sectionProc $target $str $level $file
}

proc aida::setIndexProc {target str {file ""}} {
	aida::execCallback setIndexProc $target $str $file
}

proc aida::styleProc {target style begin} {
	aida::execCallback styleProc $target $style $begin
}

proc aida::tableProc {target attr rowList} {
	aida::execCallback tableProc $target $attr $rowList
}

proc aida::tocProc {target} {
	aida::execCallback tocProc $target
}

proc aida::verbProc {target str} {
	aida::execCallback verbProc $target $str
}

proc aida::verbatimProc {target str} {
	aida::execCallback verbatimProc $target $str
}

proc aida::defaultExtension {target} {
	aida::evalCallback defaultExtension $target
}



# # TEMPORARY
# aida::stampMsg utils "from callbacks.tcl"
