/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.core.startup;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;

public final class MavenRepoURLHandler
extends URLStreamHandler {
    private static final URI CENTRAL_REPO_URI;

    @Override
    protected URLConnection openConnection(URL uRL) throws IOException {
        String string = uRL.getPath();
        if (!string.startsWith("/")) {
            throw new IOException(string);
        }
        String string2 = string.substring(1);
        File file = new File(new File(new File(System.getProperty("user.home")), ".m2"), "repository");
        String[] stringArray = string2.split(":");
        URI uRI = null;
        if (stringArray.length < 4) {
            throw new IOException(string2);
        }
        uRI = this.relativeMavenURI(file.toURI(), stringArray);
        File file2 = new File(uRI);
        if (uRI == null || !file2.isFile()) {
            uRI = this.relativeMavenURI(CENTRAL_REPO_URI, stringArray);
        }
        return uRI.toURL().openConnection();
    }

    private URI relativeMavenURI(URI uRI, String[] stringArray) {
        URI uRI2 = uRI.resolve(stringArray[0].replace('.', '/') + '/');
        URI uRI3 = uRI2.resolve(stringArray[1] + '/').resolve(stringArray[2] + '/');
        String string = stringArray[1] + '-' + stringArray[2];
        if (stringArray.length == 5) {
            string = string + "-" + stringArray[4];
        }
        string = string + "." + stringArray[3];
        URI uRI4 = uRI3.resolve(string);
        return uRI4;
    }

    static {
        try {
            CENTRAL_REPO_URI = new URI("https://repo1.maven.org/maven2/");
        }
        catch (URISyntaxException uRISyntaxException) {
            throw new IllegalStateException(uRISyntaxException);
        }
    }
}

