/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.modules.startup;

import java.text.MessageFormat;
import java.util.Properties;
import java.util.ResourceBundle;
import javax.swing.JDialog;
import org.graalvm.visualvm.modules.startup.Utils;
import org.graalvm.visualvm.modules.startup.dialogs.StartupDialog;
import org.openide.LifecycleManager;
import org.openide.modules.ModuleInstall;
import org.openide.util.NbBundle;

final class VisualVMStartup
extends ModuleInstall {
    private static final boolean DISABLE_STARTUP_CHECK = Boolean.getBoolean("org.graalvm.visualvm.modules.startup.DisableStartupCheck");
    private static final ResourceBundle bundle = NbBundle.getBundle(VisualVMStartup.class);
    private static final String ERROR_STARTUP_CAPTION = bundle.getString("VisualVMStartup_ErrorStartupCaption");
    private static final String INCORRECT_VERSION_MSG = bundle.getString("VisualVMStartup_IncorrectVersionMsg");
    private static final String JRE_MSG = bundle.getString("VisualVMStartup_JreMsg");
    private static final String OPENJ9_MSG = bundle.getString("VisualVMStartup_OpenJ9Msg");
    private static boolean envChecked = false;

    VisualVMStartup() {
    }

    public void validate() {
        if (!VisualVMStartup.checkEnv()) {
            LifecycleManager.getDefault().exit();
        }
    }

    static synchronized boolean checkEnv() {
        if (envChecked) {
            return true;
        }
        envChecked = true;
        if (DISABLE_STARTUP_CHECK) {
            System.err.println("Starting with org.graalvm.visualvm.modules.startup.DisableStartupCheck=true");
        } else {
            if (!VisualVMStartup.isSupportedJava()) {
                VisualVMStartup.displayUnsupportedJavaError();
                return false;
            }
            if (!VisualVMStartup.isJDK()) {
                VisualVMStartup.displayErrorJRE();
                return false;
            }
            if (VisualVMStartup.isOpenJ9()) {
                VisualVMStartup.displayErrorJ9();
                return false;
            }
        }
        return true;
    }

    private static void displayUnsupportedJavaError() {
        Utils.setSystemLaF();
        JDialog d = StartupDialog.create(ERROR_STARTUP_CAPTION, MessageFormat.format(INCORRECT_VERSION_MSG, System.getProperty("java.specification.version"), VisualVMStartup.getJavaInfo(), VisualVMStartup.getJvmInfo(), System.getProperties().getProperty("java.home", "unknown location")), 0);
        d.setVisible(true);
    }

    private static void displayErrorJRE() {
        Utils.setSystemLaF();
        JDialog d = StartupDialog.create(ERROR_STARTUP_CAPTION, MessageFormat.format(JRE_MSG, VisualVMStartup.getJavaInfo(), VisualVMStartup.getJvmInfo(), System.getProperties().getProperty("java.home", "unknown location")), 0);
        d.setVisible(true);
    }

    private static void displayErrorJ9() {
        Utils.setSystemLaF();
        JDialog d = StartupDialog.create(ERROR_STARTUP_CAPTION, MessageFormat.format(OPENJ9_MSG, VisualVMStartup.getJavaInfo(), VisualVMStartup.getJvmInfo(), System.getProperties().getProperty("java.home", "unknown location")), 0);
        d.setVisible(true);
    }

    private static boolean isSupportedJava() {
        String javaVersion = System.getProperty("java.specification.version");
        if (javaVersion == null) {
            return false;
        }
        return javaVersion.startsWith("1.8") || javaVersion.startsWith("1.9") || javaVersion.startsWith("9") || javaVersion.startsWith("10") || javaVersion.startsWith("11") || javaVersion.startsWith("12") || javaVersion.startsWith("13") || javaVersion.startsWith("14") || javaVersion.startsWith("15") || javaVersion.startsWith("16") || javaVersion.startsWith("17") || javaVersion.startsWith("18") || javaVersion.startsWith("19") || javaVersion.startsWith("20") || javaVersion.startsWith("21");
    }

    private static boolean isOpenJ9() {
        String vmName = System.getProperty("java.vm.name");
        return "Eclipse OpenJ9 VM".equals(vmName);
    }

    private static boolean isJDK() {
        Class<?> vmClass = null;
        try {
            vmClass = Class.forName("com.sun.tools.attach.VirtualMachine");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return vmClass != null;
    }

    private static String getJavaInfo() {
        Properties systemProperties = System.getProperties();
        String javaVersion = systemProperties.getProperty("java.version", "unknown version");
        String vendorInfo = systemProperties.getProperty("java.vendor", "unknown vendor");
        return javaVersion + "; " + vendorInfo;
    }

    private static String getJvmInfo() {
        Properties systemProperties = System.getProperties();
        String vmName = systemProperties.getProperty("java.vm.name", "unknown name");
        String vmVerison = systemProperties.getProperty("java.vm.version", "");
        String vmInfo = systemProperties.getProperty("java.vm.info", "");
        vmInfo = vmInfo.split("\n")[0];
        return vmName + " (" + vmVerison + ", " + vmInfo + ")";
    }
}

