/*
 * Decompiled with CFR 0.152.
 */
package org.omegat.core.data;

import java.net.URL;
import java.util.Map;
import java.util.Properties;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.omegat.filters2.master.PluginUtils;
import org.omegat.util.OStrings;

public class PluginInformation {
    private final String className;
    private final String name;
    private final String version;
    private final String author;
    private final String description;
    private final PluginUtils.PluginType category;
    private final String link;
    private final URL url;
    private final Status status;

    private PluginInformation(String className, String name, String version, String author, String description, PluginUtils.PluginType category, String link, URL url, Status status) {
        this.className = className;
        this.name = name;
        this.version = version;
        this.author = author;
        this.description = description;
        this.category = category;
        this.link = link;
        this.url = url;
        this.status = status;
    }

    public String getClassName() {
        return this.className;
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getAuthor() {
        return this.author;
    }

    public final PluginUtils.PluginType getCategory() {
        return this.category;
    }

    public final String getLink() {
        return this.link;
    }

    public URL getUrl() {
        return this.url;
    }

    public final boolean isBundled() {
        return this.status == Status.BUNDLED;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("PluginInformation [className=").append(this.className).append(", name=").append(this.name).append(", version=").append(this.version).append(", author=").append(this.author).append(", description=").append(this.description).append("]");
        return builder.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.author == null ? 0 : this.author.hashCode());
        result = 31 * result + (this.className == null ? 0 : this.className.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.version == null ? 0 : this.version.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PluginInformation other = (PluginInformation)obj;
        if (this.author == null ? other.author != null : !this.author.equals(other.author)) {
            return false;
        }
        if (this.className == null ? other.className != null : !this.className.equals(other.className)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return !(this.version == null ? other.version != null : !this.version.equals(other.version));
    }

    public static final class Builder {
        private static final String PLUGIN_NAME = "Plugin-Name";
        private static final String PLUGIN_VERSION = "Plugin-Version";
        private static final String PLUGIN_AUTHOR = "Plugin-Author";
        private static final String PLUGIN_DESCRIPTION = "Plugin-Description";
        private static final String PLUGIN_CATEGORY = "Plugin-Category";
        private static final String PLUGIN_LINK = "Plugin-Link";
        private static final String PLUGIN_TYPE = "OmegaT-Plugin";
        private static final String IMPLEMENTATION_VENDOR = "Implementation-Vendor";
        private static final String IMPLEMENTATION_TITLE = "Implementation-Title";
        private static final String IMPLEMENTATION_VERSION = "Implementation-Version";
        private static final String BUNDLE_VERSION = "Bundle-Version";
        private static final String BUNDLE_NAME = "Bundle-Name";
        private static final String BUILT_BY = "Built-By";
        private static final String AUTHOR = "OmegaT team";
        private static final String LINK = "https://www.omegat.org";

        private Builder() {
        }

        public static PluginInformation fromManifest(String className, Manifest manifest, URL mu, Status status) {
            Attributes attrs;
            Attributes targetAttrs = new Attributes(manifest.getMainAttributes());
            String packageName = className.substring(0, className.lastIndexOf(".") + 1).replaceAll("\\.", "/");
            int i = 0;
            while (i < packageName.length()) {
                i = packageName.indexOf("/", i) + 1;
                attrs = manifest.getEntries().get(packageName.substring(0, i));
                if (attrs == null) continue;
                targetAttrs.putAll((Map<?, ?>)attrs);
            }
            attrs = manifest.getEntries().get(className);
            if (attrs != null) {
                targetAttrs.putAll((Map<?, ?>)attrs);
            }
            return new PluginInformation(className, Builder.findName(className, targetAttrs), Builder.findVersion(targetAttrs), Builder.findAuthor(targetAttrs), Builder.lookupAttribute(targetAttrs, PLUGIN_DESCRIPTION), Builder.findCategory(targetAttrs), Builder.lookupAttribute(targetAttrs, PLUGIN_LINK), mu, status);
        }

        public static PluginInformation fromProperties(String className, Properties props, String key, URL mu, Status status) {
            return new PluginInformation(className, key, OStrings.getSimpleVersion(), AUTHOR, props.getProperty(String.format("plugin.desc.%s", key)), PluginUtils.PluginType.getTypeByValue(key), LINK, mu, status);
        }

        private static PluginUtils.PluginType findCategory(Attributes attrs) {
            String categoryKey = Builder.lookupAttribute(attrs, PLUGIN_CATEGORY, PLUGIN_TYPE);
            if (categoryKey != null) {
                return PluginUtils.PluginType.getTypeByValue(categoryKey);
            }
            return PluginUtils.PluginType.MISCELLANEOUS;
        }

        private static String findName(String className, Attributes attrs) {
            String name = Builder.lookupAttribute(attrs, PLUGIN_NAME, BUNDLE_NAME, IMPLEMENTATION_TITLE);
            if (name != null) {
                return name;
            }
            return className.substring(className.lastIndexOf(".") + 1);
        }

        private static String findVersion(Attributes attrs) {
            String version = Builder.lookupAttribute(attrs, PLUGIN_VERSION, BUNDLE_VERSION, IMPLEMENTATION_VERSION);
            if (version != null) {
                return version;
            }
            return "";
        }

        private static String findAuthor(Attributes attrs) {
            String author = Builder.lookupAttribute(attrs, PLUGIN_AUTHOR, IMPLEMENTATION_VENDOR, BUILT_BY);
            if (author != null) {
                return author;
            }
            if ("org.omegat.Main".equals(attrs.getValue("Main-Class"))) {
                return AUTHOR;
            }
            return "Unknown";
        }

        private static String lookupAttribute(Attributes attrs, String ... candidates) {
            for (String key : candidates) {
                if (attrs.getValue(key) == null) continue;
                return attrs.getValue(key);
            }
            return null;
        }
    }

    public static enum Status {
        INSTALLED,
        BUNDLED,
        NEW;

    }
}

