# /=====================================================================\ #
# |  Version                                                            | #
# | Record LaTeXML Version, Revision...                                 | #
# |=====================================================================| #
# | Part of LaTeXML:                                                    | #
# |  Public domain software, produced as part of work done by the       | #
# |  United States Government & not subject to copyright in the US.     | #
# |---------------------------------------------------------------------| #
# | Bruce Miller <bruce.miller@nist.gov>                        #_#     | #
# | http://dlmf.nist.gov/LaTeXML/                              (o o)    | #
# \=========================================================ooo==U==ooo=/ #

package LaTeXML::Version;
use strict;
use warnings;
use FindBin;

#======================================================================
# The original idea here was to
#  * collect VERSION (& related info) in ONE place
#  * to provide a small file, editable by make, which could record git status
# However, Perl/MakeMaker/CPAN maintain a perverse distinction between
# module & distribution versions that makes this hard.
#======================================================================
# We _could_ put in Makefile.PL
#   VERSION_FROM       => 'lib/LaTeXML/Version.in',
# In here:
#    use version; our $VERSION = version->declare("0.8.0");
#    $LaTeXML::VERSION = $VERSION;   # "export" it...
# and in LaTeXML:
#  use LaTeXML::Version;
#  $LaTeXML::VERSION = do { use LaTeXML::Version; $LaTeXML::Version::VERSION; };
# That ALMOST works, but the CPAN indexer ONLY looks for explicit versions
# in the "top level module"
#======================================================================
# SO, we keep the actual version in LaTeXML.pm
# BUT, we can't "use LaTeXML" here, else we get a dependency loop,
# so anyone that uses LaTeXML::Version must use LaTeXML as well.
#======================================================================

# This is the git/svn/whatever revision; it should be filled in by make.
our $REVISION = '';

1;

