/*
 * Decompiled with CFR 0.152.
 */
package shared;

import java.awt.Color;
import shared.m;

public class ColorUtils {
    public static double modulus(double num, double div) {
        return (num % div + div) % div;
    }

    private static double gethue(double r, double g, double b2) {
        double min = ColorUtils.getmin(r, g, b2);
        double max = ColorUtils.getmax(r, g, b2);
        if (max == min) {
            return 0.0;
        }
        if (max == r) {
            return ColorUtils.modulus(60.0 * (g - b2) / (max - min) + 360.0, 360.0);
        }
        if (max == g) {
            return 60.0 * (b2 - r) / (max - min) + 120.0;
        }
        return 60.0 * (r - g) / (max - min) + 240.0;
    }

    private static double getsat(double min, double max) {
        if (max == 0.0) {
            return 0.0;
        }
        return 1.0 - min / max;
    }

    private static double getsatHSL(double min, double max, double l) {
        if (max == min) {
            return 0.0;
        }
        if (l <= 0.5) {
            return (max - min) / (max + min);
        }
        return (max - min) / (2.0 - (max + min));
    }

    private static double getmin(double f1, double f2, double f3) {
        return Math.min(Math.min(f1, f2), f3);
    }

    private static double getmax(double f1, double f2, double f3) {
        return Math.max(Math.max(f1, f2), f3);
    }

    private static double getfractionalpart(double f) {
        return f - Math.floor(f);
    }

    public static class HSV {
        public double h;
        public double s;
        public double v;

        public HSV(double h, double s, double v) {
            this.h = h;
            this.s = s;
            this.v = v;
        }

        public void canonicalise() {
            if (this.h < 0.0 || this.h > 360.0) {
                this.h = ColorUtils.modulus(this.h, 360.0);
            }
        }

        public void rotateHue(double angle) {
            this.h += angle;
            this.canonicalise();
        }

        public RGB convertToRGB() {
            int hi = (int)ColorUtils.modulus(Math.floor(this.h / 60.0), 6.0);
            double f = ColorUtils.getfractionalpart(this.h / 60.0);
            double p = this.v * (1.0 - this.s);
            double q = this.v * (1.0 - f * this.s);
            double t = this.v * (1.0 - (1.0 - f) * this.s);
            switch (hi) {
                case 0: {
                    return new RGB(this.v, t, p);
                }
                case 1: {
                    return new RGB(q, this.v, p);
                }
                case 2: {
                    return new RGB(p, this.v, t);
                }
                case 3: {
                    return new RGB(p, q, this.v);
                }
                case 4: {
                    return new RGB(t, p, this.v);
                }
                case 5: {
                    return new RGB(this.v, p, q);
                }
            }
            m.throwUncaughtException("This should not be possible in convertToRGB.");
            return null;
        }

        public String toString() {
            return "h=" + Double.toString(this.h) + "  s=" + Double.toString(this.s) + "  v=" + Double.toString(this.v);
        }
    }

    public static class HSL {
        public double h;
        public double s;
        public double l;

        public HSL(double h, double s, double l) {
            this.h = h;
            this.s = s;
            this.l = l;
        }

        public RGB convertToRGB() {
            double q = this.l < 0.5 ? this.l * (1.0 + this.s) : this.l + this.s - this.l * this.s;
            double p = 2.0 * this.l - q;
            double hk = this.h / 360.0;
            double tr = hk + 0.3333333333333333;
            double tg = hk;
            double tb = hk - 0.3333333333333333;
            if (tr < 0.0) {
                tr += 1.0;
            }
            if (tr > 1.0) {
                tr -= 1.0;
            }
            if (tg < 0.0) {
                tg += 1.0;
            }
            if (tg > 1.0) {
                tg -= 1.0;
            }
            if (tb < 0.0) {
                tb += 1.0;
            }
            if (tb > 1.0) {
                tb -= 1.0;
            }
            double cr = this.convhelp(p, q, tr);
            double cg = this.convhelp(p, q, tg);
            double cb = this.convhelp(p, q, tb);
            RGB result = new RGB(cr, cg, cb);
            return result;
        }

        private double convhelp(double p, double q, double tc) {
            if (tc < 0.16666666666666666) {
                return p + (q - p) * 6.0 * tc;
            }
            if (tc < 0.5) {
                return q;
            }
            if (tc < 0.6666666666666666) {
                return p + (q - p) * 6.0 * (0.6666666666666666 - tc);
            }
            return p;
        }
    }

    public static class RGB {
        public double r;
        public double g;
        public double b;

        public RGB(double r, double g, double b2) {
            this.r = r;
            this.g = g;
            this.b = b2;
        }

        public HSV convertToHSV() {
            double min = ColorUtils.getmin(this.r, this.g, this.b);
            double max = ColorUtils.getmax(this.r, this.g, this.b);
            double h = ColorUtils.gethue(this.r, this.g, this.b);
            double s = ColorUtils.getsat(min, max);
            double v = max;
            HSV result = new HSV(h, s, v);
            return result;
        }

        public HSL convertToHSL() {
            double min = ColorUtils.getmin(this.r, this.g, this.b);
            double max = ColorUtils.getmax(this.r, this.g, this.b);
            double h = ColorUtils.gethue(this.r, this.g, this.b);
            double l = 0.5 * (max + min);
            double s = ColorUtils.getsatHSL(min, max, l);
            HSL result = new HSL(h, s, l);
            return result;
        }

        public RGB24 convertToRGB24() {
            int r2 = (int)Math.round(this.r * 255.0);
            int g2 = (int)Math.round(this.g * 255.0);
            int b2 = (int)Math.round(this.b * 255.0);
            RGB24 result = new RGB24(r2, g2, b2);
            return result;
        }

        public String toString() {
            return "r=" + Double.toString(this.r) + "  g=" + Double.toString(this.g) + "  b=" + Double.toString(this.b);
        }
    }

    public static class RGB24 {
        public int r;
        public int g;
        public int b;

        public RGB24(int r, int g, int b2) {
            this.r = r;
            this.g = g;
            this.b = b2;
        }

        public RGB convertToRGB() {
            double r2 = (double)this.r / 255.0;
            double g2 = (double)this.g / 255.0;
            double b2 = (double)this.b / 255.0;
            RGB result = new RGB(r2, g2, b2);
            return result;
        }

        public Color convertToJavaColor() {
            Color result = new Color(this.r, this.g, this.b);
            return result;
        }
    }
}

