/*
 * Decompiled with CFR 0.152.
 */
package prpobjects;

import prpobjects.HsBitVector;
import prpobjects.PrpRootObject;
import prpobjects.Typeid;
import prpobjects.Uruobjectref;
import prpobjects.plCoordinateInterface;
import prpobjects.plHKPhysical;
import prpobjects.plSceneObject;
import prpobjects.plSynchedObject;
import prpobjects.prpfile;
import prpobjects.uruobj;
import shared.Flt;
import shared.ICompilable;
import shared.Quat;
import shared.ShortTriplet;
import shared.State.AllStates;
import shared.Vertex;
import shared.b;
import shared.e;
import shared.m;
import shared.readexception;
import shared.readwarningexception;
import uru.Bytedeque;
import uru.context;

public class plODEPhysical
extends uruobj {
    plSynchedObject parent;
    int type;
    int vertexcount;
    Vertex[] vertices;
    int surfacecount;
    int[] surfaces;
    int xu3;
    byte[] xu3s;
    Flt f1;
    Flt f2;
    Flt f3;
    Flt u4;
    Flt f8;
    int u8;
    int u9;
    int u10;
    int u11;
    int u12;
    short u13;
    Uruobjectref sceneobject;
    Uruobjectref scenenode;
    Flt f6a;
    Flt f6b;
    public plHKPhysical.HKPhysical convertee;

    public plHKPhysical.HKPhysical convertToHKPhysical(prpfile prp) {
        if (this.type == 5) {
            this.convertee.format = 4;
            this.convertee.xproxybounds = new plHKPhysical.HKProxyBounds();
            this.convertee.xproxybounds.parent.vertexcount = this.vertexcount;
            e.ensure(this.vertices.length == this.vertexcount);
            this.convertee.xproxybounds.parent.vertices = this.vertices;
            this.convertee.xproxybounds.facecount = this.surfacecount;
            this.convertee.xproxybounds.faces = new ShortTriplet[this.surfacecount];
            for (int i = 0; i < this.surfacecount; ++i) {
                ShortTriplet trip;
                short point1 = (short)this.surfaces[i * 3 + 0];
                short point2 = (short)this.surfaces[i * 3 + 1];
                short point3 = (short)this.surfaces[i * 3 + 2];
                this.convertee.xproxybounds.faces[i] = trip = ShortTriplet.createFromShorts(point1, point2, point3);
            }
        } else if (this.type == 1) {
            this.convertee.format = 1;
            this.convertee.xboxbounds = new plHKPhysical.HKBoxBounds();
            Vertex center = plODEPhysical.findOffsetVectorFromSceneObject(prp, this.sceneobject);
            m.msg("Resizing boxes in ODEPhysical...");
            Vertex cornervector = new Vertex(this.f1.mult(0.5f), this.f2.mult(0.5f), this.f3.mult(0.5f));
            int vertexcount = 8;
            int facecount = 12;
            Vertex[] vertices = new Vertex[]{new Vertex(center.x.sub(cornervector.x), center.y.sub(cornervector.y), center.z.sub(cornervector.z)), new Vertex(center.x.add(cornervector.x), center.y.sub(cornervector.y), center.z.sub(cornervector.z)), new Vertex(center.x.sub(cornervector.x), center.y.add(cornervector.y), center.z.sub(cornervector.z)), new Vertex(center.x.add(cornervector.x), center.y.add(cornervector.y), center.z.sub(cornervector.z)), new Vertex(center.x.sub(cornervector.x), center.y.sub(cornervector.y), center.z.add(cornervector.z)), new Vertex(center.x.add(cornervector.x), center.y.sub(cornervector.y), center.z.add(cornervector.z)), new Vertex(center.x.sub(cornervector.x), center.y.add(cornervector.y), center.z.add(cornervector.z)), new Vertex(center.x.add(cornervector.x), center.y.add(cornervector.y), center.z.add(cornervector.z))};
            short[] faces = new short[]{0, 2, 1, 1, 2, 3, 0, 1, 4, 1, 5, 4, 0, 4, 2, 2, 4, 6, 1, 3, 7, 7, 5, 1, 3, 2, 7, 2, 6, 7, 4, 7, 6, 4, 5, 7};
            e.ensure(vertices.length == vertexcount);
            e.ensure(faces.length == facecount * 3);
            this.convertee.xboxbounds.parent.parent.vertexcount = vertexcount;
            this.convertee.xboxbounds.parent.parent.vertices = vertices;
            this.convertee.xboxbounds.parent.facecount = facecount;
            this.convertee.xboxbounds.parent.faces = new ShortTriplet[facecount];
            for (int i = 0; i < facecount; ++i) {
                ShortTriplet trip;
                short point1 = faces[i * 3 + 0];
                short point2 = faces[i * 3 + 1];
                short point3 = faces[i * 3 + 2];
                this.convertee.xboxbounds.parent.faces[i] = trip = ShortTriplet.createFromShorts(point1, point2, point3);
            }
        } else if (this.type == 2) {
            Vertex offset;
            this.convertee.format = 2;
            this.convertee.xspherebounds = new plHKPhysical.HKSphereBounds();
            this.convertee.xspherebounds.offset = offset = plODEPhysical.findOffsetVectorFromSceneObject(prp, this.sceneobject);
            this.convertee.xspherebounds.radius = this.u4;
        } else if (this.type == 6) {
            m.throwUncaughtException("ODEPhysical: unable to compile type 6.");
        } else {
            m.throwUncaughtException("ODEPhysical: unable to compile unknown type.");
        }
        return this.convertee;
    }

    public plODEPhysical(context c) throws readexception {
        this.parent = new plSynchedObject(c);
        this.type = c.readInt();
        if (this.type == 5) {
            this.vertexcount = c.readInt();
            this.vertices = (Vertex[])c.readArray(Vertex.class, this.vertexcount);
            this.surfacecount = c.readInt();
            for (int point : this.surfaces = c.readInts(3 * this.surfacecount)) {
                if (point < 65536) continue;
                throw new readexception("ODEPhysical has more than 2^16 points, so it can't be converted.");
            }
            this.xu3 = c.readInt();
            this.xu3s = c.readBytes(this.xu3);
        } else if (this.type == 1) {
            this.f1 = new Flt(c);
            this.f2 = new Flt(c);
            this.f3 = new Flt(c);
        } else if (this.type == 2) {
            this.u4 = new Flt(c);
        } else if (this.type == 6) {
            this.f6a = new Flt(c);
            this.f6b = new Flt(c);
        } else {
            m.msg("Untested ODE case unknown...");
        }
        this.f8 = new Flt(c);
        this.u8 = c.readInt();
        this.u9 = c.readInt();
        this.u10 = c.readInt();
        this.u11 = c.readInt();
        if (c.readversion == 4) {
            this.u12 = c.readInt();
        }
        this.u13 = c.readShort();
        this.sceneobject = new Uruobjectref(c);
        this.scenenode = new Uruobjectref(c);
        if (AllStates.getStateAsBoolean("reportPhysics")) {
            m.msg("Physics: type=", Integer.toString(this.type) + ";f8=" + this.f8.toString() + ";u8=0x" + Integer.toHexString(this.u8) + ";u9=0x" + Integer.toHexString(this.u9) + ";u10=0x" + Integer.toHexString(this.u10) + ";u11=" + Integer.toString(this.u11) + ";u12=0x" + Integer.toHexString(this.u12) + ";u13=" + Short.toString(this.u13) + ";object=" + c.curRootObject.toString());
        }
        this.convertee = plHKPhysical.HKPhysical.createBlank();
        this.convertee.parent = this.parent;
        this.convertee.position = Vertex.zero();
        this.convertee.orientation = Quat.identity();
        this.convertee.mass = Flt.zero();
        this.convertee.RC = Flt.zero();
        this.convertee.EL = Flt.zero();
        if (this.type == 5) {
            this.convertee.format = 4;
        } else if (this.type == 1) {
            this.convertee.format = 1;
        } else if (this.type == 2) {
            this.convertee.format = 2;
        } else {
            if (this.type == 6) {
                throw new readwarningexception("ODEPhysical: able to read, but ignoring unhandled type 6.(cylinder)");
            }
            throw new readexception("ODEPhysical: able to read okay, but throwing error to ignore unhandled format.");
        }
        this.convertee.u1 = 0;
        this.convertee.coltype = (short)512;
        this.convertee.flagsdetect = 0;
        this.convertee.flagsrespond = 0;
        this.convertee.u2 = 0;
        this.convertee.u3 = 0;
        this.convertee.sceneobject = this.sceneobject;
        this.convertee.group = new HsBitVector(0);
        this.convertee.scenenode = this.scenenode;
        this.convertee.LOSDB = 68;
        this.convertee.subworld = Uruobjectref.none();
        this.convertee.soundgroup = Uruobjectref.none();
        if (c.curRootObject.objectname.toString().toLowerCase().equals("rgncliffladdertop")) {
            boolean bl = false;
        }
        this.convertee.LOSDB = b.Int16ToInt32(this.u13);
        if (this.u8 == 0x2000000 && this.u9 == 0 && this.u10 == 0 || this.u8 == 0x2800000 && this.u9 == 0 && this.u10 == 0 || this.u8 == 0x2000000 && this.u9 == 126222336 && this.u10 == 0) {
            this.convertee.u1 = 0;
            this.convertee.coltype = (short)512;
            this.convertee.flagsdetect = 0;
            this.convertee.flagsrespond = 0;
            this.convertee.u2 = 0;
            this.convertee.u3 = 0;
            this.convertee.LOSDB |= 4;
            this.convertee.group = new HsBitVector(0);
        } else if (this.u8 == 0x2000000 && this.u9 == 131072 && this.u10 == 0) {
            this.convertee.u1 = 0;
            this.convertee.coltype = (short)512;
            this.convertee.flagsdetect = 0;
            this.convertee.flagsrespond = 131072;
            this.convertee.u2 = 0;
            this.convertee.u3 = 0;
            this.convertee.group = new HsBitVector(4);
        } else if (this.u8 == 0x1800000 && this.u9 == 0x3000000 && this.u10 == 0) {
            this.convertee.u1 = 0;
            this.convertee.coltype = (short)1024;
            this.convertee.flagsdetect = 131072;
            this.convertee.flagsrespond = 0;
            this.convertee.u2 = 0;
            this.convertee.u3 = 0;
            this.convertee.group = new HsBitVector(4);
        } else if (this.u8 == 0x4000000 && this.u9 == 0 && this.u10 == 0x8000000 || this.u8 == 0x4800000 && this.u9 == 0 && this.u10 == 0x8000000) {
            this.convertee.u1 = 0;
            this.convertee.coltype = (short)1024;
            this.convertee.flagsdetect = 0x8000000;
            this.convertee.flagsrespond = 0;
            this.convertee.u2 = 0;
            this.convertee.u3 = 0;
            this.convertee.group = new HsBitVector(4);
        } else if (this.u8 == 0x4000000 && this.u9 == 0 && this.u10 == 131072 || this.u8 == 0x4800000 && this.u9 == 0 && this.u10 == 131072 || this.u8 == 0x4000000 && this.u9 == 0 && this.u10 == 131074 || this.u8 == 0x4800000 && this.u9 == 0 && this.u10 == 131074) {
            this.convertee.u1 = 0;
            this.convertee.coltype = (short)1024;
            this.convertee.flagsdetect = 131072;
            this.convertee.flagsrespond = 0;
            this.convertee.u2 = 0;
            this.convertee.u3 = 0;
            this.convertee.group = new HsBitVector(4);
            this.convertee.mass = Flt.one();
        } else if (this.u8 == 0x4000000 && this.u9 == 0 && this.u10 == 0 || this.u8 == 0x4800000 && this.u9 == 0 && this.u10 == 0 || this.u8 == 0x4000000 && this.u9 == 0 && this.u10 == 2) {
            this.convertee.u1 = 0;
            this.convertee.coltype = (short)1024;
            this.convertee.flagsdetect = 0;
            this.convertee.flagsrespond = 0;
            this.convertee.u2 = 0;
            this.convertee.u3 = 0;
            this.convertee.group = new HsBitVector(4);
        } else if (this.u8 == 0x4000000 && this.u9 == 131072 && this.u10 == 0 || this.u8 == 0x4800000 && this.u9 == 131072 && this.u10 == 0 || this.u8 == 0x4000000 && this.u9 == 0x1020000 && this.u10 == 0 || this.u8 == 0x4800000 && this.u9 == 0x1020000 && this.u10 == 0) {
            this.convertee.u1 = 0;
            this.convertee.coltype = (short)1024;
            this.convertee.flagsdetect = 0;
            this.convertee.flagsrespond = 131072;
            this.convertee.u2 = 0;
            this.convertee.u3 = 0;
            this.convertee.group = new HsBitVector(4);
        } else {
            m.msg("Skipping physics: type=", Integer.toString(this.type) + ";f8=" + this.f8.toString() + ";u8=0x" + Integer.toHexString(this.u8) + ";u9=0x" + Integer.toHexString(this.u9) + ";u10=0x" + Integer.toHexString(this.u10) + ";u11=" + Integer.toString(this.u11) + ";u12=0x" + Integer.toHexString(this.u12) + ";u13=" + Short.toString(this.u13) + ";object=" + c.curRootObject.toString());
            boolean skipPhysics = false;
            if (skipPhysics) {
                throw new readexception("ODEPhysical: unhandled case.");
            }
        }
    }

    @Override
    public void compile(Bytedeque c) {
        m.warn("compile not implemented.", this.toString());
        m.warn("not tested with pots.", this.toString());
    }

    public void compileSpecial(Bytedeque c) {
        this.convertee.parent.compile(c);
        this.convertee.position.compile(c);
        this.convertee.orientation.compile(c);
        this.convertee.mass.compile(c);
        this.convertee.RC.compile(c);
        this.convertee.EL.compile(c);
        c.writeInt(this.convertee.format);
        c.writeShort(this.convertee.u1);
        c.writeShort(this.convertee.coltype);
        c.writeInt(this.convertee.flagsdetect);
        c.writeInt(this.convertee.flagsrespond);
        c.writeByte(this.convertee.u2);
        c.writeByte(this.convertee.u3);
        if (this.type == 6) {
            Vertex offset = plODEPhysical.findOffsetVectorFromSceneObject(c.prp, this.sceneobject);
            Flt wha1 = this.f6a;
            Flt wha2 = this.f6b;
            boolean bl = false;
        } else if (this.type == 5) {
            c.writeInt(this.vertexcount);
            e.ensure(this.vertices.length == this.vertexcount);
            c.writeArray(this.vertices);
            c.writeInt(this.surfacecount);
            for (int point : this.surfaces) {
                short point2 = (short)point;
                c.writeShort(point2);
            }
        } else if (this.type == 1) {
            Vertex center = plODEPhysical.findOffsetVectorFromSceneObject(c.prp, this.sceneobject);
            m.msg("Resizing boxes in ODEPhysical...");
            Vertex cornervector = new Vertex(this.f1.mult(0.5f), this.f2.mult(0.5f), this.f3.mult(0.5f));
            int vertexcount = 8;
            int facecount = 12;
            ICompilable[] vertices = new Vertex[]{new Vertex(center.x.sub(cornervector.x), center.y.sub(cornervector.y), center.z.sub(cornervector.z)), new Vertex(center.x.add(cornervector.x), center.y.sub(cornervector.y), center.z.sub(cornervector.z)), new Vertex(center.x.sub(cornervector.x), center.y.add(cornervector.y), center.z.sub(cornervector.z)), new Vertex(center.x.add(cornervector.x), center.y.add(cornervector.y), center.z.sub(cornervector.z)), new Vertex(center.x.sub(cornervector.x), center.y.sub(cornervector.y), center.z.add(cornervector.z)), new Vertex(center.x.add(cornervector.x), center.y.sub(cornervector.y), center.z.add(cornervector.z)), new Vertex(center.x.sub(cornervector.x), center.y.add(cornervector.y), center.z.add(cornervector.z)), new Vertex(center.x.add(cornervector.x), center.y.add(cornervector.y), center.z.add(cornervector.z))};
            short[] faces = new short[]{0, 2, 1, 1, 2, 3, 0, 1, 4, 1, 5, 4, 0, 4, 2, 2, 4, 6, 1, 3, 7, 7, 5, 1, 3, 2, 7, 2, 6, 7, 4, 7, 6, 4, 5, 7};
            e.ensure(vertices.length == vertexcount);
            e.ensure(faces.length == facecount * 3);
            c.writeInt(vertexcount);
            c.writeArray(vertices);
            c.writeInt(facecount);
            c.writeShorts(faces);
        } else if (this.type == 2) {
            Vertex offset = plODEPhysical.findOffsetVectorFromSceneObject(c.prp, this.sceneobject);
            offset.compile(c);
            this.u4.compile(c);
        } else {
            m.err("cricial error: ODEPhysical: currently unable to compile this type");
        }
        this.convertee.sceneobject.compile(c);
        this.convertee.group.compile(c);
        this.convertee.scenenode.compile(c);
        c.writeInt(this.convertee.LOSDB);
        this.convertee.subworld.compile(c);
        this.convertee.soundgroup.compile(c);
    }

    public static Vertex findOffsetVectorFromSceneObject(prpfile prp, Uruobjectref sceneobject) {
        e.ensure(prp != null);
        e.ensure(sceneobject.hasref());
        PrpRootObject a = prp.findObjectWithDesc(sceneobject.xdesc);
        e.ensure(a.header.objecttype == Typeid.plSceneObject);
        plSceneObject b2 = (plSceneObject)a.castTo();
        Uruobjectref d = b2.coordinateinterface;
        e.ensure(d.hasref());
        PrpRootObject f = prp.findObjectWithDesc(d.xdesc);
        plCoordinateInterface g = (plCoordinateInterface)f.castTo();
        Vertex offset = g.localToParent.convertTo3Vector();
        return offset;
    }
}

