/*
 * Decompiled with CFR 0.152.
 */
package onliner;

import auto.AllGames;
import cpythoncompiler.Compiler;
import difflib.DiffUtils;
import difflib.Patch;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import onliner.patches;
import prpobjects.pakfile;
import pythondec.pycfile;
import shared.Format;
import shared.b;
import shared.m;

public class Python {
    public static boolean CheckForProblems(String pakfile2) {
        int pythonVersion = 22;
        boolean success = true;
        pakfile pak = pakfile.create(pakfile2, AllGames.getPots());
        List<pycfile> pycs = pak.extractPakFile(true);
        for (pycfile pyc : pycs) {
            String filename = pyc.filename;
            pyc.disassemble();
            pyc.decompile();
            String py_orig = pyc.generateSourceCode();
            for (String problem : patches.problems) {
                int ind = py_orig.indexOf(problem);
                if (ind == -1) continue;
                success = false;
                m.warn("Python problem found: ", problem, " in file: ", filename);
                m.warn("Dumping source:");
                m.msg("*********************************************");
                m.msg(py_orig);
                m.msg("*********************************************");
            }
        }
        return success;
    }

    public static byte[] PatchPak(String pakfile2) {
        int pythonVersion = 22;
        File pakfile22 = new File(pakfile2);
        boolean changed = false;
        pakfile pak = pakfile.create(pakfile2, AllGames.getPots());
        List<pycfile> pycs = pak.extractPakFile(true);
        for (pycfile pyc : pycs) {
            String py_orig;
            String filename = pyc.filename;
            pyc.disassemble();
            pyc.decompile();
            String py_new = py_orig = pyc.generateSourceCode();
            for (patches.patch patch2 : patches.patches) {
                py_new = py_new.replace(patch2.old_str, patch2.new_str);
            }
            if (py_new.equals(py_orig)) continue;
            changed = true;
            m.msg("Changed py: ", filename);
            String compiler = Compiler.FindCPythonVerFromList(22, Compiler.CommonPythonPaths);
            byte[] py_new_bs = b.StringToBytes(py_new);
            byte[] pyc_new_bs = Compiler.Compile(py_new_bs, filename, 22, compiler);
            pakfile.PythonObject pyobj = pak.findByFilename(filename);
            pyobj.rawCompiledPythonObjectData = pyc_new_bs;
        }
        if (changed) {
            m.msg("Changed pak: ", pakfile2);
            byte[] pak_new_bs = pak.compileEncrypted(Format.pots);
            return pak_new_bs;
        }
        return null;
    }

    public static void ComparePaks(String origpak, String origgamename, String newpak, String newgamename) {
        String filename;
        pakfile pak1 = pakfile.create(origpak, AllGames.get(origgamename));
        pakfile pak2 = pakfile.create(newpak, AllGames.get(newgamename));
        List<pycfile> pycs1 = pak1.extractPakFile(true);
        List<pycfile> pycs2 = pak2.extractPakFile(true);
        if (pycs1.size() != pycs2.size()) {
            // empty if block
        }
        for (pycfile pyc1 : pycs1) {
            filename = pyc1.filename;
            pycfile pyc2 = Python.Find(pycs2, filename);
            if (pyc2 == null) {
                m.msg("Python file removed: ", filename);
                continue;
            }
            pyc1.disassemble();
            pyc1.decompile();
            String py1 = pyc1.generateSourceCode();
            pyc2.disassemble();
            pyc2.decompile();
            String py2 = pyc2.generateSourceCode();
            ArrayList<String> lines1 = new ArrayList<String>();
            for (String s : py1.split("\n")) {
                lines1.add(s);
            }
            ArrayList<String> lines2 = new ArrayList<String>();
            for (String s : py2.split("\n")) {
                lines2.add(s);
            }
            Patch patch2 = DiffUtils.diff(lines1, lines2);
            int contextSize = 3;
            if (patch2.getDeltas().isEmpty()) {
                m.msg("Python file unchanged: ", filename);
                continue;
            }
            m.msg("Python file changed: ", filename);
            List<String> unififf = DiffUtils.generateUnifiedDiff("infile.py", "outfile.py", lines1, patch2, contextSize);
            for (String s : unififf) {
                m.msg(s);
            }
        }
        for (pycfile pyc2 : pycs2) {
            filename = pyc2.filename;
            pycfile pyc1 = Python.Find(pycs1, filename);
            if (pyc1 != null) continue;
            m.msg("Python file added: ", filename);
        }
    }

    private static pycfile Find(List<pycfile> pycs, String filename) {
        for (pycfile pyc : pycs) {
            if (!pyc.filename.equals(filename)) continue;
            return pyc;
        }
        return null;
    }
}

