/*
 *  Copyright (C) 2006-2024, Thomas Maier-Komor
 *
 *  This is the source code of xjobs.
 *
 *  This program is free software: you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation, either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#ifndef SETTINGS_H
#define SETTINGS_H

typedef enum { flag_off, flag_on, flag_invalid } flag_t;

extern int (*gettoken)(void);

extern flag_t ShowPID, Echo;
extern int HaveTty, Input, Stdout, Stderr, Stdin, Prompt, ExitOnError, RsrcUsage
	, InFlags, KeepTmp;
extern unsigned Lines, QLen;
extern long Limit, Pagesize;
extern const char *Script;
extern char **Env, *Path;

void parse_option_j(const char *arg);
void read_config(const char *cf);
void init_limit(void);
void init_defaults(const char *exe);
void parse_options(int argc, char **argv);
void usage(void);
void version(void);

#endif
