;; Tests for load lane operations.


(module
  (memory 1)
  (data (i32.const 0) "\00\01\02\03\04\05\06\07\08\09\0A\0B\0C\0D\0E\0F")
  (func (export "v128.load8_lane_0")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 0 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 1 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_2")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 2 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_3")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 3 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_4")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 4 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_5")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 5 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_6")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 6 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_7")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 7 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_8")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 8 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_9")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 9 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_10")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 10 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_11")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 11 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_12")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 12 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_13")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 13 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_14")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 14 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_15")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane 15 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_0_offset_0")
    (param $x v128) (result v128)
    (v128.load8_lane offset=0 0 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_1_offset_1")
    (param $x v128) (result v128)
    (v128.load8_lane offset=1 1 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_2_offset_2")
    (param $x v128) (result v128)
    (v128.load8_lane offset=2 2 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_3_offset_3")
    (param $x v128) (result v128)
    (v128.load8_lane offset=3 3 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_4_offset_4")
    (param $x v128) (result v128)
    (v128.load8_lane offset=4 4 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_5_offset_5")
    (param $x v128) (result v128)
    (v128.load8_lane offset=5 5 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_6_offset_6")
    (param $x v128) (result v128)
    (v128.load8_lane offset=6 6 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_7_offset_7")
    (param $x v128) (result v128)
    (v128.load8_lane offset=7 7 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_8_offset_8")
    (param $x v128) (result v128)
    (v128.load8_lane offset=8 8 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_9_offset_9")
    (param $x v128) (result v128)
    (v128.load8_lane offset=9 9 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_10_offset_10")
    (param $x v128) (result v128)
    (v128.load8_lane offset=10 10 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_11_offset_11")
    (param $x v128) (result v128)
    (v128.load8_lane offset=11 11 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_12_offset_12")
    (param $x v128) (result v128)
    (v128.load8_lane offset=12 12 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_13_offset_13")
    (param $x v128) (result v128)
    (v128.load8_lane offset=13 13 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_14_offset_14")
    (param $x v128) (result v128)
    (v128.load8_lane offset=14 14 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_15_offset_15")
    (param $x v128) (result v128)
    (v128.load8_lane offset=15 15 (i32.const 0) (local.get $x)))
  (func (export "v128.load8_lane_0_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 0 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_1_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 1 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_2_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 2 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_3_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 3 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_4_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 4 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_5_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 5 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_6_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 6 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_7_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 7 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_8_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 8 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_9_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 9 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_10_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 10 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_11_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 11 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_12_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 12 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_13_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 13 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_14_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 14 (local.get $address) (local.get $x)))
  (func (export "v128.load8_lane_15_align_1")
    (param $address i32) (param $x v128) (result v128)
    (v128.load8_lane align=1 15 (local.get $address) (local.get $x)))
)

(assert_return (invoke "v128.load8_lane_0" (i32.const 0)
                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_1" (i32.const 1)
                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                           (v128.const i8x16 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_2" (i32.const 2)
                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                           (v128.const i8x16 0 0 2 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_3" (i32.const 3)
                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                           (v128.const i8x16 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_4" (i32.const 4)
                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                           (v128.const i8x16 0 0 0 0 4 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_5" (i32.const 5)
                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                           (v128.const i8x16 0 0 0 0 0 5 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_6" (i32.const 6)
                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                           (v128.const i8x16 0 0 0 0 0 0 6 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_7" (i32.const 7)
                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                           (v128.const i8x16 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_8" (i32.const 8)
                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                           (v128.const i8x16 0 0 0 0 0 0 0 0 8 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_9" (i32.const 9)
                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                           (v128.const i8x16 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_10" (i32.const 10)
                                            (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                            (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 10 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_11" (i32.const 11)
                                            (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                            (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 11 0 0 0 0))
(assert_return (invoke "v128.load8_lane_12" (i32.const 12)
                                            (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                            (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 12 0 0 0))
(assert_return (invoke "v128.load8_lane_13" (i32.const 13)
                                            (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                            (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 13 0 0))
(assert_return (invoke "v128.load8_lane_14" (i32.const 14)
                                            (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                            (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14 0))
(assert_return (invoke "v128.load8_lane_15" (i32.const 15)
                                            (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                            (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15))
(assert_return (invoke "v128.load8_lane_0_offset_0" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_1_offset_1" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_2_offset_2" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 2 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_3_offset_3" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_4_offset_4" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 0 4 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_5_offset_5" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 0 0 5 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_6_offset_6" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 0 0 0 6 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_7_offset_7" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_8_offset_8" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 8 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_9_offset_9" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_10_offset_10" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 10 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_11_offset_11" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 11 0 0 0 0))
(assert_return (invoke "v128.load8_lane_12_offset_12" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 12 0 0 0))
(assert_return (invoke "v128.load8_lane_13_offset_13" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 13 0 0))
(assert_return (invoke "v128.load8_lane_14_offset_14" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14 0))
(assert_return (invoke "v128.load8_lane_15_offset_15" (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                      (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15))
(assert_return (invoke "v128.load8_lane_0_align_1" (i32.const 0)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_1_align_1" (i32.const 1)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i8x16 0 1 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_2_align_1" (i32.const 2)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i8x16 0 0 2 0 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_3_align_1" (i32.const 3)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i8x16 0 0 0 3 0 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_4_align_1" (i32.const 4)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i8x16 0 0 0 0 4 0 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_5_align_1" (i32.const 5)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i8x16 0 0 0 0 0 5 0 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_6_align_1" (i32.const 6)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i8x16 0 0 0 0 0 0 6 0 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_7_align_1" (i32.const 7)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i8x16 0 0 0 0 0 0 0 7 0 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_8_align_1" (i32.const 8)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 8 0 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_9_align_1" (i32.const 9)
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                   (v128.const i8x16 0 0 0 0 0 0 0 0 0 9 0 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_10_align_1" (i32.const 10)
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 10 0 0 0 0 0))
(assert_return (invoke "v128.load8_lane_11_align_1" (i32.const 11)
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 11 0 0 0 0))
(assert_return (invoke "v128.load8_lane_12_align_1" (i32.const 12)
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 12 0 0 0))
(assert_return (invoke "v128.load8_lane_13_align_1" (i32.const 13)
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 13 0 0))
(assert_return (invoke "v128.load8_lane_14_align_1" (i32.const 14)
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 14 0))
(assert_return (invoke "v128.load8_lane_15_align_1" (i32.const 15)
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0))
                                                    (v128.const i8x16 0 0 0 0 0 0 0 0 0 0 0 0 0 0 0 15))

;; type check
(assert_invalid  (module (memory 1)
          (func (param $x v128) (result v128)
            (v128.load8_lane 0 (local.get $x) (i32.const 0))))
  "type mismatch")

;; invalid lane index
(assert_invalid  (module (memory 1)
          (func (param $x v128) (result v128)
            (v128.load8_lane 16 (i32.const 0) (local.get $x))))
  "invalid lane index")

;; invalid memarg alignment
(assert_invalid
  (module (memory 1)
          (func (param $x v128) (result v128)
          (v128.load8_lane align=2 0 (i32.const 0) (local.get $x))))
  "alignment must not be larger than natural")