/*
 * Decompiled with CFR 0.152.
 */
package com.pholser.junit.quickcheck.generator;

import com.pholser.junit.quickcheck.generator.Generator;
import com.pholser.junit.quickcheck.internal.generator.GeneratorRepository;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.javaruntype.type.TypeParameter;

public abstract class ComponentizedGenerator<T>
extends Generator<T> {
    private final List<Generator<?>> components = new ArrayList();

    protected ComponentizedGenerator(Class<T> type) {
        super(type);
    }

    @Override
    public final boolean hasComponents() {
        return true;
    }

    @Override
    public void addComponentGenerators(List<Generator<?>> newComponents) {
        this.components.clear();
        this.components.addAll(newComponents);
    }

    public List<Generator<?>> componentGenerators() {
        return Collections.unmodifiableList(this.components);
    }

    @Override
    public boolean canGenerateForParametersOfTypes(List<TypeParameter<?>> typeParameters) {
        return this.numberOfNeededComponents() == typeParameters.size();
    }

    @Override
    public void configure(Map<Class<? extends Annotation>, Annotation> configurationsByType) {
        for (Generator<?> each : this.components) {
            each.configure(configurationsByType);
        }
    }

    @Override
    public void provideRepository(GeneratorRepository provided) {
        super.provideRepository(provided);
        for (Generator<?> each : this.components) {
            each.provideRepository(provided);
        }
    }
}

