# Index Attribute Order

## Align the index attribute order with queries:   
If you create a compound index for the columns, make sure that the query
attributes are in the same order as the index attributes, so that the DBMS
can use the index while processing the query.
If the query and index attribute orders are not aligned, then the DBMS might
be unable to use the index during query processing.

### Example

```
CREATE INDEX TelephoneBook ON Accounts(last_name, first_name)   
SELECT * FROM Accounts ORDER BY first_name, last_name
```
